/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto.cksum;

import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.cksum.AbstractCheckSumTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;
import org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import org.apache.kerby.kerberos.kerb.crypto.key.KeyMaker;

public abstract class AbstractKeyedCheckSumTypeHandler
extends AbstractCheckSumTypeHandler {
    private KeyMaker keyMaker;

    public AbstractKeyedCheckSumTypeHandler(EncryptProvider encProvider, HashProvider hashProvider, int computeSize, int outputSize) {
        super(encProvider, hashProvider, computeSize, outputSize);
    }

    protected void keyMaker(KeyMaker keyMaker) {
        this.keyMaker = keyMaker;
    }

    protected KeyMaker keyMaker() {
        return this.keyMaker;
    }

    @Override
    public byte[] checksumWithKey(byte[] data, byte[] key, int usage) throws KrbException {
        return this.checksumWithKey(data, 0, data.length, key, usage);
    }

    @Override
    public byte[] checksumWithKey(byte[] data, int start, int len, byte[] key, int usage) throws KrbException {
        byte[] tmp;
        int outputSize = this.outputSize();
        if (outputSize < (tmp = this.doChecksumWithKey(data, start, len, key, usage)).length) {
            byte[] output = new byte[outputSize];
            System.arraycopy(tmp, 0, output, 0, outputSize);
            return output;
        }
        return tmp;
    }

    protected byte[] doChecksumWithKey(byte[] data, int start, int len, byte[] key, int usage) throws KrbException {
        return new byte[0];
    }

    @Override
    public boolean verifyWithKey(byte[] data, byte[] key, int usage, byte[] checksum) throws KrbException {
        byte[] newCksum = this.checksumWithKey(data, key, usage);
        return AbstractKeyedCheckSumTypeHandler.checksumEqual(checksum, newCksum);
    }
}

