/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenTimer;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.shaded.org.apache.http.HttpEntity;
import org.apache.hadoop.shaded.org.apache.http.client.config.RequestConfig;
import org.apache.hadoop.shaded.org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.hadoop.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.hadoop.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.hadoop.shaded.org.apache.http.client.methods.HttpUriRequest;
import org.apache.hadoop.shaded.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hadoop.shaded.org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hadoop.shaded.org.apache.http.message.BasicNameValuePair;
import org.apache.hadoop.shaded.org.apache.http.util.EntityUtils;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class CredentialBasedAccessTokenProvider
extends AccessTokenProvider {
    public static final String OAUTH_CREDENTIAL_KEY = "dfs.webhdfs.oauth2.credential";
    private AccessTokenTimer timer;
    private String clientId;
    private String refreshURL;
    private String accessToken;
    private boolean initialCredentialObtained = false;

    CredentialBasedAccessTokenProvider() {
        this.timer = new AccessTokenTimer();
    }

    CredentialBasedAccessTokenProvider(Timer timer) {
        this.timer = new AccessTokenTimer(timer);
    }

    public abstract String getCredential();

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.clientId = Utils.notNull(conf, "dfs.webhdfs.oauth2.client.id");
        this.refreshURL = Utils.notNull(conf, "dfs.webhdfs.oauth2.refresh.url");
    }

    @Override
    public synchronized String getAccessToken() throws IOException {
        if (this.timer.shouldRefresh() || !this.initialCredentialObtained) {
            this.refresh();
            this.initialCredentialObtained = true;
        }
        return this.accessToken;
    }

    void refresh() throws IOException {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("client_secret", this.getCredential()));
        pairs.add(new BasicNameValuePair("grant_type", "client_credentials"));
        pairs.add(new BasicNameValuePair("client_id", this.clientId));
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpPost httpPost = new HttpPost(this.refreshURL);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new IllegalArgumentException("Received invalid http response: " + statusCode + ", text = " + EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                Map responseBody = (Map)JsonSerialization.mapReader().readValue(EntityUtils.toString((HttpEntity)response.getEntity()));
                String newExpiresIn = responseBody.get("expires_in").toString();
                this.timer.setExpiresIn(newExpiresIn);
                this.accessToken = responseBody.get("access_token").toString();
            }
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to obtain access token from credential", e);
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain access token from credential", e);
        }
    }
}

