/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.BulkDelete;
import org.apache.hadoop.fs.BulkDeleteUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.functional.Tuples;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBulkDeleteOperation
implements BulkDelete {
    private static Logger LOG = LoggerFactory.getLogger(DefaultBulkDeleteOperation.class);
    private static final int DEFAULT_PAGE_SIZE = 1;
    private final Path basePath;
    private final FileSystem fs;

    public DefaultBulkDeleteOperation(Path basePath, FileSystem fs) {
        this.basePath = Objects.requireNonNull(basePath);
        this.fs = fs;
    }

    @Override
    public int pageSize() {
        return 1;
    }

    @Override
    public Path basePath() {
        return this.basePath;
    }

    @Override
    public List<Map.Entry<Path, String>> bulkDelete(Collection<Path> paths) throws IOException, IllegalArgumentException {
        BulkDeleteUtils.validateBulkDeletePaths(paths, 1, this.basePath);
        ArrayList<Map.Entry<Path, String>> result = new ArrayList<Map.Entry<Path, String>>();
        if (!paths.isEmpty()) {
            Path pathToDelete = paths.iterator().next();
            try {
                this.fs.delete(pathToDelete, false);
            }
            catch (IOException ex) {
                LOG.debug("Couldn't delete {} - exception occurred: {}", (Object)pathToDelete, (Object)ex);
                result.add(Tuples.pair(pathToDelete, ex.toString()));
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
    }
}

