/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedCommitterFactory
extends PathOutputCommitterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NamedCommitterFactory.class);

    @Override
    public PathOutputCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        Class<? extends PathOutputCommitter> clazz = this.loadCommitterClass(context);
        LOG.debug("Using PathOutputCommitter implementation {}", clazz);
        try {
            Constructor<? extends PathOutputCommitter> ctor = clazz.getConstructor(Path.class, TaskAttemptContext.class);
            return ctor.newInstance(outputPath, context);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Failed to create " + clazz + ":" + e, e);
        }
    }

    private Class<? extends PathOutputCommitter> loadCommitterClass(JobContext context) throws IOException {
        Preconditions.checkNotNull(context, "null context");
        Configuration conf = context.getConfiguration();
        String value = conf.get("mapreduce.outputcommitter.named.classname", "");
        if (value.isEmpty()) {
            throw new IOException("No committer defined in mapreduce.outputcommitter.named.classname");
        }
        return conf.getClass("mapreduce.outputcommitter.named.classname", FileOutputCommitter.class, PathOutputCommitter.class);
    }
}

