/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.impl.prefetch.BlockManager;
import org.apache.hadoop.fs.impl.prefetch.BlockManagerParameters;
import org.apache.hadoop.fs.impl.prefetch.BufferData;
import org.apache.hadoop.fs.impl.prefetch.FilePosition;
import org.apache.hadoop.fs.impl.prefetch.PrefetchingStatistics;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamCallbacks;
import org.apache.hadoop.fs.s3a.prefetch.PrefetchOptions;
import org.apache.hadoop.fs.s3a.prefetch.S3ACachingBlockManager;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteInputStream;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteObjectReader;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ACachingInputStream
extends S3ARemoteInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3ACachingInputStream.class);
    private final int numBlocksToPrefetch;
    private final BlockManager blockManager;

    public S3ACachingInputStream(S3AReadOpContext context, PrefetchOptions prefetchOptions, S3ObjectAttributes s3Attributes, ObjectInputStreamCallbacks client, S3AInputStreamStatistics streamStatistics, Configuration conf, LocalDirAllocator localDirAllocator) {
        super(context, prefetchOptions, s3Attributes, client, streamStatistics);
        this.numBlocksToPrefetch = prefetchOptions.getPrefetchBlockCount();
        int bufferPoolSize = this.numBlocksToPrefetch + 1;
        BlockManagerParameters blockManagerParamsBuilder = new BlockManagerParameters().withFuturePool(this.getContext().getFuturePool()).withBlockData(this.getBlockData()).withBufferPoolSize(bufferPoolSize).withConf(conf).withLocalDirAllocator(localDirAllocator).withMaxBlocksCount(conf.getInt("fs.s3a.prefetch.max.blocks.count", 4)).withPrefetchingStatistics((PrefetchingStatistics)this.getS3AStreamStatistics()).withTrackerFactory((DurationTrackerFactory)this.getS3AStreamStatistics());
        this.blockManager = this.createBlockManager(blockManagerParamsBuilder, this.getReader());
        int fileSize = (int)s3Attributes.getLen();
        LOG.debug("Created caching input stream for {} (size = {})", (Object)this.getName(), (Object)fileSize);
    }

    @Override
    public void close() throws IOException {
        this.blockManager.close();
        super.close();
        LOG.info("closed: {}", (Object)this.getName());
    }

    @Override
    protected boolean ensureCurrentBuffer() throws IOException {
        int prefetchCount;
        boolean outOfOrderRead;
        if (this.isClosed()) {
            return false;
        }
        long readPos = this.getNextReadPos();
        if (!this.getBlockData().isValidOffset(readPos)) {
            return false;
        }
        FilePosition filePosition = this.getFilePosition();
        boolean bl = outOfOrderRead = !filePosition.setAbsolute(readPos);
        if (!outOfOrderRead && filePosition.buffer().hasRemaining()) {
            return true;
        }
        if (filePosition.isValid()) {
            if (filePosition.bufferFullyRead()) {
                this.blockManager.release(filePosition.data());
            } else {
                this.blockManager.requestCaching(filePosition.data());
            }
            filePosition.invalidate();
        }
        if (outOfOrderRead) {
            LOG.debug("lazy-seek({})", (Object)this.getOffsetStr(readPos));
            this.blockManager.cancelPrefetches();
            prefetchCount = 1;
        } else {
            prefetchCount = this.numBlocksToPrefetch;
        }
        int toBlockNumber = this.getBlockData().getBlockNumber(readPos);
        long startOffset = this.getBlockData().getStartOffset(toBlockNumber);
        for (int i = 1; i <= prefetchCount; ++i) {
            int b = toBlockNumber + i;
            if (b >= this.getBlockData().getNumBlocks()) continue;
            this.blockManager.requestPrefetch(b);
        }
        BufferData data = (BufferData)IOStatisticsBinding.invokeTrackingDuration((DurationTracker)this.getS3AStreamStatistics().trackDuration("stream_read_block_acquire_read"), () -> this.blockManager.get(toBlockNumber));
        filePosition.setData(data, startOffset, readPos);
        return true;
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "closed";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s%n", super.toString()));
        sb.append(this.blockManager.toString());
        return sb.toString();
    }

    protected BlockManager createBlockManager(@Nonnull BlockManagerParameters blockManagerParameters, S3ARemoteObjectReader reader) {
        return new S3ACachingBlockManager(blockManagerParameters, reader);
    }
}

