/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;

public class ActiveOperationContext {
    private final long operationId;
    private final S3AStatisticsContext statisticsContext;
    private static final AtomicLong NEXT_OPERATION_ID = new AtomicLong(0L);

    public ActiveOperationContext(long operationId, S3AStatisticsContext statisticsContext) {
        this.operationId = operationId;
        this.statisticsContext = Objects.requireNonNull(statisticsContext, "null statistics context");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ActiveOperation{");
        sb.append("operationId=").append(this.operationId);
        sb.append('}');
        return sb.toString();
    }

    public long getOperationId() {
        return this.operationId;
    }

    public S3AStatisticsContext getS3AStatisticsContext() {
        return this.statisticsContext;
    }

    protected static long newOperationId() {
        return NEXT_OPERATION_ID.incrementAndGet();
    }
}

