/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurableBase;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.WindowsGetSpaceUsed;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.net.DomainPeerServer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeVolumeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.ReconfigurationProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferServer;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.InterDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.BlockPoolTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.common.AutoCloseDataSetLock;
import org.apache.hadoop.hdfs.server.common.DataNodeLockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.MetricsLoggerTask;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolManager;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.BlockRecoveryWorker;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.CorruptMetaHeaderException;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DataNodeMXBean;
import org.apache.hadoop.hdfs.server.datanode.DataSetLockManager;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancer;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.hdfs.server.datanode.DiskFileCorruptException;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.UnexpectedReplicaStateException;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.StorageLocationChecker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.AddBlockPoolException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeDiskMetrics;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodePeerMetrics;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DataNode
extends ReconfigurableBase
implements InterDatanodeProtocol,
ClientDatanodeProtocol,
DataNodeMXBean,
ReconfigurationProtocol {
    public static final Logger LOG = LoggerFactory.getLogger(DataNode.class);
    public static final String DN_CLIENTTRACE_FORMAT = "src: %s, dest: %s, volume: %s, bytes: %s, op: %s, cliID: %s, offset: %s, srvID: %s, blockid: %s, duration(ns): %s";
    static final Logger CLIENT_TRACE_LOG;
    private static final String USAGE = "Usage: hdfs datanode [-regular | -rollback | -rollingupgrade rollback ]\n    -regular                 : Normal DataNode startup (default).\n    -rollback                : Rollback a standard or rolling upgrade.\n    -rollingupgrade rollback : Rollback a rolling upgrade operation.\n  Refer to HDFS documentation for the difference between standard\n  and rolling upgrades.";
    static final int CURRENT_BLOCK_FORMAT_VERSION = 1;
    public static final int MAX_VOLUME_FAILURE_TOLERATED_LIMIT = -1;
    public static final String MAX_VOLUME_FAILURES_TOLERATED_MSG = "should be greater than or equal to -1";
    private static final List<String> RECONFIGURABLE_PROPERTIES;
    public static final String METRICS_LOG_NAME = "DataNodeMetricsLog";
    private static final String DATANODE_HTRACE_PREFIX = "datanode.htrace.";
    private final FileIoProvider fileIoProvider;
    private static final String NETWORK_ERRORS = "networkErrors";
    volatile boolean shouldRun = true;
    volatile boolean shutdownForUpgrade = false;
    private boolean shutdownInProgress = false;
    private BlockPoolManager blockPoolManager;
    volatile FsDatasetSpi<? extends FsVolumeSpi> data = null;
    private String clusterId = null;
    final AtomicInteger xmitsInProgress = new AtomicInteger();
    Daemon dataXceiverServer = null;
    DataXceiverServer xserver = null;
    Daemon localDataXceiverServer = null;
    ShortCircuitRegistry shortCircuitRegistry = null;
    ThreadGroup threadGroup = null;
    private DNConf dnConf;
    private volatile boolean heartbeatsDisabledForTests = false;
    private volatile boolean ibrDisabledForTests = false;
    private volatile boolean cacheReportsDisabledForTests = false;
    private DataStorage storage = null;
    private DatanodeHttpServer httpServer = null;
    private int infoPort;
    private int infoSecurePort;
    DataNodeMetrics metrics;
    @Nullable
    private volatile DataNodePeerMetrics peerMetrics;
    private volatile DataNodeDiskMetrics diskMetrics;
    private InetSocketAddress streamingAddr;
    private LoadingCache<String, Map<String, Long>> datanodeNetworkCounts;
    private String hostName;
    private DatanodeID id;
    private final String fileDescriptorPassingDisabledReason;
    boolean isBlockTokenEnabled;
    BlockPoolTokenSecretManager blockPoolTokenSecretManager;
    private boolean hasAnyBlockPoolRegistered = false;
    private BlockScanner blockScanner;
    private DirectoryScanner directoryScanner = null;
    private List<ServicePlugin> plugins;
    public RPC.Server ipcServer;
    private JvmPauseMonitor pauseMonitor;
    private SecureDataNodeStarter.SecureResources secureResources = null;
    private List<StorageLocation> dataDirs;
    private final String confVersion;
    private final long maxNumberOfBlocksToLog;
    private final boolean pipelineSupportECN;
    private final boolean pipelineSupportSlownode;
    private final List<String> usersWithLocalPathAccess;
    private final boolean connectToDnViaHostname;
    ReadaheadPool readaheadPool;
    SaslDataTransferClient saslClient;
    SaslDataTransferServer saslServer;
    private ObjectName dataNodeInfoBeanName;
    private volatile long lastDiskErrorCheck;
    private String supergroup;
    private boolean isPermissionEnabled;
    private String dnUserName = null;
    private BlockRecoveryWorker blockRecoveryWorker;
    private ErasureCodingWorker ecWorker;
    private final Tracer tracer;
    private static final int NUM_CORES;
    private final double congestionRatio;
    private DiskBalancer diskBalancer;
    private DataSetLockManager dataSetLockManager;
    private final ExecutorService xferService;
    @Nullable
    private final StorageLocationChecker storageLocationChecker;
    private final DatasetVolumeChecker volumeChecker;
    private final SocketFactory socketFactory;
    private long[] oobTimeouts;
    private ScheduledThreadPoolExecutor metricsLoggerTimer;
    private long startTime = 0L;
    private DataTransferThrottler ecReconstuctReadThrottler;
    private DataTransferThrottler ecReconstuctWriteThrottler;

    @Deprecated
    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr((String)target);
    }

    private static Tracer createTracer(Configuration conf) {
        return new Tracer.Builder("DataNode").conf(TraceUtils.wrapHadoopConf((String)DATANODE_HTRACE_PREFIX, (Configuration)conf)).build();
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    @VisibleForTesting
    DataNode(Configuration conf) throws DiskChecker.DiskErrorException {
        super(conf);
        this.tracer = DataNode.createTracer(conf);
        this.fileIoProvider = new FileIoProvider(conf, this);
        this.fileDescriptorPassingDisabledReason = null;
        this.maxNumberOfBlocksToLog = 0L;
        this.confVersion = null;
        this.usersWithLocalPathAccess = null;
        this.connectToDnViaHostname = false;
        this.blockScanner = new BlockScanner(this, this.getConf());
        this.pipelineSupportECN = false;
        this.pipelineSupportSlownode = false;
        this.socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        this.dnConf = new DNConf((Configurable)this);
        this.dataSetLockManager = new DataSetLockManager(conf);
        this.initOOBTimeout();
        this.storageLocationChecker = null;
        this.volumeChecker = new DatasetVolumeChecker(conf, new Timer());
        this.xferService = HadoopExecutors.newCachedThreadPool((ThreadFactory)new Daemon.DaemonFactory());
        double congestionRationTmp = conf.getDouble("dfs.pipeline.congestion.ratio", 1.5);
        this.congestionRatio = congestionRationTmp > 0.0 ? congestionRationTmp : 1.5;
    }

    DataNode(Configuration conf, List<StorageLocation> dataDirs, StorageLocationChecker storageLocationChecker, SecureDataNodeStarter.SecureResources resources) throws IOException {
        super(conf);
        this.tracer = DataNode.createTracer(conf);
        this.fileIoProvider = new FileIoProvider(conf, this);
        this.dataSetLockManager = new DataSetLockManager(conf);
        this.blockScanner = new BlockScanner(this);
        this.lastDiskErrorCheck = 0L;
        this.maxNumberOfBlocksToLog = conf.getLong("dfs.namenode.max-num-blocks-to-log", 1000L);
        this.usersWithLocalPathAccess = Arrays.asList(conf.getTrimmedStrings("dfs.block.local-path-access.user"));
        this.connectToDnViaHostname = conf.getBoolean("dfs.datanode.use.datanode.hostname", false);
        this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
        this.pipelineSupportECN = conf.getBoolean("dfs.pipeline.ecn", false);
        this.pipelineSupportSlownode = conf.getBoolean("dfs.pipeline.slownode", false);
        this.confVersion = "core-" + conf.get("hadoop.common.configuration.version", "UNSPECIFIED") + ",hdfs-" + conf.get("hadoop.hdfs.configuration.version", "UNSPECIFIED");
        this.volumeChecker = new DatasetVolumeChecker(conf, new Timer());
        this.xferService = HadoopExecutors.newCachedThreadPool((ThreadFactory)new Daemon.DaemonFactory());
        if (conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false)) {
            String reason = DomainSocket.getLoadingFailureReason();
            if (reason != null) {
                LOG.warn("File descriptor passing is disabled because {}", (Object)reason);
                this.fileDescriptorPassingDisabledReason = reason;
            } else {
                LOG.info("File descriptor passing is enabled.");
                this.fileDescriptorPassingDisabledReason = null;
            }
        } else {
            this.fileDescriptorPassingDisabledReason = "File descriptor passing was not configured.";
            LOG.debug(this.fileDescriptorPassingDisabledReason);
        }
        this.socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        try {
            this.hostName = DataNode.getHostName(conf);
            LOG.info("Configured hostname is {}", (Object)this.hostName);
            this.startDataNode(dataDirs, resources);
        }
        catch (IOException ie) {
            this.shutdown();
            throw ie;
        }
        int dncCacheMaxSize = conf.getInt("dfs.datanode.network.counts.cache.max.size", Integer.MAX_VALUE);
        this.datanodeNetworkCounts = CacheBuilder.newBuilder().maximumSize((long)dncCacheMaxSize).build((CacheLoader)new CacheLoader<String, Map<String, Long>>(){

            public Map<String, Long> load(String key) {
                ConcurrentHashMap<String, Long> ret = new ConcurrentHashMap<String, Long>();
                ret.put(DataNode.NETWORK_ERRORS, 0L);
                return ret;
            }
        });
        this.initOOBTimeout();
        this.storageLocationChecker = storageLocationChecker;
        long ecReconstuctReadBandwidth = conf.getLongBytes("dfs.datanode.ec.reconstruct.read.bandwidthPerSec", 0L);
        long ecReconstuctWriteBandwidth = conf.getLongBytes("dfs.datanode.ec.reconstruct.write.bandwidthPerSec", 0L);
        this.ecReconstuctReadThrottler = ecReconstuctReadBandwidth > 0L ? new DataTransferThrottler(100L, ecReconstuctReadBandwidth) : null;
        this.ecReconstuctWriteThrottler = ecReconstuctWriteBandwidth > 0L ? new DataTransferThrottler(100L, ecReconstuctWriteBandwidth) : null;
        double congestionRationTmp = conf.getDouble("dfs.pipeline.congestion.ratio", 1.5);
        this.congestionRatio = congestionRationTmp > 0.0 ? congestionRationTmp : 1.5;
    }

    protected Configuration getNewConf() {
        return new HdfsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
        switch (property) {
            case "dfs.datanode.data.dir": {
                IOException rootException = null;
                LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
                this.refreshVolumes(newVal);
                String string = this.getConf().get("dfs.datanode.data.dir");
                try {
                    this.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(false).build());
                    return string;
                }
                catch (IOException e) {
                    LOG.warn("Exception while sending the block report after refreshing volumes {} to {}", new Object[]{property, newVal, e});
                    if (rootException == null) {
                        rootException = e;
                        return rootException;
                    }
                }
                finally {
                    if (rootException == null) return string;
                    throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)rootException);
                }
                catch (IOException e) {
                    try {
                        rootException = e;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(false).build());
                            throw throwable;
                        }
                        catch (IOException e2) {
                            LOG.warn("Exception while sending the block report after refreshing volumes {} to {}", new Object[]{property, newVal, e2});
                            if (rootException == null) {
                                rootException = e2;
                                return rootException;
                            }
                        }
                        finally {
                            if (rootException == null) throw throwable;
                            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)rootException);
                        }
                    }
                    try {
                        this.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(false).build());
                    }
                    catch (IOException e3) {
                        LOG.warn("Exception while sending the block report after refreshing volumes {} to {}", new Object[]{property, newVal, e3});
                        if (rootException == null) {
                            rootException = e3;
                            return rootException;
                        }
                    }
                    finally {
                        if (rootException == null) throw new ReconfigurationException(property, newVal, this.getConf().get(property));
                        throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)rootException);
                    }
                }
            }
            case "dfs.datanode.balance.max.concurrent.moves": {
                ReconfigurationException rootException = null;
                try {
                    int movers;
                    LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
                    if (newVal == null) {
                        movers = 100;
                    } else {
                        movers = Integer.parseInt(newVal);
                        if (movers <= 0) {
                            rootException = new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)new IllegalArgumentException("balancer max concurrent movers must be larger than 0"));
                        }
                    }
                    boolean success = this.xserver.updateBalancerMaxConcurrentMovers(movers);
                    if (!success) {
                        rootException = new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)new IllegalArgumentException("Could not modify concurrent moves thread count"));
                    }
                    String string = Integer.toString(movers);
                    if (rootException == null) return string;
                }
                catch (NumberFormatException nfe) {
                    try {
                        rootException = new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)nfe);
                        if (rootException == null) throw new ReconfigurationException(property, newVal, this.getConf().get(property));
                    }
                    catch (Throwable throwable) {
                        if (rootException == null) throw throwable;
                        LOG.warn(String.format("Exception in updating balancer max concurrent movers %s to %s", property, newVal), (Throwable)rootException);
                        throw rootException;
                    }
                    LOG.warn(String.format("Exception in updating balancer max concurrent movers %s to %s", property, newVal), (Throwable)rootException);
                    throw rootException;
                }
                LOG.warn(String.format("Exception in updating balancer max concurrent movers %s to %s", property, newVal), (Throwable)rootException);
                throw rootException;
            }
            case "dfs.blockreport.intervalMsec": 
            case "dfs.blockreport.split.threshold": 
            case "dfs.blockreport.initialDelay": {
                return this.reconfBlockReportParameters(property, newVal);
            }
            case "dfs.datanode.max.transfer.threads": 
            case "dfs.datanode.data.transfer.bandwidthPerSec": 
            case "dfs.datanode.data.write.bandwidthPerSec": 
            case "dfs.datanode.data.read.bandwidthPerSec": {
                return this.reconfDataXceiverParameters(property, newVal);
            }
            case "dfs.cachereport.intervalMsec": {
                return this.reconfCacheReportParameters(property, newVal);
            }
            case "dfs.datanode.peer.stats.enabled": 
            case "dfs.datanode.min.outlier.detection.nodes": 
            case "dfs.datanode.slowpeer.low.threshold.ms": 
            case "dfs.datanode.peer.metrics.min.outlier.detection.samples": {
                return this.reconfSlowPeerParameters(property, newVal);
            }
            case "dfs.datanode.fileio.profiling.sampling.percentage": 
            case "dfs.datanode.outliers.report.interval": 
            case "dfs.datanode.min.outlier.detection.disks": 
            case "dfs.datanode.slowdisk.low.threshold.ms": 
            case "dfs.datanode.max.slowdisks.to.exclude": {
                return this.reconfSlowDiskParameters(property, newVal);
            }
            case "fs.du.interval": 
            case "fs.getspaceused.jitterMillis": 
            case "fs.getspaceused.classname": {
                return this.reconfDfsUsageParameters(property, newVal);
            }
            case "dfs.disk.balancer.enabled": 
            case "dfs.disk.balancer.plan.valid.interval": {
                return this.reconfDiskBalancerParameters(property, newVal);
            }
            case "dfs.datanode.slow.io.warning.threshold.ms": {
                return this.reconfSlowIoWarningThresholdParameters(property, newVal);
            }
        }
        throw new ReconfigurationException(property, newVal, this.getConf().get(property));
    }

    private String reconfDataXceiverParameters(String property, String newVal) throws ReconfigurationException {
        String result = null;
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            if (property.equals("dfs.datanode.max.transfer.threads")) {
                Preconditions.checkNotNull((Object)this.getXferServer(), (Object)"DataXceiverServer has not been initialized.");
                int threads = newVal == null ? 4096 : Integer.parseInt(newVal);
                result = Integer.toString(threads);
                this.getXferServer().setMaxXceiverCount(threads);
            } else if (property.equals("dfs.datanode.data.transfer.bandwidthPerSec")) {
                Preconditions.checkNotNull((Object)this.getXferServer(), (Object)"DataXceiverServer has not been initialized.");
                long bandwidthPerSec = newVal == null ? 0L : Long.parseLong(newVal);
                DataTransferThrottler transferThrottler = null;
                if (bandwidthPerSec > 0L) {
                    transferThrottler = new DataTransferThrottler(bandwidthPerSec);
                } else {
                    bandwidthPerSec = 0L;
                }
                result = Long.toString(bandwidthPerSec);
                this.getXferServer().setTransferThrottler(transferThrottler);
            } else if (property.equals("dfs.datanode.data.write.bandwidthPerSec")) {
                Preconditions.checkNotNull((Object)this.getXferServer(), (Object)"DataXceiverServer has not been initialized.");
                long bandwidthPerSec = newVal == null ? 0L : Long.parseLong(newVal);
                DataTransferThrottler writeThrottler = null;
                if (bandwidthPerSec > 0L) {
                    writeThrottler = new DataTransferThrottler(bandwidthPerSec);
                } else {
                    bandwidthPerSec = 0L;
                }
                result = Long.toString(bandwidthPerSec);
                this.getXferServer().setWriteThrottler(writeThrottler);
            } else if (property.equals("dfs.datanode.data.read.bandwidthPerSec")) {
                Preconditions.checkNotNull((Object)this.getXferServer(), (Object)"DataXceiverServer has not been initialized.");
                long bandwidthPerSec = newVal == null ? 0L : Long.parseLong(newVal);
                DataTransferThrottler readThrottler = null;
                if (bandwidthPerSec > 0L) {
                    readThrottler = new DataTransferThrottler(bandwidthPerSec);
                } else {
                    bandwidthPerSec = 0L;
                }
                result = Long.toString(bandwidthPerSec);
                this.getXferServer().setReadThrottler(readThrottler);
            }
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newVal);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    private String reconfCacheReportParameters(String property, String newVal) throws ReconfigurationException {
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
            long reportInterval = newVal == null ? 10000L : Long.parseLong(newVal);
            String result = Long.toString(reportInterval);
            this.dnConf.setCacheReportInterval(reportInterval);
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newVal);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    private String reconfBlockReportParameters(String property, String newVal) throws ReconfigurationException {
        String result = null;
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            if (property.equals("dfs.blockreport.intervalMsec")) {
                Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
                long intervalMs = newVal == null ? 21600000L : Long.parseLong(newVal);
                result = Long.toString(intervalMs);
                this.dnConf.setBlockReportInterval(intervalMs);
                for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
                    if (bpos == null) continue;
                    for (BPServiceActor actor : bpos.getBPServiceActors()) {
                        actor.getScheduler().setBlockReportIntervalMs(intervalMs);
                    }
                }
            } else if (property.equals("dfs.blockreport.split.threshold")) {
                Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
                long threshold = newVal == null ? 1000000L : Long.parseLong(newVal);
                result = Long.toString(threshold);
                this.dnConf.setBlockReportSplitThreshold(threshold);
            } else if (property.equals("dfs.blockreport.initialDelay")) {
                Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
                int initialDelay = newVal == null ? 0 : Integer.parseInt(newVal);
                result = Integer.toString(initialDelay);
                this.dnConf.setInitBRDelayMs(result);
            }
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newVal);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    private String reconfSlowPeerParameters(String property, String newVal) throws ReconfigurationException {
        String result = null;
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            if (property.equals("dfs.datanode.peer.stats.enabled")) {
                Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
                if (newVal != null && !newVal.equalsIgnoreCase("true") && !newVal.equalsIgnoreCase("false")) {
                    throw new IllegalArgumentException("Not a valid Boolean value for " + property + " in reconfSlowPeerParameters");
                }
                boolean enable = newVal == null ? false : Boolean.parseBoolean(newVal);
                result = Boolean.toString(enable);
                this.dnConf.setPeerStatsEnabled(enable);
                if (enable) {
                    this.peerMetrics = DataNodePeerMetrics.create(this.getDisplayName(), this.getConf());
                }
            } else if (property.equals("dfs.datanode.min.outlier.detection.nodes")) {
                Preconditions.checkNotNull((Object)this.peerMetrics, (Object)"DataNode peer stats may be disabled.");
                long minNodes = newVal == null ? 10L : Long.parseLong(newVal);
                result = Long.toString(minNodes);
                this.peerMetrics.setMinOutlierDetectionNodes(minNodes);
            } else if (property.equals("dfs.datanode.slowpeer.low.threshold.ms")) {
                Preconditions.checkNotNull((Object)this.peerMetrics, (Object)"DataNode peer stats may be disabled.");
                long threshold = newVal == null ? 5L : Long.parseLong(newVal);
                result = Long.toString(threshold);
                this.peerMetrics.setLowThresholdMs(threshold);
            } else if (property.equals("dfs.datanode.peer.metrics.min.outlier.detection.samples")) {
                Preconditions.checkNotNull((Object)this.peerMetrics, (Object)"DataNode peer stats may be disabled.");
                long minSamples = newVal == null ? 1000L : Long.parseLong(newVal);
                result = Long.toString(minSamples);
                this.peerMetrics.setMinOutlierDetectionSamples(minSamples);
            }
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newVal);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    private String reconfSlowDiskParameters(String property, String newVal) throws ReconfigurationException {
        String result = null;
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            if (property.equals("dfs.datanode.outliers.report.interval")) {
                String reportInterval;
                Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
                result = reportInterval = newVal == null ? "30m" : newVal;
                this.dnConf.setOutliersReportIntervalMs(reportInterval);
                for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
                    if (bpos == null) continue;
                    for (BPServiceActor actor : bpos.getBPServiceActors()) {
                        actor.getScheduler().setOutliersReportIntervalMs(this.dnConf.outliersReportIntervalMs);
                    }
                }
            } else if (property.equals("dfs.datanode.fileio.profiling.sampling.percentage")) {
                Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
                int samplingPercentage = newVal == null ? 0 : Integer.parseInt(newVal);
                result = Integer.toString(samplingPercentage);
                this.dnConf.setFileIoProfilingSamplingPercentage(samplingPercentage);
                if (this.fileIoProvider != null) {
                    this.fileIoProvider.getProfilingEventHook().setSampleRangeMax(samplingPercentage);
                }
                if (samplingPercentage > 0 && this.diskMetrics == null) {
                    this.diskMetrics = new DataNodeDiskMetrics(this, this.dnConf.outliersReportIntervalMs, this.getConf());
                } else if (samplingPercentage <= 0 && this.diskMetrics != null) {
                    this.diskMetrics.shutdownAndWait();
                }
            } else if (property.equals("dfs.datanode.min.outlier.detection.disks")) {
                Preconditions.checkNotNull((Object)this.diskMetrics, (Object)"DataNode disk stats may be disabled.");
                long minDisks = newVal == null ? 5L : Long.parseLong(newVal);
                result = Long.toString(minDisks);
                this.diskMetrics.setMinOutlierDetectionDisks(minDisks);
            } else if (property.equals("dfs.datanode.slowdisk.low.threshold.ms")) {
                Preconditions.checkNotNull((Object)this.diskMetrics, (Object)"DataNode disk stats may be disabled.");
                long threshold = newVal == null ? 20L : Long.parseLong(newVal);
                result = Long.toString(threshold);
                this.diskMetrics.setLowThresholdMs(threshold);
            } else if (property.equals("dfs.datanode.max.slowdisks.to.exclude")) {
                Preconditions.checkNotNull((Object)this.diskMetrics, (Object)"DataNode disk stats may be disabled.");
                int maxSlowDisksToExclude = newVal == null ? 0 : Integer.parseInt(newVal);
                result = Integer.toString(maxSlowDisksToExclude);
                this.diskMetrics.setMaxSlowDisksToExclude(maxSlowDisksToExclude);
            }
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newVal);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    private String reconfDfsUsageParameters(String property, String newVal) throws ReconfigurationException {
        String result = null;
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            if (this.data == null) {
                LOG.debug("FsDatasetSpi has not been initialized.");
                throw new IOException("FsDatasetSpi has not been initialized");
            }
            if (property.equals("fs.du.interval")) {
                long interval = newVal == null ? 600000L : Long.parseLong(newVal);
                result = Long.toString(interval);
                List<FsVolumeImpl> volumeList = this.data.getVolumeList();
                for (FsVolumeImpl fsVolume : volumeList) {
                    Map<String, BlockPoolSlice> blockPoolSlices = fsVolume.getBlockPoolSlices();
                    for (BlockPoolSlice value : blockPoolSlices.values()) {
                        value.updateDfsUsageConfig(interval, null, null);
                    }
                }
            } else if (property.equals("fs.getspaceused.jitterMillis")) {
                long jitter = newVal == null ? 60000L : Long.parseLong(newVal);
                result = Long.toString(jitter);
                List<FsVolumeImpl> volumeList = this.data.getVolumeList();
                for (FsVolumeImpl fsVolume : volumeList) {
                    Map<String, BlockPoolSlice> blockPoolSlices = fsVolume.getBlockPoolSlices();
                    for (BlockPoolSlice value : blockPoolSlices.values()) {
                        value.updateDfsUsageConfig(null, jitter, null);
                    }
                }
            } else if (property.equals("fs.getspaceused.classname")) {
                Class klass = newVal == null ? (Shell.WINDOWS ? DU.class : WindowsGetSpaceUsed.class) : Class.forName(newVal).asSubclass(GetSpaceUsed.class);
                result = klass.getName();
                List<FsVolumeImpl> volumeList = this.data.getVolumeList();
                for (FsVolumeImpl fsVolume : volumeList) {
                    Map<String, BlockPoolSlice> blockPoolSlices = fsVolume.getBlockPoolSlices();
                    for (BlockPoolSlice value : blockPoolSlices.values()) {
                        value.updateDfsUsageConfig(null, null, klass);
                    }
                }
            }
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newVal);
            return result;
        }
        catch (IOException | ClassNotFoundException | IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    private String reconfDiskBalancerParameters(String property, String newVal) throws ReconfigurationException {
        String result = null;
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            if (property.equals("dfs.disk.balancer.enabled")) {
                if (newVal != null && !newVal.equalsIgnoreCase("true") && !newVal.equalsIgnoreCase("false")) {
                    throw new IllegalArgumentException("Not a valid Boolean value for " + property);
                }
                boolean enable = newVal == null ? true : Boolean.parseBoolean(newVal);
                this.getDiskBalancer().setDiskBalancerEnabled(enable);
                result = Boolean.toString(enable);
            } else if (property.equals("dfs.disk.balancer.plan.valid.interval")) {
                if (newVal == null) {
                    long defaultInterval = this.getConf().getTimeDuration("dfs.disk.balancer.plan.valid.interval", "1d", TimeUnit.MILLISECONDS);
                    this.getDiskBalancer().setPlanValidityInterval(defaultInterval);
                    result = "1d";
                } else {
                    long newInterval = this.getConf().getTimeDurationHelper("dfs.disk.balancer.plan.valid.interval", newVal, TimeUnit.MILLISECONDS);
                    this.getDiskBalancer().setPlanValidityInterval(newInterval);
                    result = newVal;
                }
            }
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, result);
            return result;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    private String reconfSlowIoWarningThresholdParameters(String property, String newVal) throws ReconfigurationException {
        try {
            LOG.info("Reconfiguring {} to {}", (Object)property, (Object)newVal);
            Preconditions.checkNotNull((Object)this.dnConf, (Object)"DNConf has not been initialized.");
            long slowIoWarningThreshold = newVal == null ? 300L : Long.parseLong(newVal);
            String result = Long.toString(slowIoWarningThreshold);
            this.dnConf.setDatanodeSlowIoWarningThresholdMs(slowIoWarningThreshold);
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newVal);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
    }

    public Collection<String> getReconfigurableProperties() {
        return RECONFIGURABLE_PROPERTIES;
    }

    public PipelineAck.ECN getECN() {
        if (!this.pipelineSupportECN) {
            return PipelineAck.ECN.DISABLED;
        }
        double load = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        return load > (double)NUM_CORES * this.congestionRatio ? PipelineAck.ECN.CONGESTED : PipelineAck.ECN.SUPPORTED;
    }

    public PipelineAck.SLOW getSLOWByBlockPoolId(String bpId) {
        if (!this.pipelineSupportSlownode) {
            return PipelineAck.SLOW.DISABLED;
        }
        return this.isSlownodeByBlockPoolId(bpId) ? PipelineAck.SLOW.SLOW : PipelineAck.SLOW.NORMAL;
    }

    public FileIoProvider getFileIoProvider() {
        return this.fileIoProvider;
    }

    @VisibleForTesting
    ChangedVolumes parseChangedVolumes(String newVolumes) throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.datanode.data.dir", newVolumes);
        List<StorageLocation> newStorageLocations = DataNode.getStorageLocations(conf);
        if (newStorageLocations.isEmpty()) {
            throw new IOException("No directory is specified.");
        }
        HashMap<String, StorageLocation> existingStorageLocations = new HashMap<String, StorageLocation>();
        for (StorageLocation loc : DataNode.getStorageLocations(this.getConf())) {
            existingStorageLocations.put(loc.getNormalizedUri().toString(), loc);
        }
        ChangedVolumes results = new ChangedVolumes();
        results.newLocations.addAll(newStorageLocations);
        Iterator<Storage.StorageDirectory> it = this.storage.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory dir = it.next();
            boolean found = false;
            Iterator<StorageLocation> newLocationItr = results.newLocations.iterator();
            while (newLocationItr.hasNext()) {
                StorageLocation newLocation = newLocationItr.next();
                if (!newLocation.matchesStorageDirectory(dir)) continue;
                StorageLocation oldLocation = (StorageLocation)existingStorageLocations.get(newLocation.getNormalizedUri().toString());
                if (oldLocation != null && oldLocation.getStorageType() != newLocation.getStorageType()) {
                    throw new IOException("Changing storage type is not allowed.");
                }
                newLocationItr.remove();
                results.unchangedLocations.add(newLocation);
                found = true;
                break;
            }
            if (found) continue;
            LOG.info("Deactivation request received for active volume: {}", (Object)dir.getRoot());
            results.deactivateLocations.add(StorageLocation.parse(dir.getRoot().toString()));
        }
        if (this.getFSDataset().getNumFailedVolumes() > 0) {
            for (String failedStorageLocation : this.getFSDataset().getVolumeFailureSummary().getFailedStorageLocations()) {
                boolean found = false;
                for (StorageLocation newLocation : results.newLocations) {
                    if (!newLocation.toString().equals(failedStorageLocation)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                LOG.info("Deactivation request received for failed volume: {}", (Object)failedStorageLocation);
                results.deactivateLocations.add(StorageLocation.parse(failedStorageLocation));
            }
        }
        this.validateVolumesWithSameDiskTiering(results);
        return results;
    }

    private void validateVolumesWithSameDiskTiering(ChangedVolumes changedVolumes) throws IOException {
        if (this.dnConf.getConf().getBoolean("dfs.datanode.same-disk-tiering.enabled", false) && this.data.getMountVolumeMap() != null) {
            for (StorageLocation location : changedVolumes.newLocations) {
                if (!StorageType.allowSameDiskTiering((StorageType)location.getStorageType())) continue;
                File dir = new File(location.getUri());
                while (!dir.exists()) {
                    if ((dir = dir.getParentFile()) != null) continue;
                    throw new IOException("Invalid path: " + location + ": directory does not exist");
                }
                DF df = new DF(dir, this.dnConf.getConf());
                String mount = df.getMount();
                if (!this.data.getMountVolumeMap().hasMount(mount)) continue;
                String errMsg = "Disk mount " + mount + " already has volume, when trying to add " + location + ". Please try removing mounts first or restart datanode.";
                LOG.error(errMsg);
                throw new IOException(errMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void refreshVolumes(String newVolumes) throws IOException {
        final ArrayList nsInfos = Lists.newArrayList();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            nsInfos.add(bpos.getNamespaceInfo());
        }
        DataNode dataNode = this;
        synchronized (dataNode) {
            Configuration conf = this.getConf();
            conf.set("dfs.datanode.data.dir", newVolumes);
            ExecutorService service = null;
            int numOldDataDirs = this.dataDirs.size();
            ChangedVolumes changedVolumes = this.parseChangedVolumes(newVolumes);
            StringBuilder errorMessageBuilder = new StringBuilder();
            ArrayList effectiveVolumes = Lists.newArrayList();
            for (StorageLocation storageLocation : changedVolumes.unchangedLocations) {
                effectiveVolumes.add(storageLocation.toString());
            }
            try {
                if (numOldDataDirs + this.getFSDataset().getNumFailedVolumes() + changedVolumes.newLocations.size() - changedVolumes.deactivateLocations.size() <= 0) {
                    throw new IOException("Attempt to remove all volumes.");
                }
                if (!changedVolumes.newLocations.isEmpty()) {
                    void var11_15;
                    LOG.info("Adding new volumes: {}", (Object)Joiner.on((String)",").join(changedVolumes.newLocations));
                    service = Executors.newFixedThreadPool(changedVolumes.newLocations.size());
                    ArrayList exceptions = Lists.newArrayList();
                    this.checkStorageState("refreshVolumes");
                    for (final StorageLocation location : changedVolumes.newLocations) {
                        exceptions.add(service.submit(new Callable<IOException>(){

                            @Override
                            public IOException call() {
                                try {
                                    DataNode.this.data.addVolume(location, nsInfos);
                                }
                                catch (IOException e) {
                                    return e;
                                }
                                return null;
                            }
                        }));
                    }
                    boolean bl = false;
                    while (var11_15 < changedVolumes.newLocations.size()) {
                        StorageLocation volume = changedVolumes.newLocations.get((int)var11_15);
                        Future ioExceptionFuture = (Future)exceptions.get((int)var11_15);
                        try {
                            IOException ioe = (IOException)ioExceptionFuture.get();
                            if (ioe != null) {
                                errorMessageBuilder.append(String.format("FAILED TO ADD: %s: %s%n", volume, ioe.getMessage()));
                                LOG.error("Failed to add volume: {}", (Object)volume, (Object)ioe);
                            } else {
                                effectiveVolumes.add(volume.toString());
                                LOG.info("Successfully added volume: {}", (Object)volume);
                            }
                        }
                        catch (Exception e) {
                            errorMessageBuilder.append(String.format("FAILED to ADD: %s: %s%n", volume, e.toString()));
                            LOG.error("Failed to add volume: {}", (Object)volume, (Object)e);
                        }
                        ++var11_15;
                    }
                }
                try {
                    this.removeVolumes(changedVolumes.deactivateLocations);
                }
                catch (IOException e) {
                    errorMessageBuilder.append(e.getMessage());
                    LOG.error("Failed to remove volume", (Throwable)e);
                }
                if (errorMessageBuilder.length() > 0) {
                    throw new IOException(errorMessageBuilder.toString());
                }
            }
            finally {
                if (service != null) {
                    service.shutdown();
                }
                conf.set("dfs.datanode.data.dir", Joiner.on((String)",").join((Iterable)effectiveVolumes));
                this.dataDirs = DataNode.getStorageLocations(conf);
            }
        }
    }

    private void removeVolumes(Collection<StorageLocation> locations) throws IOException {
        if (locations.isEmpty()) {
            return;
        }
        this.removeVolumes(locations, true);
    }

    private synchronized void removeVolumes(Collection<StorageLocation> storageLocations, boolean clearFailure) throws IOException {
        if (storageLocations.isEmpty()) {
            return;
        }
        LOG.info(String.format("Deactivating volumes (clear failure=%b): %s", clearFailure, Joiner.on((String)",").join(storageLocations)));
        IOException ioe = null;
        this.checkStorageState("removeVolumes");
        this.data.removeVolumes(storageLocations, clearFailure);
        try {
            this.storage.removeVolumes(storageLocations);
        }
        catch (IOException e) {
            ioe = e;
        }
        Iterator<StorageLocation> it = this.dataDirs.iterator();
        while (it.hasNext()) {
            StorageLocation loc = it.next();
            if (!storageLocations.contains(loc)) continue;
            it.remove();
        }
        this.getConf().set("dfs.datanode.data.dir", Joiner.on((String)",").join(this.dataDirs));
        if (ioe != null) {
            throw ioe;
        }
    }

    private synchronized void setClusterId(String nsCid, String bpid) throws IOException {
        if (this.clusterId != null && !this.clusterId.equals(nsCid)) {
            throw new IOException("Cluster IDs not matched: dn cid=" + this.clusterId + " but ns cid=" + nsCid + "; bpid=" + bpid);
        }
        this.clusterId = nsCid;
    }

    private static String getHostName(Configuration config) throws UnknownHostException {
        String name = config.get("dfs.datanode.hostname");
        if (name == null) {
            String dnsInterface = config.get("hadoop.security.dns.interface");
            String nameServer = config.get("hadoop.security.dns.nameserver");
            boolean fallbackToHosts = false;
            if (dnsInterface == null) {
                dnsInterface = config.get("dfs.datanode.dns.interface");
                nameServer = config.get("dfs.datanode.dns.nameserver");
            } else {
                fallbackToHosts = true;
            }
            name = DNS.getDefaultHost((String)dnsInterface, (String)nameServer, (boolean)fallbackToHosts);
        }
        return name;
    }

    private void startInfoServer() throws IOException {
        ServerSocketChannel httpServerChannel = this.secureResources != null ? this.secureResources.getHttpServerChannel() : null;
        this.httpServer = new DatanodeHttpServer(this.getConf(), this, httpServerChannel);
        this.httpServer.start();
        if (this.httpServer.getHttpAddress() != null) {
            this.infoPort = this.httpServer.getHttpAddress().getPort();
        }
        if (this.httpServer.getHttpsAddress() != null) {
            this.infoSecurePort = this.httpServer.getHttpsAddress().getPort();
        }
    }

    private void startPlugins(Configuration conf) {
        try {
            this.plugins = conf.getInstances("dfs.datanode.plugins", ServicePlugin.class);
        }
        catch (RuntimeException e) {
            String pluginsValue = conf.get("dfs.datanode.plugins");
            LOG.error("Unable to load DataNode plugins. Specified list of plugins: {}", (Object)pluginsValue, (Object)e);
            throw e;
        }
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
                LOG.info("Started plug-in {}", (Object)p);
            }
            catch (Throwable t) {
                LOG.warn("ServicePlugin {} could not be started", (Object)p, (Object)t);
            }
        }
    }

    private void initIpcServer() throws IOException {
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr((String)this.getConf().getTrimmed("dfs.datanode.ipc.address"));
        RPC.setProtocolEngine((Configuration)this.getConf(), ClientDatanodeProtocolPB.class, ProtobufRpcEngine2.class);
        ClientDatanodeProtocolServerSideTranslatorPB clientDatanodeProtocolXlator = new ClientDatanodeProtocolServerSideTranslatorPB(this);
        BlockingService service = ClientDatanodeProtocolProtos.ClientDatanodeProtocolService.newReflectiveBlockingService((ClientDatanodeProtocolProtos.ClientDatanodeProtocolService.BlockingInterface)clientDatanodeProtocolXlator);
        this.ipcServer = new RPC.Builder(this.getConf()).setProtocol(ClientDatanodeProtocolPB.class).setInstance((Object)service).setBindAddress(ipcAddr.getHostName()).setPort(ipcAddr.getPort()).setNumHandlers(this.getConf().getInt("dfs.datanode.handler.count", 10)).setVerbose(false).setSecretManager((SecretManager)this.blockPoolTokenSecretManager).build();
        ReconfigurationProtocolServerSideTranslatorPB reconfigurationProtocolXlator = new ReconfigurationProtocolServerSideTranslatorPB(this);
        service = ReconfigurationProtocolProtos.ReconfigurationProtocolService.newReflectiveBlockingService((ReconfigurationProtocolProtos.ReconfigurationProtocolService.BlockingInterface)reconfigurationProtocolXlator);
        DFSUtil.addInternalPBProtocol(this.getConf(), ReconfigurationProtocolPB.class, service, this.ipcServer);
        InterDatanodeProtocolServerSideTranslatorPB interDatanodeProtocolXlator = new InterDatanodeProtocolServerSideTranslatorPB(this);
        service = InterDatanodeProtocolProtos.InterDatanodeProtocolService.newReflectiveBlockingService(interDatanodeProtocolXlator);
        DFSUtil.addInternalPBProtocol(this.getConf(), InterDatanodeProtocolPB.class, service, this.ipcServer);
        LOG.info("Opened IPC server at {}", (Object)this.ipcServer.getListenerAddress());
        if (this.getConf().getBoolean("hadoop.security.authorization", false)) {
            this.ipcServer.refreshServiceAcl(this.getConf(), (PolicyProvider)new HDFSPolicyProvider());
        }
    }

    private void checkSuperuserPrivilege() throws IOException, AccessControlException {
        if (!this.isPermissionEnabled) {
            return;
        }
        UserGroupInformation callerUgi = Server.getRemoteUser();
        if (callerUgi == null) {
            callerUgi = UserGroupInformation.getCurrentUser();
        }
        assert (this.dnUserName != null);
        if (callerUgi.getUserName().equals(this.dnUserName)) {
            return;
        }
        if (callerUgi.getGroupsSet().contains(this.supergroup)) {
            return;
        }
        throw new AccessControlException();
    }

    private void shutdownPeriodicScanners() {
        this.shutdownDirectoryScanner();
        this.blockScanner.removeAllVolumeScanners();
    }

    private synchronized void initDirectoryScanner(Configuration conf) {
        if (this.directoryScanner != null) {
            return;
        }
        String reason = null;
        if (conf.getTimeDuration("dfs.datanode.directoryscan.interval", 21600L, TimeUnit.SECONDS) < 0L) {
            reason = "verification is turned off by configuration";
        } else if ("SimulatedFSDataset".equals(this.data.getClass().getSimpleName())) {
            reason = "verifcation is not supported by SimulatedFSDataset";
        }
        if (reason == null) {
            this.directoryScanner = new DirectoryScanner(this.data, conf);
            this.directoryScanner.start();
        } else {
            LOG.warn("Periodic Directory Tree Verification scan is disabled because {}", (Object)reason);
        }
    }

    private synchronized void shutdownDirectoryScanner() {
        if (this.directoryScanner != null) {
            this.directoryScanner.shutdown();
        }
    }

    private void initDiskBalancer(FsDatasetSpi data, Configuration conf) {
        if (this.diskBalancer != null) {
            return;
        }
        DiskBalancer.DiskBalancerMover mover = new DiskBalancer.DiskBalancerMover(data, conf);
        this.diskBalancer = new DiskBalancer(this.getDatanodeUuid(), conf, mover);
    }

    private void shutdownDiskBalancer() {
        if (this.diskBalancer != null) {
            this.diskBalancer.shutdown();
            this.diskBalancer = null;
        }
    }

    private void initDataXceiver() throws IOException {
        DomainPeerServer domainPeerServer;
        TcpPeerServer tcpPeerServer;
        if (this.secureResources != null) {
            tcpPeerServer = new TcpPeerServer(this.secureResources);
        } else {
            int backlogLength = this.getConf().getInt("ipc.server.listen.queue.size", 256);
            tcpPeerServer = new TcpPeerServer(this.dnConf.socketWriteTimeout, DataNode.getStreamingAddr(this.getConf()), backlogLength);
        }
        if (this.dnConf.getTransferSocketRecvBufferSize() > 0) {
            tcpPeerServer.setReceiveBufferSize(this.dnConf.getTransferSocketRecvBufferSize());
        }
        this.streamingAddr = tcpPeerServer.getStreamingAddr();
        LOG.info("Opened streaming server at {}", (Object)this.streamingAddr);
        this.threadGroup = new ThreadGroup("dataXceiverServer");
        this.xserver = new DataXceiverServer(tcpPeerServer, this.getConf(), this);
        this.dataXceiverServer = new Daemon(this.threadGroup, (Runnable)this.xserver);
        this.threadGroup.setDaemon(true);
        if ((this.getConf().getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false) || this.getConf().getBoolean("dfs.client.domain.socket.data.traffic", false)) && (domainPeerServer = DataNode.getDomainPeerServer(this.getConf(), this.streamingAddr.getPort())) != null) {
            this.localDataXceiverServer = new Daemon(this.threadGroup, (Runnable)new DataXceiverServer(domainPeerServer, this.getConf(), this));
            LOG.info("Listening on UNIX domain socket: {}", (Object)domainPeerServer.getBindPath());
        }
        this.shortCircuitRegistry = new ShortCircuitRegistry(this.getConf());
    }

    private static DomainPeerServer getDomainPeerServer(Configuration conf, int port) throws IOException {
        String domainSocketPath = conf.getTrimmed("dfs.domain.socket.path", "");
        if (domainSocketPath.isEmpty()) {
            if (conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false) && !conf.getBoolean("dfs.client.use.legacy.blockreader.local", false)) {
                LOG.warn("Although short-circuit local reads are configured, they are disabled because you didn't configure {}", (Object)"dfs.domain.socket.path");
            }
            return null;
        }
        if (DomainSocket.getLoadingFailureReason() != null) {
            throw new RuntimeException("Although a UNIX domain socket path is configured as " + domainSocketPath + ", we cannot start a localDataXceiverServer because " + DomainSocket.getLoadingFailureReason());
        }
        DomainPeerServer domainPeerServer = new DomainPeerServer(domainSocketPath, port);
        int recvBufferSize = conf.getInt("dfs.datanode.transfer.socket.recv.buffer.size", 0);
        if (recvBufferSize > 0) {
            domainPeerServer.setReceiveBufferSize(recvBufferSize);
        }
        return domainPeerServer;
    }

    public void notifyNamenodeReceivedBlock(ExtendedBlock block, String delHint, String storageUuid, boolean isOnTransientStorage) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeReceivedBlock(block, delHint, storageUuid, isOnTransientStorage);
        } else {
            LOG.error("Cannot find BPOfferService for reporting block received for bpid={}", (Object)block.getBlockPoolId());
        }
    }

    protected void notifyNamenodeReceivingBlock(ExtendedBlock block, String storageUuid) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeReceivingBlock(block, storageUuid);
        } else {
            LOG.error("Cannot find BPOfferService for reporting block receiving for bpid={}", (Object)block.getBlockPoolId());
        }
    }

    public void notifyNamenodeDeletedBlock(ExtendedBlock block, String storageUuid) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeDeletedBlock(block, storageUuid);
        } else {
            LOG.error("Cannot find BPOfferService for reporting block deleted for bpid=" + block.getBlockPoolId());
        }
    }

    public void reportBadBlocks(ExtendedBlock block) throws IOException {
        Object volume = this.getFSDataset().getVolume(block);
        if (volume == null) {
            LOG.warn("Cannot find FsVolumeSpi to report bad block: {}", (Object)block);
            return;
        }
        this.reportBadBlocks(block, (FsVolumeSpi)volume);
    }

    public void reportBadBlocks(ExtendedBlock block, FsVolumeSpi volume) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        bpos.reportBadBlocks(block, volume.getStorageID(), volume.getStorageType());
    }

    public void reportRemoteBadBlock(DatanodeInfo srcDataNode, ExtendedBlock block) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        bpos.reportRemoteBadBlock(srcDataNode, block);
    }

    public void reportCorruptedBlocks(DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        Map corruptionMap = corruptedBlocks.getCorruptionMap();
        if (corruptionMap != null) {
            for (Map.Entry entry : corruptionMap.entrySet()) {
                for (DatanodeInfo dnInfo : (Set)entry.getValue()) {
                    this.reportRemoteBadBlock(dnInfo, (ExtendedBlock)entry.getKey());
                }
            }
        }
    }

    private BPOfferService getBPOSForBlock(ExtendedBlock block) throws IOException {
        Preconditions.checkNotNull((Object)block);
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos == null) {
            throw new IOException("cannot locate OfferService thread for bp=" + block.getBlockPoolId());
        }
        return bpos;
    }

    @VisibleForTesting
    public void setHeartbeatsDisabledForTests(boolean heartbeatsDisabledForTests) {
        this.heartbeatsDisabledForTests = heartbeatsDisabledForTests;
    }

    @VisibleForTesting
    boolean areHeartbeatsDisabledForTests() {
        return this.heartbeatsDisabledForTests;
    }

    @VisibleForTesting
    void setIBRDisabledForTest(boolean disabled) {
        this.ibrDisabledForTests = disabled;
    }

    @VisibleForTesting
    boolean areIBRDisabledForTests() {
        return this.ibrDisabledForTests;
    }

    void setCacheReportsDisabledForTest(boolean disabled) {
        this.cacheReportsDisabledForTests = disabled;
    }

    @VisibleForTesting
    boolean areCacheReportsDisabledForTests() {
        return this.cacheReportsDisabledForTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startDataNode(List<StorageLocation> dataDirectories, SecureDataNodeStarter.SecureResources resources) throws IOException {
        this.secureResources = resources;
        DataNode dataNode = this;
        synchronized (dataNode) {
            this.dataDirs = dataDirectories;
        }
        this.dnConf = new DNConf((Configurable)this);
        DataNode.checkSecureConfig(this.dnConf, this.getConf(), resources);
        if (this.dnConf.maxLockedMemory > 0L) {
            if (!NativeIO.POSIX.getCacheManipulator().verifyCanMlock()) {
                throw new RuntimeException(String.format("Cannot start datanode because the configured max locked memory size (%s) is greater than zero and native code is not available.", "dfs.datanode.max.locked.memory"));
            }
            if (Path.WINDOWS) {
                NativeIO.Windows.extendWorkingSetSize((long)this.dnConf.maxLockedMemory);
            } else {
                long ulimit = NativeIO.POSIX.getCacheManipulator().getMemlockLimit();
                if (this.dnConf.maxLockedMemory > ulimit) {
                    throw new RuntimeException(String.format("Cannot start datanode because the configured max locked memory size (%s) of %d bytes is more than the datanode's available RLIMIT_MEMLOCK ulimit of %d bytes.", "dfs.datanode.max.locked.memory", this.dnConf.maxLockedMemory, ulimit));
                }
            }
        }
        LOG.info("Starting DataNode with maxLockedMemory = {}", (Object)this.dnConf.maxLockedMemory);
        int volFailuresTolerated = this.dnConf.getVolFailuresTolerated();
        int volsConfigured = this.dnConf.getVolsConfigured();
        if (volFailuresTolerated < -1 || volFailuresTolerated >= volsConfigured) {
            throw new HadoopIllegalArgumentException("Invalid value configured for dfs.datanode.failed.volumes.tolerated - " + volFailuresTolerated + ". Value configured is either less than -1 or >= to the number of configured volumes (" + volsConfigured + ").");
        }
        this.storage = new DataStorage();
        this.registerMXBean();
        this.initDataXceiver();
        this.startInfoServer();
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(this.getConf());
        this.pauseMonitor.start();
        this.blockPoolTokenSecretManager = new BlockPoolTokenSecretManager();
        this.dnUserName = UserGroupInformation.getCurrentUser().getUserName();
        LOG.info("dnUserName = {}", (Object)this.dnUserName);
        LOG.info("supergroup = {}", (Object)this.supergroup);
        this.initIpcServer();
        this.metrics = DataNodeMetrics.create(this.getConf(), this.getDisplayName());
        this.peerMetrics = this.dnConf.peerStatsEnabled ? DataNodePeerMetrics.create(this.getDisplayName(), this.getConf()) : null;
        this.metrics.getJvmMetrics().setPauseMonitor(this.pauseMonitor);
        this.ecWorker = new ErasureCodingWorker(this.getConf(), this);
        this.blockRecoveryWorker = new BlockRecoveryWorker(this);
        this.blockPoolManager = new BlockPoolManager(this);
        this.blockPoolManager.refreshNamenodes(this.getConf());
        this.readaheadPool = ReadaheadPool.getInstance();
        this.saslClient = new SaslDataTransferClient(this.dnConf.getConf(), this.dnConf.saslPropsResolver, this.dnConf.trustedChannelResolver);
        this.saslServer = new SaslDataTransferServer(this.dnConf, this.blockPoolTokenSecretManager);
        this.startMetricsLogger();
        if (this.dnConf.diskStatsEnabled) {
            this.diskMetrics = new DataNodeDiskMetrics(this, this.dnConf.outliersReportIntervalMs, this.getConf());
        }
    }

    private static void checkSecureConfig(DNConf dnConf, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws RuntimeException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        boolean isEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        if (!isEnabled) {
            String errMessage = "Security is enabled but block access tokens (via dfs.block.access.token.enable) aren't enabled. This may cause issues when clients attempt to connect to a DataNode. Aborting DataNode";
            throw new RuntimeException(errMessage);
        }
        if (dnConf.getIgnoreSecurePortsForTesting()) {
            return;
        }
        if (resources != null) {
            boolean rpcSecured;
            boolean httpSecured = resources.isHttpPortPrivileged() || DFSUtil.getHttpPolicy(conf) == HttpConfig.Policy.HTTPS_ONLY;
            boolean bl = rpcSecured = resources.isRpcPortPrivileged() || resources.isSaslEnabled();
            if (rpcSecured && httpSecured) {
                return;
            }
        } else {
            SaslPropertiesResolver saslPropsResolver = dnConf.getSaslPropsResolver();
            if (saslPropsResolver != null && DFSUtil.getHttpPolicy(conf) == HttpConfig.Policy.HTTPS_ONLY) {
                return;
            }
        }
        throw new RuntimeException("Cannot start secure DataNode due to incorrect config. See https://cwiki.apache.org/confluence/display/HADOOP/Secure+DataNode for details.");
    }

    public static String generateUuid() {
        return UUID.randomUUID().toString();
    }

    public SaslDataTransferClient getSaslClient() {
        return this.saslClient;
    }

    synchronized void checkDatanodeUuid() throws IOException {
        if (this.storage.getDatanodeUuid() == null) {
            this.storage.setDatanodeUuid(DataNode.generateUuid());
            this.storage.writeAll();
            LOG.info("Generated and persisted new Datanode UUID {}", (Object)this.storage.getDatanodeUuid());
        }
    }

    DatanodeRegistration createBPRegistration(NamespaceInfo nsInfo) {
        StorageInfo storageInfo = this.storage.getBPStorage(nsInfo.getBlockPoolID());
        if (storageInfo == null) {
            storageInfo = new StorageInfo(DataNodeLayoutVersion.getCurrentLayoutVersion(), nsInfo.getNamespaceID(), nsInfo.clusterID, nsInfo.getCTime(), HdfsServerConstants.NodeType.DATA_NODE);
        }
        DatanodeID dnId = new DatanodeID(this.streamingAddr.getAddress().getHostAddress(), this.hostName, this.storage.getDatanodeUuid(), this.getXferPort(), this.getInfoPort(), this.infoSecurePort, this.getIpcPort());
        return new DatanodeRegistration(dnId, storageInfo, new ExportedBlockKeys(), VersionInfo.getVersion());
    }

    synchronized void bpRegistrationSucceeded(DatanodeRegistration bpRegistration, String blockPoolId) throws IOException {
        this.id = bpRegistration;
        if (!this.storage.getDatanodeUuid().equals(bpRegistration.getDatanodeUuid())) {
            throw new IOException("Inconsistent Datanode IDs. Name-node returned " + bpRegistration.getDatanodeUuid() + ". Expecting " + this.storage.getDatanodeUuid());
        }
        this.registerBlockPoolWithSecretManager(bpRegistration, blockPoolId);
    }

    private synchronized void registerBlockPoolWithSecretManager(DatanodeRegistration bpRegistration, String blockPoolId) throws IOException {
        ExportedBlockKeys keys = bpRegistration.getExportedKeys();
        if (!this.hasAnyBlockPoolRegistered) {
            this.hasAnyBlockPoolRegistered = true;
            this.isBlockTokenEnabled = keys.isBlockTokenEnabled();
        } else if (this.isBlockTokenEnabled != keys.isBlockTokenEnabled()) {
            throw new RuntimeException("Inconsistent configuration of block access tokens. Either all block pools must be configured to use block tokens, or none may be.");
        }
        if (!this.isBlockTokenEnabled) {
            return;
        }
        if (!this.blockPoolTokenSecretManager.isBlockPoolRegistered(blockPoolId)) {
            long blockKeyUpdateInterval = keys.getKeyUpdateInterval();
            long blockTokenLifetime = keys.getTokenLifetime();
            LOG.info("Block token params received from NN: for block pool {} keyUpdateInterval={} min(s), tokenLifetime={} min(s)", new Object[]{blockPoolId, blockKeyUpdateInterval / 60000L, blockTokenLifetime / 60000L});
            boolean enableProtobuf = this.getConf().getBoolean("dfs.block.access.token.protobuf.enable", false);
            BlockTokenSecretManager secretMgr = new BlockTokenSecretManager(0L, blockTokenLifetime, blockPoolId, this.dnConf.encryptionAlgorithm, enableProtobuf);
            this.blockPoolTokenSecretManager.addBlockPool(blockPoolId, secretMgr);
        }
    }

    void shutdownBlockPool(BPOfferService bpos) {
        this.blockPoolManager.remove(bpos);
        if (bpos.hasBlockPoolId()) {
            String bpId = bpos.getBlockPoolId();
            if (this.blockScanner.hasAnyRegisteredScanner()) {
                this.blockScanner.disableBlockPoolId(bpId);
            }
            if (this.data != null) {
                this.data.shutdownBlockPool(bpId);
            }
            if (this.storage != null) {
                this.storage.removeBlockPoolStorage(bpId);
            }
        }
    }

    void initBlockPool(BPOfferService bpos) throws IOException {
        NamespaceInfo nsInfo = bpos.getNamespaceInfo();
        if (nsInfo == null) {
            throw new IOException("NamespaceInfo not found: Block pool " + bpos + " should have retrieved namespace info before initBlockPool.");
        }
        this.setClusterId(nsInfo.clusterID, nsInfo.getBlockPoolID());
        this.blockPoolManager.addBlockPool(bpos);
        this.initStorage(nsInfo);
        try {
            this.data.addBlockPool(nsInfo.getBlockPoolID(), this.getConf());
        }
        catch (AddBlockPoolException e) {
            this.handleAddBlockPoolError(e);
        }
        this.checkDiskError();
        this.blockScanner.enableBlockPoolId(bpos.getBlockPoolId());
        this.initDirectoryScanner(this.getConf());
        this.initDiskBalancer(this.data, this.getConf());
    }

    private void handleAddBlockPoolError(AddBlockPoolException e) throws IOException {
        Map<FsVolumeSpi, IOException> unhealthyDataDirs = e.getFailingVolumes();
        if (unhealthyDataDirs != null && !unhealthyDataDirs.isEmpty()) {
            this.handleVolumeFailures(unhealthyDataDirs.keySet());
        } else {
            LOG.debug("HandleAddBlockPoolError called with empty exception list");
        }
    }

    List<BPOfferService> getAllBpOs() {
        return this.blockPoolManager.getAllNamenodeThreads();
    }

    BPOfferService getBPOfferService(String bpid) {
        return this.blockPoolManager.get(bpid);
    }

    public int getBpOsCount() {
        return this.blockPoolManager.getAllNamenodeThreads().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStorage(NamespaceInfo nsInfo) throws IOException {
        FsDatasetSpi.Factory<?> factory = FsDatasetSpi.Factory.getFactory(this.getConf());
        if (!factory.isSimulated()) {
            HdfsServerConstants.StartupOption startOpt = DataNode.getStartupOption(this.getConf());
            if (startOpt == null) {
                throw new IOException("Startup option not set.");
            }
            String bpid = nsInfo.getBlockPoolID();
            DataNode dataNode = this;
            synchronized (dataNode) {
                this.storage.recoverTransitionRead(this, nsInfo, this.dataDirs, startOpt);
            }
            BlockPoolSliceStorage bpStorage = this.storage.getBPStorage(bpid);
            LOG.info("Setting up storage: nsid={};bpid={};lv={};nsInfo={};dnuuid={}", new Object[]{bpStorage.getNamespaceID(), bpid, this.storage.getLayoutVersion(), nsInfo, this.storage.getDatanodeUuid()});
        }
        this.checkDatanodeUuid();
        DataNode dataNode = this;
        synchronized (dataNode) {
            if (this.data == null) {
                this.data = factory.newInstance(this, this.storage, this.getConf());
            }
        }
    }

    public static InetSocketAddress getInfoAddr(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.http.address", "0.0.0.0:9864"));
    }

    private void registerMXBean() {
        this.dataNodeInfoBeanName = MBeans.register((String)"DataNode", (String)"DataNodeInfo", (Object)this);
    }

    @VisibleForTesting
    public DataXceiverServer getXferServer() {
        return this.xserver;
    }

    @VisibleForTesting
    public int getXferPort() {
        return this.streamingAddr.getPort();
    }

    @VisibleForTesting
    public SaslDataTransferServer getSaslServer() {
        return this.saslServer;
    }

    public String getDisplayName() {
        return this.hostName + ":" + this.getXferPort();
    }

    public InetSocketAddress getXferAddress() {
        return this.streamingAddr;
    }

    public int getIpcPort() {
        return this.ipcServer.getListenerAddress().getPort();
    }

    @VisibleForTesting
    public DatanodeRegistration getDNRegistrationForBP(String bpid) throws IOException {
        DataNodeFaultInjector.get().noRegistration();
        BPOfferService bpos = this.blockPoolManager.get(bpid);
        if (bpos == null || bpos.bpRegistration == null) {
            throw new IOException("cannot find BPOfferService for bpid=" + bpid);
        }
        return bpos.bpRegistration;
    }

    public Socket newSocket() throws IOException {
        return this.socketFactory.createSocket();
    }

    DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
        return new DatanodeProtocolClientSideTranslatorPB(nnAddr, this.getConf());
    }

    DatanodeLifelineProtocolClientSideTranslatorPB connectToLifelineNN(InetSocketAddress lifelineNnAddr) throws IOException {
        return new DatanodeLifelineProtocolClientSideTranslatorPB(lifelineNnAddr, this.getConf());
    }

    public static InterDatanodeProtocol createInterDataNodeProtocolProxy(DatanodeID datanodeid, final Configuration conf, final int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        final InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        LOG.debug("Connecting to datanode {} addr={}", (Object)dnAddr, (Object)addr);
        final UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        try {
            return (InterDatanodeProtocol)loginUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InterDatanodeProtocol>(){

                @Override
                public InterDatanodeProtocol run() throws IOException {
                    return new InterDatanodeProtocolTranslatorPB(addr, loginUgi, conf, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getMessage());
        }
    }

    public DataNodeMetrics getMetrics() {
        return this.metrics;
    }

    public DataNodeDiskMetrics getDiskMetrics() {
        return this.diskMetrics;
    }

    public DataNodePeerMetrics getPeerMetrics() {
        return this.peerMetrics;
    }

    private void checkKerberosAuthMethod(String msg) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (UserGroupInformation.getCurrentUser().getAuthenticationMethod() != UserGroupInformation.AuthenticationMethod.KERBEROS) {
            throw new AccessControlException("Error in " + msg + "Only kerberos based authentication is allowed.");
        }
    }

    private void checkBlockLocalPathAccess() throws IOException {
        this.checkKerberosAuthMethod("getBlockLocalPathInfo()");
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!this.usersWithLocalPathAccess.contains(currentUser)) {
            throw new AccessControlException("Can't continue with getBlockLocalPathInfo() authorization. The user " + currentUser + " is not configured in " + "dfs.block.local-path-access.user");
        }
    }

    public long getMaxNumberOfBlocksToLog() {
        return this.maxNumberOfBlocksToLog;
    }

    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block, Token<BlockTokenIdentifier> token) throws IOException {
        this.checkBlockLocalPathAccess();
        this.checkBlockToken(block, token, BlockTokenIdentifier.AccessMode.READ);
        this.checkStorageState("getBlockLocalPathInfo");
        BlockLocalPathInfo info = this.data.getBlockLocalPathInfo(block);
        if (info != null) {
            LOG.trace("getBlockLocalPathInfo successful block={} blockfile {} metafile {}", new Object[]{block, info.getBlockPath(), info.getMetaPath()});
        } else {
            LOG.trace("getBlockLocalPathInfo for block={} returning null", (Object)block);
        }
        this.metrics.incrBlocksGetLocalPathInfo();
        return info;
    }

    FileInputStream[] requestShortCircuitFdsForRead(ExtendedBlock blk, Token<BlockTokenIdentifier> token, int maxVersion) throws ShortCircuitFdsUnsupportedException, ShortCircuitFdsVersionException, IOException {
        if (this.fileDescriptorPassingDisabledReason != null) {
            throw new ShortCircuitFdsUnsupportedException(this.fileDescriptorPassingDisabledReason);
        }
        int blkVersion = 1;
        if (maxVersion < blkVersion) {
            throw new ShortCircuitFdsVersionException("Your client is too old to read this block!  Its format version is " + blkVersion + ", but the highest format version you can read is " + maxVersion);
        }
        this.metrics.incrBlocksGetLocalPathInfo();
        FileInputStream[] fis = new FileInputStream[2];
        try {
            this.checkStorageState("requestShortCircuitFdsForRead");
            fis[0] = (FileInputStream)this.data.getBlockInputStream(blk, 0L);
            fis[1] = DatanodeUtil.getMetaDataInputStream(blk, this.data);
        }
        catch (ClassCastException e) {
            LOG.debug("requestShortCircuitFdsForRead failed", (Throwable)e);
            throw new ShortCircuitFdsUnsupportedException("This DataNode's FsDatasetSpi does not support short-circuit local reads");
        }
        return fis;
    }

    private void checkBlockToken(ExtendedBlock block, Token<BlockTokenIdentifier> token, BlockTokenIdentifier.AccessMode accessMode) throws IOException {
        if (this.isBlockTokenEnabled) {
            BlockTokenIdentifier id = new BlockTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields((DataInput)in);
            LOG.debug("BlockTokenIdentifier id: {}", (Object)id);
            this.blockPoolTokenSecretManager.checkAccess(id, null, block, accessMode, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<BPOfferService> bposArray;
        this.stopMetricsLogger();
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                    LOG.info("Stopped plug-in {}", (Object)p);
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin {} could not be stopped", (Object)p, (Object)t);
                }
            }
        }
        List<Object> list = bposArray = this.blockPoolManager == null ? new ArrayList() : this.blockPoolManager.getAllNamenodeThreads();
        if (!this.shutdownForUpgrade) {
            this.shouldRun = false;
        }
        if (this.dataXceiverServer != null) {
            try {
                this.xserver.sendOOBToPeers();
                ((DataXceiverServer)this.dataXceiverServer.getRunnable()).kill();
                this.dataXceiverServer.interrupt();
            }
            catch (Exception e) {
                LOG.trace("Exception interrupting DataXceiverServer", (Throwable)e);
            }
        }
        long timeNotified = Time.monotonicNow();
        if (this.localDataXceiverServer != null) {
            ((DataXceiverServer)this.localDataXceiverServer.getRunnable()).kill();
            this.localDataXceiverServer.interrupt();
        }
        this.shutdownPeriodicScanners();
        this.shutdownDiskBalancer();
        if (this.httpServer != null) {
            try {
                this.httpServer.close();
            }
            catch (Exception e) {
                LOG.warn("Exception shutting down DataNode HttpServer", (Throwable)e);
            }
        }
        this.volumeChecker.shutdownAndWait(1, TimeUnit.SECONDS);
        if (this.storageLocationChecker != null) {
            this.storageLocationChecker.shutdownAndWait(1, TimeUnit.SECONDS);
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        this.shouldRun = false;
        this.shutdownReconfigurationTask();
        LOG.info("Waiting up to 30 seconds for transfer threads to complete");
        HadoopExecutors.shutdown((ExecutorService)this.xferService, (Logger)LOG, (long)15L, (TimeUnit)TimeUnit.SECONDS);
        if (this.threadGroup != null) {
            int sleepMs = 2;
            while (true) {
                if (!this.shutdownForUpgrade || this.shutdownForUpgrade && Time.monotonicNow() - timeNotified > 1000L) {
                    this.threadGroup.interrupt();
                    break;
                }
                LOG.info("Waiting for threadgroup to exit, active threads is {}", (Object)this.threadGroup.activeCount());
                if (this.threadGroup.activeCount() == 0) break;
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((sleepMs = sleepMs * 3 / 2) <= 200) continue;
                sleepMs = 200;
            }
            this.threadGroup = null;
        }
        if (this.dataXceiverServer != null) {
            try {
                this.dataXceiverServer.join();
            }
            catch (InterruptedException sleepMs) {
                // empty catch block
            }
        }
        if (this.localDataXceiverServer != null) {
            try {
                this.localDataXceiverServer.join();
            }
            catch (InterruptedException sleepMs) {
                // empty catch block
            }
        }
        if (this.metrics != null) {
            this.metrics.setDataNodeActiveXceiversCount(0);
            this.metrics.setDataNodeReadActiveXceiversCount(0);
            this.metrics.setDataNodeWriteActiveXceiversCount(0);
            this.metrics.setDataNodePacketResponderCount(0);
            this.metrics.setDataNodeBlockRecoveryWorkerCount(0);
        }
        if (this.ipcServer != null) {
            this.ipcServer.stop();
        }
        if (this.ecWorker != null) {
            this.ecWorker.shutDown();
        }
        if (this.blockPoolManager != null) {
            try {
                this.blockPoolManager.shutDownAll(bposArray);
            }
            catch (InterruptedException ie) {
                LOG.warn("Received exception in BlockPoolManager#shutDownAll", (Throwable)ie);
            }
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException ie) {
                LOG.warn("Exception when unlocking storage", (Throwable)ie);
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        if (this.dnConf.diskStatsEnabled && this.diskMetrics != null) {
            this.diskMetrics.shutdownAndWait();
        }
        if (this.dataNodeInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.dataNodeInfoBeanName);
            this.dataNodeInfoBeanName = null;
        }
        if (this.shortCircuitRegistry != null) {
            this.shortCircuitRegistry.shutdown();
        }
        LOG.info("Shutdown complete.");
        DataNode dataNode = this;
        synchronized (dataNode) {
            this.shouldRun = false;
            this.notifyAll();
        }
        this.tracer.close();
        this.dataSetLockManager.lockLeakCheck();
    }

    public void checkDiskErrorAsync(FsVolumeSpi volume) {
        this.volumeChecker.checkVolume(volume, (healthyVolumes, failedVolumes) -> {
            if (failedVolumes.size() > 0) {
                LOG.warn("checkDiskErrorAsync callback got {} failed volumes: {}", (Object)failedVolumes.size(), (Object)failedVolumes);
            } else {
                LOG.debug("checkDiskErrorAsync: no volume failures detected");
            }
            this.lastDiskErrorCheck = Time.monotonicNow();
            this.handleVolumeFailures(failedVolumes);
        });
    }

    private void handleDiskError(String failedVolumes, int failedNumber) {
        boolean hasEnoughResources = this.data.hasEnoughResource();
        LOG.warn("DataNode.handleDiskError on: [{}] Keep Running: {}", (Object)failedVolumes, (Object)hasEnoughResources);
        int dpError = hasEnoughResources ? 1 : 3;
        this.metrics.incrVolumeFailures(failedNumber);
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            bpos.trySendErrorReport(dpError, failedVolumes);
        }
        if (hasEnoughResources) {
            this.scheduleAllBlockReport(0L);
            return;
        }
        LOG.warn("DataNode is shutting down due to failed volumes: [{}]", (Object)failedVolumes);
        this.shouldRun = false;
    }

    @Override
    public int getXceiverCount() {
        if (this.metrics == null) {
            return 0;
        }
        return this.metrics.getDataNodeActiveXceiverCount();
    }

    @Override
    public int getActiveTransferThreadCount() {
        if (this.metrics == null) {
            return 0;
        }
        return this.metrics.getDataNodeActiveXceiverCount() + this.metrics.getDataNodePacketResponderCount() + this.metrics.getDataNodeBlockRecoveryWorkerCount();
    }

    @Override
    public Map<String, Map<String, Long>> getDatanodeNetworkCounts() {
        return this.datanodeNetworkCounts.asMap();
    }

    void incrDatanodeNetworkErrors(String host) {
        this.metrics.incrDatanodeNetworkErrors();
        try {
            ((Map)this.datanodeNetworkCounts.get((Object)host)).compute(NETWORK_ERRORS, (key, errors) -> errors == null ? 1L : errors + 1L);
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to increment network error counts for host: {}", (Object)host);
        }
    }

    @Override
    public int getXmitsInProgress() {
        return this.xmitsInProgress.get();
    }

    public void incrementXmitsInProgress() {
        this.xmitsInProgress.getAndIncrement();
    }

    public void incrementXmitsInProcess(int delta) {
        Preconditions.checkArgument((delta >= 0 ? 1 : 0) != 0);
        this.xmitsInProgress.getAndAdd(delta);
    }

    public void decrementXmitsInProgress() {
        this.xmitsInProgress.getAndDecrement();
    }

    public void decrementXmitsInProgress(int delta) {
        Preconditions.checkArgument((delta >= 0 ? 1 : 0) != 0);
        this.xmitsInProgress.getAndAdd(0 - delta);
    }

    private void reportBadBlock(BPOfferService bpos, ExtendedBlock block, String msg) {
        Object volume = this.getFSDataset().getVolume(block);
        if (volume == null) {
            LOG.warn("Cannot find FsVolumeSpi to report bad block: {}", (Object)block);
            return;
        }
        bpos.reportBadBlocks(block, volume.getStorageID(), volume.getStorageType());
        LOG.warn(msg);
    }

    @VisibleForTesting
    void transferBlock(ExtendedBlock block, DatanodeInfo[] xferTargets, StorageType[] xferTargetStorageTypes, String[] xferTargetStorageIDs) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        DatanodeRegistration bpReg = this.getDNRegistrationForBP(block.getBlockPoolId());
        boolean replicaNotExist = false;
        boolean replicaStateNotFinalized = false;
        boolean blockFileNotExist = false;
        boolean lengthTooShort = false;
        try {
            this.data.checkBlock(block, block.getNumBytes(), HdfsServerConstants.ReplicaState.FINALIZED);
        }
        catch (ReplicaNotFoundException e) {
            replicaNotExist = true;
        }
        catch (UnexpectedReplicaStateException e) {
            replicaStateNotFinalized = true;
        }
        catch (FileNotFoundException e) {
            blockFileNotExist = true;
        }
        catch (EOFException e) {
            lengthTooShort = true;
        }
        catch (IOException e) {
            blockFileNotExist = true;
        }
        if (replicaNotExist || replicaStateNotFinalized) {
            String errStr = "Can't send invalid block " + block;
            LOG.info(errStr);
            bpos.trySendErrorReport(2, errStr);
            return;
        }
        if (blockFileNotExist) {
            this.reportBadBlock(bpos, block, "Can't replicate block " + block + " because the block file doesn't exist, or is not accessible");
            return;
        }
        if (lengthTooShort) {
            this.reportBadBlock(bpos, block, "Can't replicate block " + block + " because on-disk length " + this.data.getLength(block) + " is shorter than NameNode recorded length " + block.getNumBytes());
            return;
        }
        int numTargets = xferTargets.length;
        if (numTargets > 0) {
            String xferTargetsString = StringUtils.join((CharSequence)" ", Arrays.asList(xferTargets));
            LOG.info("{} Starting thread to transfer {} to {}", new Object[]{bpReg, block, xferTargetsString});
            DataTransfer dataTransferTask = new DataTransfer(xferTargets, xferTargetStorageTypes, xferTargetStorageIDs, block, BlockConstructionStage.PIPELINE_SETUP_CREATE, "");
            this.xferService.execute(dataTransferTask);
        }
    }

    void transferBlocks(String poolId, Block[] blocks, DatanodeInfo[][] xferTargets, StorageType[][] xferTargetStorageTypes, String[][] xferTargetStorageIDs) {
        for (int i = 0; i < blocks.length; ++i) {
            try {
                this.transferBlock(new ExtendedBlock(poolId, blocks[i]), xferTargets[i], xferTargetStorageTypes[i], xferTargetStorageIDs[i]);
                continue;
            }
            catch (IOException ie) {
                LOG.warn("Failed to transfer block {}", (Object)blocks[i], (Object)ie);
            }
        }
    }

    public Token<BlockTokenIdentifier> getBlockAccessToken(ExtendedBlock b, EnumSet<BlockTokenIdentifier.AccessMode> mode, StorageType[] storageTypes, String[] storageIds) throws IOException {
        Token<BlockTokenIdentifier> accessToken = BlockTokenSecretManager.DUMMY_TOKEN;
        if (this.isBlockTokenEnabled) {
            accessToken = this.blockPoolTokenSecretManager.generateToken(b, mode, storageTypes, storageIds);
        }
        return accessToken;
    }

    public DataEncryptionKeyFactory getDataEncryptionKeyFactoryForBlock(final ExtendedBlock block) {
        return new DataEncryptionKeyFactory(){

            public DataEncryptionKey newDataEncryptionKey() {
                return ((DataNode)DataNode.this).dnConf.encryptDataTransfer ? DataNode.this.blockPoolTokenSecretManager.generateDataEncryptionKey(block.getBlockPoolId()) : null;
            }
        };
    }

    void closeBlock(ExtendedBlock block, String delHint, String storageUuid, boolean isTransientStorage) {
        this.metrics.incrBlocksWritten();
        this.notifyNamenodeReceivedBlock(block, delHint, storageUuid, isTransientStorage);
    }

    public void runDatanodeDaemon() throws IOException {
        if (!this.isDatanodeUp()) {
            throw new IOException("Failed to instantiate DataNode.");
        }
        this.dataXceiverServer.start();
        if (this.localDataXceiverServer != null) {
            this.localDataXceiverServer.start();
        }
        this.ipcServer.setTracer(this.tracer);
        this.ipcServer.start();
        this.startTime = Time.now();
        this.startPlugins(this.getConf());
    }

    public boolean isDatanodeUp() {
        for (BPOfferService bp : this.blockPoolManager.getAllNamenodeThreads()) {
            if (!bp.isAlive()) continue;
            return true;
        }
        return false;
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.instantiateDataNode(args, conf, null);
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if (args != null) {
            GenericOptionsParser hParser = new GenericOptionsParser(conf, args);
            args = hParser.getRemainingArgs();
        }
        if (!DataNode.parseArguments(args, conf)) {
            DataNode.printUsage(System.err);
            return null;
        }
        List<StorageLocation> dataLocations = DataNode.getStorageLocations(conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"dfs.datanode.keytab.file", (String)"dfs.datanode.kerberos.principal", (String)DataNode.getHostName(conf));
        return DataNode.makeInstance(dataLocations, conf, resources);
    }

    private static String getEffectiveFileSystem(String path, Configuration conf) {
        try {
            DF df = new DF(new File(path), conf);
            return df.getFilesystem();
        }
        catch (IOException ioe) {
            LOG.error("Failed to get filesystem for dir {}", (Object)path, (Object)ioe);
            return null;
        }
    }

    private static boolean checkFileSystemWithConfigured(Configuration conf, StorageLocation location) {
        String effectiveFs;
        String configFs = StorageType.getConf((Configuration)conf, (StorageType)location.getStorageType(), (String)"filesystem");
        if (!(configFs == null || configFs.isEmpty() || (effectiveFs = DataNode.getEffectiveFileSystem(location.getUri().getPath(), conf)) != null && effectiveFs.equals(configFs))) {
            LOG.error("Filesystem mismatch for storage location {}. Configured is {}, effective is {}.", new Object[]{location.getUri(), configFs, effectiveFs});
            return false;
        }
        return true;
    }

    public static List<StorageLocation> getStorageLocations(Configuration conf) {
        Collection rawLocations = conf.getTrimmedStringCollection("dfs.datanode.data.dir");
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>(rawLocations.size());
        for (String locationString : rawLocations) {
            StorageLocation location;
            try {
                location = StorageLocation.parse(locationString);
            }
            catch (IOException | SecurityException ioe) {
                LOG.error("Failed to initialize storage directory {}.Exception details: {}", (Object)locationString, (Object)ioe.toString());
                continue;
            }
            if (!DataNode.checkFileSystemWithConfigured(conf, location)) continue;
            locations.add(location);
        }
        return locations;
    }

    @VisibleForTesting
    public static DataNode createDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.createDataNode(args, conf, null);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static DataNode createDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        DataNode dn = DataNode.instantiateDataNode(args, conf, resources);
        if (dn != null) {
            dn.runDatanodeDaemon();
        }
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void join() {
        while (this.shouldRun) {
            try {
                this.blockPoolManager.joinAll();
                if (this.blockPoolManager.getAllNamenodeThreads().size() == 0) {
                    this.shouldRun = false;
                }
                DataNode dataNode = this;
                synchronized (dataNode) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn("Received exception in Datanode#join: {}", (Object)ex.toString());
            }
        }
    }

    static DataNode makeInstance(Collection<StorageLocation> dataDirs, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        List<StorageLocation> locations;
        StorageLocationChecker storageLocationChecker = new StorageLocationChecker(conf, new Timer());
        try {
            locations = storageLocationChecker.check(conf, dataDirs);
        }
        catch (InterruptedException ie) {
            throw new IOException("Failed to instantiate DataNode", ie);
        }
        DefaultMetricsSystem.initialize((String)"DataNode");
        assert (locations.size() > 0) : "number of data directories should be > 0";
        return new DataNode(conf, locations, storageLocationChecker, resources);
    }

    public String toString() {
        return "DataNode{data=" + this.data + ", localName='" + this.getDisplayName() + "', datanodeUuid='" + this.storage.getDatanodeUuid() + "', xmitsInProgress=" + this.xmitsInProgress.get() + "}";
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: hdfs datanode [-regular | -rollback | -rollingupgrade rollback ]\n    -regular                 : Normal DataNode startup (default).\n    -rollback                : Rollback a standard or rolling upgrade.\n    -rollingupgrade rollback : Rollback a rolling upgrade operation.\n  Refer to HDFS documentation for the difference between standard\n  and rolling upgrades.\n");
    }

    @VisibleForTesting
    static boolean parseArguments(String[] args, Configuration conf) {
        HdfsServerConstants.StartupOption startOpt = HdfsServerConstants.StartupOption.REGULAR;
        int i = 0;
        if (args != null && args.length != 0) {
            String cmd;
            if ("-r".equalsIgnoreCase(cmd = args[i++]) || "--rack".equalsIgnoreCase(cmd)) {
                LOG.error("-r, --rack arguments are not supported anymore. RackID resolution is handled by the NameNode.");
                return false;
            }
            if (HdfsServerConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLBACK;
            } else if (HdfsServerConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.REGULAR;
            } else {
                return false;
            }
        }
        DataNode.setStartupOption(conf, startOpt);
        return args == null || i == args.length;
    }

    private static void setStartupOption(Configuration conf, HdfsServerConstants.StartupOption opt) {
        conf.set("dfs.datanode.startup", opt.toString());
    }

    static HdfsServerConstants.StartupOption getStartupOption(Configuration conf) {
        String value = conf.get("dfs.datanode.startup", HdfsServerConstants.StartupOption.REGULAR.toString());
        return HdfsServerConstants.StartupOption.getEnum(value);
    }

    public void scheduleAllBlockReport(long delay) {
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            bpos.scheduleBlockReport(delay);
        }
    }

    @VisibleForTesting
    public FsDatasetSpi<?> getFSDataset() {
        return this.data;
    }

    @VisibleForTesting
    public BlockScanner getBlockScanner() {
        return this.blockScanner;
    }

    @VisibleForTesting
    DirectoryScanner getDirectoryScanner() {
        return this.directoryScanner;
    }

    @VisibleForTesting
    public BlockPoolTokenSecretManager getBlockPoolTokenSecretManager() {
        return this.blockPoolTokenSecretManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secureMain(String[] args, SecureDataNodeStarter.SecureResources resources) {
        int errorCode = 0;
        try {
            StringUtils.startupShutdownMessage(DataNode.class, (String[])args, (Logger)LOG);
            DataNode datanode = DataNode.createDataNode(args, null, resources);
            if (datanode != null) {
                datanode.join();
            } else {
                errorCode = 1;
            }
        }
        catch (Throwable e) {
            LOG.error("Exception in secureMain", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        finally {
            LOG.warn("Exiting Datanode");
            ExitUtil.terminate((int)errorCode);
        }
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, USAGE, System.out, true)) {
            System.exit(0);
        }
        DataNode.secureMain(args, null);
    }

    @Override
    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        this.checkStorageState("initReplicaRecovery");
        return this.data.initReplicaRecovery(rBlock);
    }

    @Override
    public String updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newBlockId, long newLength) throws IOException {
        this.checkStorageState("updateReplicaUnderRecovery");
        Replica r = this.data.updateReplicaUnderRecovery(oldBlock, recoveryId, newBlockId, newLength);
        ExtendedBlock newBlock = new ExtendedBlock(oldBlock);
        newBlock.setGenerationStamp(recoveryId);
        newBlock.setBlockId(newBlockId);
        newBlock.setNumBytes(newLength);
        String storageID = r.getStorageUuid();
        this.notifyNamenodeReceivedBlock(newBlock, null, storageID, r.isOnTransientStorage());
        return storageID;
    }

    public long getReplicaVisibleLength(ExtendedBlock block) throws IOException {
        this.checkReadAccess(block);
        return this.data.getReplicaVisibleLength(block);
    }

    private void checkReadAccess(ExtendedBlock block) throws IOException {
        try {
            this.getDNRegistrationForBP(block.getBlockPoolId());
        }
        catch (IOException e) {
            throw new RetriableException("Datanode not registered. Try again later.");
        }
        if (this.isBlockTokenEnabled) {
            Set tokenIds = UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            if (tokenIds.size() != 1) {
                throw new IOException("Can't continue since none or more than one BlockTokenIdentifier is found.");
            }
            for (TokenIdentifier tokenId : tokenIds) {
                BlockTokenIdentifier id = (BlockTokenIdentifier)tokenId;
                LOG.debug("BlockTokenIdentifier: {}", (Object)id);
                this.blockPoolTokenSecretManager.checkAccess(id, null, block, BlockTokenIdentifier.AccessMode.READ, null, null);
            }
        }
    }

    void transferReplicaForPipelineRecovery(ExtendedBlock b, DatanodeInfo[] targets, StorageType[] targetStorageTypes, String[] targetStorageIds, String client) throws IOException {
        long visible;
        BlockConstructionStage stage;
        try (AutoCloseDataSetLock lock = this.dataSetLockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, b.getBlockPoolId());){
            Block storedBlock = this.data.getStoredBlock(b.getBlockPoolId(), b.getBlockId());
            if (null == storedBlock) {
                throw new IOException(b + " not found in datanode.");
            }
            long storedGS = storedBlock.getGenerationStamp();
            if (storedGS < b.getGenerationStamp()) {
                throw new IOException(storedGS + " = storedGS < b.getGenerationStamp(), b=" + b);
            }
            b.setGenerationStamp(storedGS);
            if (this.data.isValidRbw(b)) {
                stage = BlockConstructionStage.TRANSFER_RBW;
                LOG.debug("Replica is being written!");
            } else if (this.data.isValidBlock(b)) {
                stage = BlockConstructionStage.TRANSFER_FINALIZED;
                LOG.debug("Replica is finalized!");
            } else {
                String r = this.data.getReplicaString(b.getBlockPoolId(), b.getBlockId());
                throw new IOException(b + " is neither a RBW nor a Finalized, r=" + r);
            }
            visible = this.data.getReplicaVisibleLength(b);
        }
        b.setNumBytes(visible);
        if (targets.length > 0) {
            if (LOG.isDebugEnabled()) {
                String xferTargetsString = StringUtils.join((CharSequence)" ", Arrays.asList(targets));
                LOG.debug("Transferring a replica to {}", (Object)xferTargetsString);
            }
            DataTransfer dataTransferTask = new DataTransfer(targets, targetStorageTypes, targetStorageIds, b, stage, client);
            Future<?> f = this.xferService.submit(dataTransferTask);
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException("Pipeline recovery for " + b + " is interrupted.", e);
            }
        }
    }

    void finalizeUpgradeForPool(String blockPoolId) throws IOException {
        this.storage.finalizeUpgrade(blockPoolId);
    }

    static InetSocketAddress getStreamingAddr(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.address", "0.0.0.0:9866"));
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public String getRpcPort() {
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr((String)this.getConf().get("dfs.datanode.ipc.address"));
        return Integer.toString(ipcAddr.getPort());
    }

    @Override
    public String getDataPort() {
        InetSocketAddress dataAddr = NetUtils.createSocketAddr((String)this.getConf().get("dfs.datanode.address"));
        return Integer.toString(dataAddr.getPort());
    }

    @Override
    public String getHttpPort() {
        return String.valueOf(this.infoPort);
    }

    @Override
    public long getDNStartedTimeInMillis() {
        return this.startTime;
    }

    public String getRevision() {
        return VersionInfo.getRevision();
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public int getInfoSecurePort() {
        return this.infoSecurePort;
    }

    @Override
    public String getNamenodeAddresses() {
        HashMap<String, String> info = new HashMap<String, String>();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bpos == null) continue;
            for (BPServiceActor actor : bpos.getBPServiceActors()) {
                info.put(actor.getNNSocketAddress().getHostName(), bpos.getBlockPoolId());
            }
        }
        return JSON.toString(info);
    }

    @Override
    public String getDatanodeHostname() {
        return this.hostName;
    }

    @Override
    public String getBPServiceActorInfo() {
        return JSON.toString(this.getBPServiceActorInfoMap());
    }

    @VisibleForTesting
    public List<Map<String, String>> getBPServiceActorInfoMap() {
        ArrayList<Map<String, String>> infoArray = new ArrayList<Map<String, String>>();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bpos == null) continue;
            for (BPServiceActor actor : bpos.getBPServiceActors()) {
                infoArray.add(actor.getActorInfoMap());
            }
        }
        return infoArray;
    }

    @Override
    public String getVolumeInfo() {
        if (this.data == null) {
            LOG.debug("Storage not yet initialized.");
            return "";
        }
        return JSON.toString(this.data.getVolumeInfoMap());
    }

    @Override
    public synchronized String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getDiskBalancerStatus() {
        try {
            return this.getDiskBalancer().queryWorkStatus().toJsonString();
        }
        catch (IOException ex) {
            LOG.debug("Reading diskbalancer Status failed.", (Throwable)ex);
            return "";
        }
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    public void refreshNamenodes(Configuration conf) throws IOException {
        this.blockPoolManager.refreshNamenodes(conf);
    }

    public void refreshNamenodes() throws IOException {
        this.checkSuperuserPrivilege();
        this.setConf(new Configuration());
        this.refreshNamenodes(this.getConf());
    }

    public void deleteBlockPool(String blockPoolId, boolean force) throws IOException {
        this.checkSuperuserPrivilege();
        LOG.info("deleteBlockPool command received for block pool {}, force={}", (Object)blockPoolId, (Object)force);
        if (this.blockPoolManager.get(blockPoolId) != null) {
            LOG.warn("The block pool {} is still running, cannot be deleted.", (Object)blockPoolId);
            throw new IOException("The block pool is still running. First do a refreshNamenodes to shutdown the block pool service");
        }
        this.checkStorageState("deleteBlockPool");
        this.data.deleteBlockPool(blockPoolId, force);
    }

    private void checkStorageState(String methodName) throws IOException {
        if (this.data == null) {
            String message = "Storage not yet initialized for " + methodName;
            LOG.debug(message);
            throw new IOException(message);
        }
    }

    public synchronized void shutdownDatanode(boolean forUpgrade) throws IOException {
        this.checkSuperuserPrivilege();
        LOG.info("shutdownDatanode command received (upgrade={}). Shutting down Datanode...", (Object)forUpgrade);
        if (this.shutdownInProgress) {
            throw new IOException("Shutdown already in progress.");
        }
        this.shutdownInProgress = true;
        this.shutdownForUpgrade = forUpgrade;
        Thread shutdownThread = new Thread("Async datanode shutdown thread"){

            @Override
            public void run() {
                if (!DataNode.this.shutdownForUpgrade) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                DataNode.this.shutdown();
            }
        };
        shutdownThread.setDaemon(true);
        shutdownThread.start();
    }

    public void evictWriters() throws IOException {
        this.checkSuperuserPrivilege();
        LOG.info("Evicting all writers.");
        this.xserver.stopWriters();
    }

    public DatanodeLocalInfo getDatanodeInfo() {
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
        return new DatanodeLocalInfo(VersionInfo.getVersion(), this.confVersion, uptime);
    }

    public void startReconfiguration() throws IOException {
        this.checkSuperuserPrivilege();
        this.startReconfigurationTask();
    }

    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        this.checkSuperuserPrivilege();
        return this.getReconfigurationTaskStatus();
    }

    public List<String> listReconfigurableProperties() throws IOException {
        this.checkSuperuserPrivilege();
        return RECONFIGURABLE_PROPERTIES;
    }

    public void triggerBlockReport(BlockReportOptions options) throws IOException {
        this.checkSuperuserPrivilege();
        InetSocketAddress namenodeAddr = options.getNamenodeAddr();
        boolean shouldTriggerToAllNn = namenodeAddr == null;
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bpos == null) continue;
            for (BPServiceActor actor : bpos.getBPServiceActors()) {
                if (!shouldTriggerToAllNn && !namenodeAddr.equals(actor.nnAddr)) continue;
                actor.triggerBlockReport(options);
            }
        }
    }

    public boolean isConnectedToNN(InetSocketAddress addr) {
        for (BPOfferService bpos : this.getAllBpOs()) {
            for (BPServiceActor bpsa : bpos.getBPServiceActors()) {
                if (!addr.equals(bpsa.getNNSocketAddress())) continue;
                return bpsa.isAlive();
            }
        }
        return false;
    }

    public boolean isBPServiceAlive(String bpid) {
        BPOfferService bp = this.blockPoolManager.get(bpid);
        return bp != null ? bp.isAlive() : false;
    }

    boolean isRestarting() {
        return this.shutdownForUpgrade;
    }

    public boolean isDatanodeFullyStarted() {
        return this.isDatanodeFullyStarted(false);
    }

    public boolean isDatanodeFullyStarted(boolean checkConnectionToActiveNamenode) {
        if (checkConnectionToActiveNamenode) {
            for (BPOfferService bp : this.blockPoolManager.getAllNamenodeThreads()) {
                if (bp.isInitialized() && bp.isAlive() && bp.getActiveNN() != null) continue;
                return false;
            }
            return true;
        }
        for (BPOfferService bp : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bp.isInitialized() && bp.isAlive()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public DatanodeID getDatanodeId() {
        return this.id;
    }

    @VisibleForTesting
    public void clearAllBlockSecretKeys() {
        this.blockPoolTokenSecretManager.clearAllKeysForTesting();
    }

    public long getBalancerBandwidth() {
        DataXceiverServer dxcs = (DataXceiverServer)this.dataXceiverServer.getRunnable();
        return dxcs.balanceThrottler.getBandwidth();
    }

    public DNConf getDnConf() {
        return this.dnConf;
    }

    public String getDatanodeUuid() {
        return this.storage == null ? null : this.storage.getDatanodeUuid();
    }

    boolean shouldRun() {
        return this.shouldRun;
    }

    @VisibleForTesting
    DataStorage getStorage() {
        return this.storage;
    }

    public ShortCircuitRegistry getShortCircuitRegistry() {
        return this.shortCircuitRegistry;
    }

    public DataTransferThrottler getEcReconstuctReadThrottler() {
        return this.ecReconstuctReadThrottler;
    }

    public DataTransferThrottler getEcReconstuctWriteThrottler() {
        return this.ecReconstuctWriteThrottler;
    }

    @VisibleForTesting
    public void checkDiskError() throws IOException {
        Set<FsVolumeSpi> unhealthyVolumes;
        try {
            unhealthyVolumes = this.volumeChecker.checkAllVolumes(this.data);
            this.lastDiskErrorCheck = Time.monotonicNow();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while running disk check", (Throwable)e);
            throw new IOException("Interrupted while running disk check", e);
        }
        if (unhealthyVolumes.size() > 0) {
            LOG.warn("checkDiskError got {} failed volumes - {}", (Object)unhealthyVolumes.size(), unhealthyVolumes);
            this.handleVolumeFailures(unhealthyVolumes);
        } else {
            LOG.debug("checkDiskError encountered no failures");
        }
    }

    private void handleVolumeFailures(Set<FsVolumeSpi> unhealthyVolumes) {
        if (unhealthyVolumes.isEmpty()) {
            LOG.debug("handleVolumeFailures done with empty unhealthyVolumes");
            return;
        }
        this.data.handleVolumeFailures(unhealthyVolumes);
        int failedNumber = unhealthyVolumes.size();
        HashSet<StorageLocation> unhealthyLocations = new HashSet<StorageLocation>(failedNumber);
        StringBuilder sb = new StringBuilder("DataNode failed volumes:");
        for (FsVolumeSpi vol : unhealthyVolumes) {
            unhealthyLocations.add(vol.getStorageLocation());
            sb.append(vol.getStorageLocation()).append(";");
        }
        try {
            this.removeVolumes(unhealthyLocations, false);
        }
        catch (IOException e) {
            LOG.warn("Error occurred when removing unhealthy storage dirs", (Throwable)e);
        }
        LOG.debug("{}", (Object)sb);
        this.handleDiskError(sb.toString(), failedNumber);
    }

    void handleBadBlock(ExtendedBlock block, IOException e, boolean fromScanner) {
        boolean isBadBlock;
        boolean bl = isBadBlock = fromScanner || e instanceof DiskFileCorruptException || e instanceof CorruptMetaHeaderException;
        if (!isBadBlock) {
            return;
        }
        if (!fromScanner && this.blockScanner.isEnabled()) {
            FsVolumeSpi volume = this.data.getVolume(block);
            if (volume == null) {
                LOG.warn("Cannot find FsVolumeSpi to handle bad block: {}", (Object)block);
                return;
            }
            this.blockScanner.markSuspectBlock(volume.getStorageID(), block);
        } else {
            try {
                this.reportBadBlocks(block);
            }
            catch (IOException ie) {
                LOG.warn("report bad block {} failed", (Object)block, (Object)ie);
            }
        }
    }

    @VisibleForTesting
    public long getLastDiskErrorCheck() {
        return this.lastDiskErrorCheck;
    }

    public BlockRecoveryWorker getBlockRecoveryWorker() {
        return this.blockRecoveryWorker;
    }

    public ErasureCodingWorker getErasureCodingWorker() {
        return this.ecWorker;
    }

    IOStreamPair connectToDN(DatanodeInfo datanodeID, int timeout, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken) throws IOException {
        return DFSUtilClient.connectToDN((DatanodeInfo)datanodeID, (int)timeout, (Configuration)this.getConf(), (SaslDataTransferClient)this.saslClient, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)this.getConf()), (boolean)false, (DataEncryptionKeyFactory)this.getDataEncryptionKeyFactoryForBlock(block), blockToken);
    }

    private void initOOBTimeout() {
        int oobStart = 8;
        int oobEnd = 11;
        int numOobTypes = 4;
        this.oobTimeouts = new long[4];
        String[] ele = this.getConf().get("dfs.datanode.oob.timeout-ms", "1500,0,0,0").split(",");
        for (int i = 0; i < 4; ++i) {
            this.oobTimeouts[i] = i < ele.length ? Long.parseLong(ele[i]) : 0L;
        }
    }

    public long getOOBTimeout(DataTransferProtos.Status status) throws IOException {
        if (status.getNumber() < 8 || status.getNumber() > 11) {
            throw new IOException("Not an OOB status: " + status);
        }
        return this.oobTimeouts[status.getNumber() - 8];
    }

    protected void startMetricsLogger() {
        long metricsLoggerPeriodSec = this.getConf().getInt("dfs.datanode.metrics.logger.period.seconds", 600);
        if (metricsLoggerPeriodSec <= 0L) {
            return;
        }
        this.metricsLoggerTimer = new ScheduledThreadPoolExecutor(1);
        this.metricsLoggerTimer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.metricsLoggerTimer.scheduleWithFixedDelay(new MetricsLoggerTask(METRICS_LOG_NAME, "DataNode", 0), metricsLoggerPeriodSec, metricsLoggerPeriodSec, TimeUnit.SECONDS);
    }

    protected void stopMetricsLogger() {
        if (this.metricsLoggerTimer != null) {
            this.metricsLoggerTimer.shutdown();
            this.metricsLoggerTimer = null;
        }
    }

    @VisibleForTesting
    ScheduledThreadPoolExecutor getMetricsLoggerTimer() {
        return this.metricsLoggerTimer;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void submitDiskBalancerPlan(String planID, long planVersion, String planFile, String planData, boolean skipDateCheck) throws IOException {
        this.checkSuperuserPrivilege();
        if (DataNode.getStartupOption(this.getConf()) != HdfsServerConstants.StartupOption.REGULAR) {
            throw new DiskBalancerException("Datanode is in special state, e.g. Upgrade/Rollback etc. Disk balancing not permitted.", DiskBalancerException.Result.DATANODE_STATUS_NOT_REGULAR);
        }
        this.getDiskBalancer().submitPlan(planID, planVersion, planFile, planData, skipDateCheck);
    }

    public void cancelDiskBalancePlan(String planID) throws IOException {
        this.checkSuperuserPrivilege();
        this.getDiskBalancer().cancelPlan(planID);
    }

    public DiskBalancerWorkStatus queryDiskBalancerPlan() throws IOException {
        this.checkSuperuserPrivilege();
        return this.getDiskBalancer().queryWorkStatus();
    }

    public String getDiskBalancerSetting(String key) throws IOException {
        this.checkSuperuserPrivilege();
        Preconditions.checkNotNull((Object)key);
        switch (key) {
            case "DiskBalancerVolumeName": {
                return this.getDiskBalancer().getVolumeNames();
            }
            case "DiskBalancerBandwidth": {
                return Long.toString(this.getDiskBalancer().getBandwidth());
            }
        }
        LOG.error("Disk Balancer - Unknown key in get balancer setting. Key: {}", (Object)key);
        throw new DiskBalancerException("Unknown key", DiskBalancerException.Result.UNKNOWN_KEY);
    }

    @VisibleForTesting
    void setBlockScanner(BlockScanner blockScanner) {
        this.blockScanner = blockScanner;
    }

    @Override
    public String getSendPacketDownstreamAvgInfo() {
        return this.dnConf.peerStatsEnabled && this.peerMetrics != null ? this.peerMetrics.dumpSendPacketDownstreamAvgInfoAsJson() : null;
    }

    @Override
    public String getSlowDisks() {
        if (!this.dnConf.diskStatsEnabled || this.diskMetrics == null) {
            return null;
        }
        Set<String> slowDisks = this.diskMetrics.getDiskOutliersStats().keySet();
        return JSON.toString(slowDisks);
    }

    public List<DatanodeVolumeInfo> getVolumeReport() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkStorageState("getVolumeReport");
        Map<String, Object> volumeInfoMap = this.data.getVolumeInfoMap();
        if (volumeInfoMap == null) {
            LOG.warn("DataNode volume info not available.");
            return new ArrayList<DatanodeVolumeInfo>(0);
        }
        ArrayList<DatanodeVolumeInfo> volumeInfoList = new ArrayList<DatanodeVolumeInfo>();
        for (Map.Entry<String, Object> volume : volumeInfoMap.entrySet()) {
            Map volumeInfo = (Map)volume.getValue();
            DatanodeVolumeInfo dnStorageInfo = new DatanodeVolumeInfo(volume.getKey(), ((Long)volumeInfo.get("usedSpace")).longValue(), ((Long)volumeInfo.get("freeSpace")).longValue(), ((Long)volumeInfo.get("reservedSpace")).longValue(), ((Long)volumeInfo.get("reservedSpaceForReplicas")).longValue(), ((Long)volumeInfo.get("numBlocks")).longValue(), (StorageType)volumeInfo.get("storageType"));
            volumeInfoList.add(dnStorageInfo);
        }
        return volumeInfoList;
    }

    @VisibleForTesting
    public DiskBalancer getDiskBalancer() throws IOException {
        if (this.diskBalancer == null) {
            throw new IOException("DiskBalancer is not initialized");
        }
        return this.diskBalancer;
    }

    private static boolean isTransfer(BlockConstructionStage stage, String clientName) {
        return stage == BlockConstructionStage.PIPELINE_SETUP_CREATE && clientName.isEmpty();
    }

    private static boolean isWrite(BlockConstructionStage stage) {
        return stage == BlockConstructionStage.PIPELINE_SETUP_STREAMING_RECOVERY || stage == BlockConstructionStage.PIPELINE_SETUP_APPEND_RECOVERY;
    }

    public DataSetLockManager getDataSetLockManager() {
        return this.dataSetLockManager;
    }

    boolean isSlownodeByBlockPoolId(String bpId) {
        return this.blockPoolManager.isSlownodeByBlockPoolId(bpId);
    }

    boolean isSlownode() {
        return this.blockPoolManager.isSlownode();
    }

    @VisibleForTesting
    public BlockPoolManager getBlockPoolManager() {
        return this.blockPoolManager;
    }

    static {
        HdfsConfiguration.init();
        CLIENT_TRACE_LOG = LoggerFactory.getLogger((String)(DataNode.class.getName() + ".clienttrace"));
        RECONFIGURABLE_PROPERTIES = Collections.unmodifiableList(Arrays.asList("dfs.datanode.data.dir", "dfs.datanode.balance.max.concurrent.moves", "dfs.blockreport.intervalMsec", "dfs.blockreport.split.threshold", "dfs.blockreport.initialDelay", "dfs.datanode.max.transfer.threads", "dfs.cachereport.intervalMsec", "dfs.datanode.peer.stats.enabled", "dfs.datanode.min.outlier.detection.nodes", "dfs.datanode.slowpeer.low.threshold.ms", "dfs.datanode.peer.metrics.min.outlier.detection.samples", "dfs.datanode.fileio.profiling.sampling.percentage", "dfs.datanode.outliers.report.interval", "dfs.datanode.min.outlier.detection.disks", "dfs.datanode.slowdisk.low.threshold.ms", "dfs.datanode.max.slowdisks.to.exclude", "fs.du.interval", "fs.getspaceused.jitterMillis", "fs.getspaceused.classname", "dfs.disk.balancer.enabled", "dfs.disk.balancer.plan.valid.interval", "dfs.datanode.data.transfer.bandwidthPerSec", "dfs.datanode.data.write.bandwidthPerSec", "dfs.datanode.data.read.bandwidthPerSec", "dfs.datanode.slow.io.warning.threshold.ms"));
        NUM_CORES = Runtime.getRuntime().availableProcessors();
    }

    private class DataTransfer
    implements Runnable {
        final DatanodeInfo[] targets;
        final StorageType[] targetStorageTypes;
        private final String[] targetStorageIds;
        final ExtendedBlock b;
        final BlockConstructionStage stage;
        private final DatanodeRegistration bpReg;
        final String clientname;
        final CachingStrategy cachingStrategy;
        private DataTransferThrottler throttler;

        DataTransfer(DatanodeInfo[] targets, StorageType[] targetStorageTypes, String[] targetStorageIds, ExtendedBlock b, BlockConstructionStage stage, String clientname) {
            DataTransferProtocol.LOG.debug("{}: {} (numBytes={}), stage={}, clientname={}, targets={}, target storage types={}, target storage IDs={}", new Object[]{this.getClass().getSimpleName(), b, b.getNumBytes(), stage, clientname, Arrays.asList(targets), targetStorageTypes == null ? "[]" : Arrays.asList(targetStorageTypes), targetStorageIds == null ? "[]" : Arrays.asList(targetStorageIds)});
            this.targets = targets;
            this.targetStorageTypes = targetStorageTypes;
            this.targetStorageIds = targetStorageIds;
            this.b = b;
            this.stage = stage;
            BPOfferService bpos = DataNode.this.blockPoolManager.get(b.getBlockPoolId());
            this.bpReg = bpos.bpRegistration;
            this.clientname = clientname;
            this.cachingStrategy = new CachingStrategy(Boolean.valueOf(true), Long.valueOf(DataNode.this.getDnConf().readaheadLength));
            if (DataNode.isTransfer(stage, clientname)) {
                this.throttler = DataNode.this.xserver.getTransferThrottler();
            } else if (DataNode.isWrite(stage)) {
                this.throttler = DataNode.this.xserver.getWriteThrottler();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            DataNode.this.incrementXmitsInProgress();
            Socket sock = null;
            DataOutputStream out = null;
            DataInputStream in = null;
            BlockSender blockSender = null;
            boolean isClient = this.clientname.length() > 0;
            try {
                String dnAddr = this.targets[0].getXferAddr(DataNode.this.connectToDnViaHostname);
                InetSocketAddress curTarget = NetUtils.createSocketAddr((String)dnAddr);
                LOG.debug("Connecting to datanode {}", (Object)dnAddr);
                sock = DataNode.this.newSocket();
                NetUtils.connect((Socket)sock, (SocketAddress)curTarget, (int)((DataNode)DataNode.this).dnConf.socketTimeout);
                sock.setTcpNoDelay(DataNode.this.dnConf.getDataTransferServerTcpNoDelay());
                sock.setSoTimeout(this.targets.length * ((DataNode)DataNode.this).dnConf.socketTimeout);
                Token<BlockTokenIdentifier> accessToken = DataNode.this.getBlockAccessToken(this.b, EnumSet.of(BlockTokenIdentifier.AccessMode.WRITE), this.targetStorageTypes, this.targetStorageIds);
                long writeTimeout = ((DataNode)DataNode.this).dnConf.socketWriteTimeout + 5000 * (this.targets.length - 1);
                OutputStream unbufOut = NetUtils.getOutputStream((Socket)sock, (long)writeTimeout);
                Object unbufIn = NetUtils.getInputStream((Socket)sock);
                DataEncryptionKeyFactory keyFactory = DataNode.this.getDataEncryptionKeyFactoryForBlock(this.b);
                IOStreamPair saslStreams = DataNode.this.saslClient.socketSend(sock, unbufOut, (InputStream)unbufIn, keyFactory, accessToken, (DatanodeID)this.bpReg);
                unbufOut = saslStreams.out;
                unbufIn = saslStreams.in;
                out = new DataOutputStream(new BufferedOutputStream(unbufOut, DFSUtilClient.getSmallBufferSize((Configuration)DataNode.this.getConf())));
                in = new DataInputStream((InputStream)unbufIn);
                blockSender = new BlockSender(this.b, 0L, this.b.getNumBytes(), false, false, true, DataNode.this, null, this.cachingStrategy);
                DatanodeInfo srcNode = new DatanodeInfo.DatanodeInfoBuilder().setNodeID((DatanodeID)this.bpReg).build();
                String storageId = this.targetStorageIds.length > 0 ? this.targetStorageIds[0] : null;
                new Sender(out).writeBlock(this.b, this.targetStorageTypes[0], accessToken, this.clientname, this.targets, this.targetStorageTypes, srcNode, this.stage, 0, 0L, 0L, 0L, blockSender.getChecksum(), this.cachingStrategy, false, false, null, storageId, this.targetStorageIds);
                blockSender.sendBlock(out, unbufOut, this.throttler);
                LOG.info("{}, at {}: Transmitted {} (numBytes={}) to {}", new Object[]{this.getClass().getSimpleName(), DataNode.this.getDisplayName(), this.b, this.b.getNumBytes(), curTarget});
                if (isClient) {
                    DataTransferProtos.DNTransferAckProto closeAck = DataTransferProtos.DNTransferAckProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
                    LOG.debug("{}: close-ack={}", (Object)this.getClass().getSimpleName(), (Object)closeAck);
                    if (closeAck.getStatus() != DataTransferProtos.Status.SUCCESS) {
                        if (closeAck.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                            throw new InvalidBlockTokenException("Got access token error for connect ack, targets=" + Arrays.asList(this.targets));
                        }
                        throw new IOException("Bad connect ack, targets=" + Arrays.asList(this.targets) + " status=" + closeAck.getStatus());
                    }
                } else {
                    DataNode.this.metrics.incrBlocksReplicated();
                }
                DataNode.this.decrementXmitsInProgress();
            }
            catch (IOException ie) {
                DataNode.this.handleBadBlock(this.b, ie, false);
                LOG.warn("{}:Failed to transfer {} to {} got", new Object[]{this.bpReg, this.b, this.targets[0], ie});
                DataNode.this.decrementXmitsInProgress();
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                IOUtils.closeSocket((Socket)sock);
            }
            catch (Throwable t) {
                LOG.error("Failed to transfer block {}", (Object)this.b, (Object)t);
                DataNode.this.decrementXmitsInProgress();
                {
                    catch (Throwable throwable) {
                        DataNode.this.decrementXmitsInProgress();
                        IOUtils.closeStream(blockSender);
                        IOUtils.closeStream(out);
                        IOUtils.closeStream(in);
                        IOUtils.closeSocket(sock);
                        throw throwable;
                    }
                }
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                IOUtils.closeSocket((Socket)sock);
            }
            IOUtils.closeStream((Closeable)blockSender);
            IOUtils.closeStream((Closeable)out);
            IOUtils.closeStream((Closeable)in);
            IOUtils.closeSocket((Socket)sock);
        }

        public String toString() {
            return "DataTransfer " + this.b + " to " + Arrays.asList(this.targets);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public static class ShortCircuitFdsVersionException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ShortCircuitFdsVersionException(String msg) {
            super(msg);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public static class ShortCircuitFdsUnsupportedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ShortCircuitFdsUnsupportedException(String msg) {
            super(msg);
        }
    }

    @VisibleForTesting
    static class ChangedVolumes {
        List<StorageLocation> newLocations = Lists.newArrayList();
        List<StorageLocation> deactivateLocations = Lists.newArrayList();
        List<StorageLocation> unchangedLocations = Lists.newArrayList();

        ChangedVolumes() {
        }
    }
}

