/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.file.tfile.KVGenerator;
import org.apache.hadoop.io.file.tfile.KeySampler;
import org.apache.hadoop.io.file.tfile.NanoTimer;
import org.apache.hadoop.io.file.tfile.RandomDistribution;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestTFileSeek {
    private MyOptions options;
    private Configuration conf;
    private Path path;
    private FileSystem fs;
    private NanoTimer timer;
    private Random rng;
    private RandomDistribution.DiscreteRNG keyLenGen;
    private KVGenerator kvGen;

    @Before
    public void setUp() throws IOException {
        if (this.options == null) {
            this.options = new MyOptions(new String[0]);
        }
        this.conf = new Configuration();
        this.conf.setInt("tfile.fs.input.buffer.size", this.options.fsInputBufferSize);
        this.conf.setInt("tfile.fs.output.buffer.size", this.options.fsOutputBufferSize);
        this.path = new Path(new Path(this.options.rootDir), this.options.file);
        this.fs = this.path.getFileSystem(this.conf);
        this.timer = new NanoTimer(false);
        this.rng = new Random(this.options.seed);
        this.keyLenGen = new RandomDistribution.Zipf(new Random(this.rng.nextLong()), this.options.minKeyLen, this.options.maxKeyLen, 1.2);
        RandomDistribution.Flat valLenGen = new RandomDistribution.Flat(new Random(this.rng.nextLong()), this.options.minValLength, this.options.maxValLength);
        RandomDistribution.Flat wordLenGen = new RandomDistribution.Flat(new Random(this.rng.nextLong()), this.options.minWordLen, this.options.maxWordLen);
        this.kvGen = new KVGenerator(this.rng, true, this.keyLenGen, valLenGen, wordLenGen, this.options.dictSize);
    }

    @After
    public void tearDown() throws IOException {
        this.fs.delete(this.path, true);
    }

    private static FSDataOutputStream createFSOutput(Path name, FileSystem fs) throws IOException {
        if (fs.exists(name)) {
            fs.delete(name, true);
        }
        FSDataOutputStream fout = fs.create(name);
        return fout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTFile() throws IOException {
        long totalBytes = 0L;
        try (FSDataOutputStream fout = TestTFileSeek.createFSOutput(this.path, this.fs);
             TFile.Writer writer = new TFile.Writer(fout, this.options.minBlockSize, this.options.compress, "memcmp", this.conf);){
            BytesWritable key = new BytesWritable();
            BytesWritable val = new BytesWritable();
            this.timer.start();
            long i = 0L;
            while (i % 1000L != 0L || this.fs.getFileStatus(this.path).getLen() < this.options.fileSize) {
                this.kvGen.next(key, val, false);
                writer.append(key.getBytes(), 0, key.getLength(), val.getBytes(), 0, val.getLength());
                totalBytes += (long)key.getLength();
                totalBytes += (long)val.getLength();
                ++i;
            }
            this.timer.stop();
        }
        double duration = (double)this.timer.read() / 1000.0;
        long fsize = this.fs.getFileStatus(this.path).getLen();
        System.out.printf("time: %s...uncompressed: %.2fMB...raw thrpt: %.2fMB/s\n", this.timer.toString(), (double)totalBytes / 1024.0 / 1024.0, (double)totalBytes / duration);
        System.out.printf("time: %s...file size: %.2fMB...disk thrpt: %.2fMB/s\n", this.timer.toString(), (double)fsize / 1024.0 / 1024.0, (double)fsize / duration);
    }

    public void seekTFile() throws IOException {
        int miss = 0;
        long totalBytes = 0L;
        FSDataInputStream fsdis = this.fs.open(this.path);
        TFile.Reader reader = new TFile.Reader(fsdis, this.fs.getFileStatus(this.path).getLen(), this.conf);
        KeySampler kSampler = new KeySampler(this.rng, reader.getFirstKey(), reader.getLastKey(), this.keyLenGen);
        TFile.Reader.Scanner scanner = reader.createScanner();
        BytesWritable key = new BytesWritable();
        BytesWritable val = new BytesWritable();
        this.timer.reset();
        this.timer.start();
        int i = 0;
        while ((long)i < this.options.seekCount) {
            kSampler.next(key);
            scanner.lowerBound(key.getBytes(), 0, key.getLength());
            if (!scanner.atEnd()) {
                scanner.entry().get(key, val);
                totalBytes += (long)key.getLength();
                totalBytes += (long)val.getLength();
            } else {
                ++miss;
            }
            ++i;
        }
        this.timer.stop();
        double duration = (double)this.timer.read() / 1000.0;
        System.out.printf("time: %s...avg seek: %s...%d hit...%d miss...avg I/O size: %.2fKB\n", this.timer.toString(), NanoTimer.nanoTimeToString(this.timer.read() / this.options.seekCount), this.options.seekCount - (long)miss, miss, (double)totalBytes / 1024.0 / (double)(this.options.seekCount - (long)miss));
    }

    @Test
    public void testSeeks() throws IOException {
        String[] supported = TFile.getSupportedCompressionAlgorithms();
        boolean proceed = false;
        for (String c : supported) {
            if (!c.equals(this.options.compress)) continue;
            proceed = true;
            break;
        }
        if (!proceed) {
            System.out.println("Skipped for " + this.options.compress);
            return;
        }
        if (this.options.doCreate()) {
            this.createTFile();
        }
        if (this.options.doRead()) {
            this.seekTFile();
        }
    }

    public static void main(String[] argv) throws IOException {
        TestTFileSeek testCase = new TestTFileSeek();
        MyOptions options = new MyOptions(argv);
        if (!options.proceed) {
            return;
        }
        testCase.options = options;
        testCase.setUp();
        testCase.testSeeks();
        testCase.tearDown();
    }

    private static class MyOptions {
        int dictSize = 1000;
        int minWordLen = 5;
        int maxWordLen = 20;
        int osInputBufferSize = 65536;
        int osOutputBufferSize = 65536;
        int fsInputBufferSizeNone = 0;
        int fsInputBufferSizeLzo = 0;
        int fsInputBufferSizeGz = 0;
        int fsOutputBufferSizeNone = 1;
        int fsOutputBufferSizeLzo = 1;
        int fsOutputBufferSizeGz = 1;
        String rootDir = GenericTestUtils.getTestDir().getAbsolutePath();
        String file = "TestTFileSeek";
        String compress = "gz";
        int minKeyLen = 10;
        int maxKeyLen = 50;
        int minValLength = 100;
        int maxValLength = 200;
        int minBlockSize = 65536;
        int fsOutputBufferSize = 1;
        int fsInputBufferSize = 0;
        long fileSize = 0x300000L;
        long seekCount = 1000L;
        long seed = System.nanoTime();
        static final int OP_CREATE = 1;
        static final int OP_READ = 2;
        int op = 3;
        boolean proceed = false;

        public MyOptions(String[] args) {
            try {
                Options opts = this.buildOptions();
                DefaultParser parser = new DefaultParser();
                CommandLine line = parser.parse(opts, args, true);
                this.processOptions(line, opts);
                this.validateOptions();
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
                System.out.println("Try \"--help\" option for details.");
                this.setStopProceed();
            }
        }

        public boolean proceed() {
            return this.proceed;
        }

        private Options buildOptions() {
            Option compress = Option.builder((String)"c").longOpt("compress").argName("[none|lzo|gz]").hasArg().desc("compression scheme").build();
            Option fileSize = Option.builder((String)"s").longOpt("file-size").argName("size-in-MB").hasArg().desc("target size of the file (in MB).").build();
            Option fsInputBufferSz = Option.builder((String)"i").longOpt("fs-input-buffer").argName("size").hasArg().desc("size of the file system input buffer (in bytes).").build();
            Option fsOutputBufferSize = Option.builder((String)"o").longOpt("fs-output-buffer").argName("size").hasArg().desc("size of the file system output buffer (in bytes).").build();
            Option keyLen = Option.builder((String)"k").longOpt("key-length").argName("min,max").hasArg().desc("the length range of the key (in bytes)").build();
            Option valueLen = Option.builder((String)"v").longOpt("value-length").argName("min,max").hasArg().desc("the length range of the value (in bytes)").build();
            Option blockSz = Option.builder((String)"b").longOpt("block").argName("size-in-KB").hasArg().desc("minimum block size (in KB)").build();
            Option seed = Option.builder((String)"S").longOpt("seed").argName("long-int").hasArg().desc("specify the seed").build();
            Option operation = Option.builder((String)"x").longOpt("operation").argName("r|w|rw").hasArg().desc("action: seek-only, create-only, seek-after-create").build();
            Option rootDir = Option.builder((String)"r").longOpt("root-dir").argName("path").hasArg().desc("specify root directory where files will be created.").build();
            Option file = Option.builder((String)"f").longOpt("file").argName("name").hasArg().desc("specify the file name to be created or read.").build();
            Option seekCount = Option.builder((String)"n").longOpt("seek").argName("count").hasArg().desc("specify how many seek operations we perform (requires -x r or -x rw.").build();
            Option help = Option.builder((String)"h").longOpt("help").hasArg(false).desc("show this screen").build();
            return new Options().addOption(compress).addOption(fileSize).addOption(fsInputBufferSz).addOption(fsOutputBufferSize).addOption(keyLen).addOption(blockSz).addOption(rootDir).addOption(valueLen).addOption(operation).addOption(seekCount).addOption(file).addOption(help);
        }

        private void processOptions(CommandLine line, Options opts) throws ParseException {
            IntegerRange ir;
            if (line.hasOption('h')) {
                HelpFormatter formatter = new HelpFormatter();
                System.out.println("TFile and SeqFile benchmark.");
                System.out.println();
                formatter.printHelp(100, "java ... TestTFileSeqFileComparison [options]", "\nSupported options:", opts, "");
                return;
            }
            if (line.hasOption('c')) {
                this.compress = line.getOptionValue('c');
            }
            if (line.hasOption('d')) {
                this.dictSize = Integer.parseInt(line.getOptionValue('d'));
            }
            if (line.hasOption('s')) {
                this.fileSize = Long.parseLong(line.getOptionValue('s')) * 1024L * 1024L;
            }
            if (line.hasOption('i')) {
                this.fsInputBufferSize = Integer.parseInt(line.getOptionValue('i'));
            }
            if (line.hasOption('o')) {
                this.fsOutputBufferSize = Integer.parseInt(line.getOptionValue('o'));
            }
            if (line.hasOption('n')) {
                this.seekCount = Integer.parseInt(line.getOptionValue('n'));
            }
            if (line.hasOption('k')) {
                ir = IntegerRange.parse(line.getOptionValue('k'));
                this.minKeyLen = ir.from();
                this.maxKeyLen = ir.to();
            }
            if (line.hasOption('v')) {
                ir = IntegerRange.parse(line.getOptionValue('v'));
                this.minValLength = ir.from();
                this.maxValLength = ir.to();
            }
            if (line.hasOption('b')) {
                this.minBlockSize = Integer.parseInt(line.getOptionValue('b')) * 1024;
            }
            if (line.hasOption('r')) {
                this.rootDir = line.getOptionValue('r');
            }
            if (line.hasOption('f')) {
                this.file = line.getOptionValue('f');
            }
            if (line.hasOption('S')) {
                this.seed = Long.parseLong(line.getOptionValue('S'));
            }
            if (line.hasOption('x')) {
                String strOp = line.getOptionValue('x');
                if (strOp.equals("r")) {
                    this.op = 2;
                } else if (strOp.equals("w")) {
                    this.op = 1;
                } else if (strOp.equals("rw")) {
                    this.op = 3;
                } else {
                    throw new ParseException("Unknown action specifier: " + strOp);
                }
            }
            this.proceed = true;
        }

        private void validateOptions() throws ParseException {
            if (!(this.compress.equals("none") || this.compress.equals("lzo") || this.compress.equals("gz"))) {
                throw new ParseException("Unknown compression scheme: " + this.compress);
            }
            if (this.minKeyLen >= this.maxKeyLen) {
                throw new ParseException("Max key length must be greater than min key length.");
            }
            if (this.minValLength >= this.maxValLength) {
                throw new ParseException("Max value length must be greater than min value length.");
            }
            if (this.minWordLen >= this.maxWordLen) {
                throw new ParseException("Max word length must be greater than min word length.");
            }
        }

        private void setStopProceed() {
            this.proceed = false;
        }

        public boolean doCreate() {
            return (this.op & 1) != 0;
        }

        public boolean doRead() {
            return (this.op & 2) != 0;
        }
    }

    private static class IntegerRange {
        private final int from;
        private final int to;

        public IntegerRange(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public static IntegerRange parse(String s) throws ParseException {
            StringTokenizer st = new StringTokenizer(s, " \t,");
            if (st.countTokens() != 2) {
                throw new ParseException("Bad integer specification: " + s);
            }
            int from = Integer.parseInt(st.nextToken());
            int to = Integer.parseInt(st.nextToken());
            return new IntegerRange(from, to);
        }

        public int from() {
            return this.from;
        }

        public int to() {
            return this.to;
        }
    }
}

