/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.impl.LeakReporter;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestLeakReporter
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestLeakReporter.class);
    private final AtomicInteger closeCount = new AtomicInteger();

    @Test
    public void testLeakInvocation() throws Throwable {
        String message = "<message>";
        LeakReporter reporter = new LeakReporter("<message>", () -> true, this::closed);
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName("thread");
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs(LoggerFactory.getLogger((String)"ROOT"));
        this.expectClose(reporter, 1);
        logs.stopCapturing();
        String output = logs.getOutput();
        LOG.info("output of leak log is {}", (Object)output);
        String threadInfo = String.format("; thread: %s; id: %d", oldName, Thread.currentThread().getId());
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output from the logs", new Object[0])).contains(new CharSequence[]{"WARN"})).contains(new CharSequence[]{"<message>"})).contains(new CharSequence[]{Thread.currentThread().getName()})).contains(new CharSequence[]{threadInfo})).contains(new CharSequence[]{"TestLeakReporter.testLeakInvocation"})).contains(new CharSequence[]{"INFO"})).contains(new CharSequence[]{"stack"});
        this.expectClose(reporter, 1);
    }

    private void expectClose(LeakReporter reporter, int expected) {
        reporter.close();
        this.assertCloseCount(expected);
    }

    private void closed() {
        this.closeCount.incrementAndGet();
    }

    @Test
    public void testLeakSkipped() throws Throwable {
        LeakReporter reporter = new LeakReporter("<message>", () -> false, this::closed);
        this.expectClose(reporter, 0);
    }

    @Test
    public void testProbeFailureSwallowed() throws Throwable {
        LeakReporter reporter = new LeakReporter("<message>", this::raiseNPE, this::closed);
        this.expectClose(reporter, 0);
    }

    @Test
    public void testCloseActionSwallowed() throws Throwable {
        LeakReporter reporter = new LeakReporter("<message>", () -> true, this::raiseNPE);
        reporter.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)reporter.isClosed()).describedAs("reporter closed)", new Object[0])).isTrue();
    }

    private boolean raiseNPE() {
        throw new NullPointerException("oops");
    }

    private void assertCloseCount(int ex) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.closeCount.get()).describedAs("close count", new Object[0])).isEqualTo(ex);
    }
}

