/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.sun.codemodel.JBlock;
import org.apache.hadoop.shaded.com.sun.codemodel.JClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JDefinedClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JExpr;
import org.apache.hadoop.shaded.com.sun.codemodel.JExpression;
import org.apache.hadoop.shaded.com.sun.codemodel.JFieldVar;
import org.apache.hadoop.shaded.com.sun.codemodel.JInvocation;
import org.apache.hadoop.shaded.com.sun.codemodel.JMethod;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;
import org.apache.hadoop.shaded.com.sun.codemodel.JVar;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Schema;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;

public class AdditionalPropertiesRule
implements Rule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;

    protected AdditionalPropertiesRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass jclass, Schema schema) {
        if (node != null && node.isBoolean() && !node.asBoolean()) {
            return jclass;
        }
        if (!this.ruleFactory.getGenerationConfig().isIncludeAdditionalProperties()) {
            return jclass;
        }
        if (!this.ruleFactory.getAnnotator().isAdditionalPropertiesSupported()) {
            return jclass;
        }
        JType propertyType = node != null && node.size() != 0 ? this.ruleFactory.getSchemaRule().apply(nodeName + "Property", node, parent, jclass, schema) : jclass.owner().ref(Object.class);
        JFieldVar field = this.addAdditionalPropertiesField(jclass, propertyType);
        this.addGetter(jclass, field);
        this.addSetter(jclass, propertyType, field);
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations()) {
            this.ruleFactory.getValidRule().apply(nodeName, node, parent, field, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isGenerateBuilders()) {
            this.addBuilder(jclass, propertyType, field);
        }
        return jclass;
    }

    private JFieldVar addAdditionalPropertiesField(JDefinedClass jclass, JType propertyType) {
        JClass propertiesMapType = jclass.owner().ref(Map.class);
        propertiesMapType = propertiesMapType.narrow(jclass.owner().ref(String.class), propertyType.boxify());
        JClass propertiesMapImplType = jclass.owner().ref(HashMap.class);
        propertiesMapImplType = propertiesMapImplType.narrow(jclass.owner().ref(String.class), propertyType.boxify());
        JFieldVar field = jclass.field(4, propertiesMapType, "additionalProperties");
        this.ruleFactory.getAnnotator().additionalPropertiesField(field, jclass, "additionalProperties");
        field.init(JExpr._new(propertiesMapImplType));
        return field;
    }

    private void addSetter(JDefinedClass jclass, JType propertyType, JFieldVar field) {
        JMethod setter = jclass.method(1, Void.TYPE, "setAdditionalProperty");
        this.ruleFactory.getAnnotator().anySetter(setter, jclass);
        JVar nameParam = setter.param(String.class, "name");
        JVar valueParam = setter.param(propertyType, "value");
        JInvocation mapInvocation = setter.body().invoke((JExpression)JExpr._this().ref(field), "put");
        mapInvocation.arg(nameParam);
        mapInvocation.arg(valueParam);
    }

    private JMethod addGetter(JDefinedClass jclass, JFieldVar field) {
        JMethod getter = jclass.method(1, field.type(), "getAdditionalProperties");
        this.ruleFactory.getAnnotator().anyGetter(getter, jclass);
        getter.body()._return(JExpr._this().ref(field));
        return getter;
    }

    private JMethod addBuilder(JDefinedClass jclass, JType propertyType, JFieldVar field) {
        JMethod result = null;
        result = this.ruleFactory.getGenerationConfig().isUseInnerClassBuilders() ? this.addInnerBuilder(jclass, propertyType, field) : this.addLegacyBuilder(jclass, propertyType, field);
        return result;
    }

    private JMethod addLegacyBuilder(JDefinedClass jclass, JType propertyType, JFieldVar field) {
        JMethod builder = jclass.method(1, jclass, "withAdditionalProperty");
        JVar nameParam = builder.param(String.class, "name");
        JVar valueParam = builder.param(propertyType, "value");
        JBlock body = builder.body();
        JInvocation mapInvocation = body.invoke((JExpression)JExpr._this().ref(field), "put");
        mapInvocation.arg(nameParam);
        mapInvocation.arg(valueParam);
        body._return(JExpr._this());
        return builder;
    }

    private JMethod addInnerBuilder(JDefinedClass jclass, JType propertyType, JFieldVar field) {
        Optional<JDefinedClass> builderClass = StreamSupport.stream(Spliterators.spliteratorUnknownSize(jclass.classes(), 16), false).filter(definedClass -> definedClass.name().equals(this.getBuilderClassName(jclass))).findFirst();
        JMethod builder = builderClass.get().method(1, builderClass.get(), "withAdditionalProperty");
        JVar nameParam = builder.param(String.class, "name");
        JVar valueParam = builder.param(propertyType, "value");
        JBlock body = builder.body();
        JInvocation mapInvocation = body.invoke((JExpression)JExpr.ref((JExpression)JExpr.cast(jclass, JExpr._this().ref("instance")), field), "put");
        mapInvocation.arg(nameParam);
        mapInvocation.arg(valueParam);
        body._return(JExpr._this());
        return builder;
    }

    private String getBuilderClassName(JDefinedClass c) {
        return this.ruleFactory.getNameHelper().getBuilderClassName(c);
    }
}

