/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.util.Map;

public class RequestEntityTooLargeException
extends DocumentClientException {
    private static final long serialVersionUID = 1L;

    public RequestEntityTooLargeException() {
        this("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.");
    }

    public RequestEntityTooLargeException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(413, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public RequestEntityTooLargeException(String msg) {
        super(413, msg);
    }

    public RequestEntityTooLargeException(String msg, String resourceAddress) {
        super(msg, null, null, 413, resourceAddress);
    }

    public RequestEntityTooLargeException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public RequestEntityTooLargeException(Exception innerException) {
        this("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", innerException, null, null);
    }

    public RequestEntityTooLargeException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", message), innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 413, requestUri);
    }
}

