/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ClientSideRequestStatistics;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressSelector;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.QuorumReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReadMode;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestTimeoutException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResult;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TimeoutHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.NotFoundException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

public class ConsistencyReader {
    private static final int MAX_NUMBER_OF_SECONDARY_READ_RETRIES = 3;
    private static final Logger logger = LoggerFactory.getLogger(ConsistencyReader.class);
    private final AddressSelector addressSelector;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    private final IAuthorizationTokenProvider authorizationTokenProvider;
    private final StoreReader storeReader;
    private final QuorumReader quorumReader;
    private final Configs configs;

    public ConsistencyReader(Configs configs, AddressSelector addressSelector, ISessionContainer sessionContainer, TransportClient transportClient, GatewayServiceConfigurationReader serviceConfigReader, IAuthorizationTokenProvider authorizationTokenProvider) {
        this.configs = configs;
        this.addressSelector = addressSelector;
        this.serviceConfigReader = serviceConfigReader;
        this.authorizationTokenProvider = authorizationTokenProvider;
        this.storeReader = this.createStoreReader(transportClient, addressSelector, sessionContainer);
        this.quorumReader = this.createQuorumReader(transportClient, addressSelector, this.storeReader, serviceConfigReader, authorizationTokenProvider);
    }

    public Single<StoreResponse> readAsync(RxDocumentServiceRequest entity, TimeoutHelper timeout, boolean isInRetry, boolean forceRefresh) {
        ReadMode desiredReadMode;
        if (!isInRetry) {
            if (timeout.isElapsed()) {
                return Single.error((Throwable)new RequestTimeoutException());
            }
        } else if (timeout.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        entity.requestContext.timeoutHelper = timeout;
        if (entity.requestContext.requestChargeTracker == null) {
            entity.requestContext.requestChargeTracker = new RequestChargeTracker();
        }
        if (entity.requestContext.clientSideRequestStatistics == null) {
            entity.requestContext.clientSideRequestStatistics = new ClientSideRequestStatistics();
        }
        entity.requestContext.forceRefreshAddressCache = forceRefresh;
        Utils.ValueHolder targetConsistencyLevel = Utils.ValueHolder.initialize(null);
        Utils.ValueHolder useSessionToken = Utils.ValueHolder.initialize(null);
        try {
            desiredReadMode = this.deduceReadMode(entity, (Utils.ValueHolder<ConsistencyLevel>)targetConsistencyLevel, (Utils.ValueHolder<Boolean>)useSessionToken);
        }
        catch (DocumentClientException e) {
            return Single.error((Throwable)e);
        }
        int maxReplicaCount = this.getMaxReplicaSetSize(entity);
        int readQuorumValue = maxReplicaCount - maxReplicaCount / 2;
        switch (desiredReadMode) {
            case Primary: {
                return this.readPrimaryAsync(entity, (Boolean)useSessionToken.v);
            }
            case Strong: {
                entity.requestContext.performLocalRefreshOnGoneException = true;
                return this.quorumReader.readStrongAsync(entity, readQuorumValue, desiredReadMode);
            }
            case BoundedStaleness: {
                entity.requestContext.performLocalRefreshOnGoneException = true;
                return this.quorumReader.readStrongAsync(entity, readQuorumValue, desiredReadMode);
            }
            case Any: {
                if (targetConsistencyLevel.v == ConsistencyLevel.Session) {
                    return this.readSessionAsync(entity, desiredReadMode);
                }
                return this.readAnyAsync(entity, desiredReadMode);
            }
        }
        throw new IllegalStateException("invalid operation " + (Object)((Object)desiredReadMode));
    }

    private Single<StoreResponse> readPrimaryAsync(RxDocumentServiceRequest entity, boolean useSessionToken) {
        Single<StoreResult> responseObs = this.storeReader.readPrimaryAsync(entity, false, useSessionToken);
        return responseObs.flatMap(response -> {
            try {
                return Single.just((Object)response.toResponse());
            }
            catch (DocumentClientException e) {
                return Single.error((Throwable)e);
            }
        });
    }

    private Single<StoreResponse> readAnyAsync(RxDocumentServiceRequest entity, ReadMode readMode) {
        Single<List<StoreResult>> responsesObs = this.storeReader.readMultipleReplicaAsync(entity, true, 1, false, false, readMode);
        return responsesObs.flatMap(responses -> {
            if (responses.size() == 0) {
                return Single.error((Throwable)new GoneException("The requested resource is no longer available at the server."));
            }
            try {
                return Single.just((Object)((StoreResult)responses.get(0)).toResponse());
            }
            catch (DocumentClientException e) {
                return Single.error((Throwable)e);
            }
        });
    }

    private Single<StoreResponse> readSessionAsync(RxDocumentServiceRequest entity, ReadMode readMode) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        Single<List<StoreResult>> responsesObs = this.storeReader.readMultipleReplicaAsync(entity, true, 1, true, true, readMode, true, false);
        return responsesObs.flatMap(responses -> {
            if (responses.size() > 0) {
                try {
                    return Single.just((Object)((StoreResult)responses.get(0)).toResponse(entity.requestContext.requestChargeTracker));
                }
                catch (NotFoundException notFoundException) {
                    try {
                        if (entity.requestContext.sessionToken != null && ((StoreResult)responses.get((int)0)).sessionToken != null && !entity.requestContext.sessionToken.isValid(((StoreResult)responses.get((int)0)).sessionToken)) {
                            logger.warn("Convert to session read exception, request {} Session Lsn {}, responseLSN {}", new Object[]{entity.getResourceAddress(), entity.requestContext.sessionToken.convertToString(), ((StoreResult)responses.get((int)0)).lsn});
                            notFoundException.getResponseHeaders().put("x-ms-substatus", Integer.toString(1002));
                        }
                        return Single.error((Throwable)notFoundException);
                    }
                    catch (DocumentClientException e) {
                        return Single.error((Throwable)e);
                    }
                }
                catch (DocumentClientException dce) {
                    return Single.error((Throwable)dce);
                }
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("x-ms-substatus", Integer.toString(1002));
            ISessionToken requestSessionToken = entity.requestContext.sessionToken;
            logger.warn("Fail the session read {}, request session token {}", (Object)entity.getResourceAddress(), (Object)(requestSessionToken == null ? "<empty>" : requestSessionToken.convertToString()));
            return Single.error((Throwable)new NotFoundException("The read session is not available for the input session token.", responseHeaders, null));
        });
    }

    ReadMode deduceReadMode(RxDocumentServiceRequest request, Utils.ValueHolder<ConsistencyLevel> targetConsistencyLevel, Utils.ValueHolder<Boolean> useSessionToken) throws DocumentClientException {
        targetConsistencyLevel.v = RequestHelper.GetConsistencyLevelToUse(this.serviceConfigReader, request);
        useSessionToken.v = targetConsistencyLevel.v == ConsistencyLevel.Session;
        if (request.getDefaultReplicaIndex() != null) {
            useSessionToken.v = false;
            return ReadMode.Primary;
        }
        switch ((ConsistencyLevel)targetConsistencyLevel.v) {
            case Eventual: {
                return ReadMode.Any;
            }
            case ConsistentPrefix: {
                return ReadMode.Any;
            }
            case Session: {
                return ReadMode.Any;
            }
            case BoundedStaleness: {
                return ReadMode.BoundedStaleness;
            }
            case Strong: {
                return ReadMode.Strong;
            }
        }
        throw new IllegalStateException("Invalid Consistency Level " + targetConsistencyLevel.v);
    }

    public int getMaxReplicaSetSize(RxDocumentServiceRequest entity) {
        boolean isMasterResource = ReplicatedResourceClient.isReadingFromMaster(entity.getResourceType(), entity.getOperationType());
        if (isMasterResource) {
            return this.serviceConfigReader.getSystemReplicationPolicy().getMaxReplicaSetSize();
        }
        return this.serviceConfigReader.getUserReplicationPolicy().getMaxReplicaSetSize();
    }

    public int getMinReplicaSetSize(RxDocumentServiceRequest entity) {
        boolean isMasterResource = ReplicatedResourceClient.isReadingFromMaster(entity.getResourceType(), entity.getOperationType());
        if (isMasterResource) {
            return this.serviceConfigReader.getSystemReplicationPolicy().getMinReplicaSetSize();
        }
        return this.serviceConfigReader.getUserReplicationPolicy().getMinReplicaSetSize();
    }

    StoreReader createStoreReader(TransportClient transportClient, AddressSelector addressSelector, ISessionContainer sessionContainer) {
        return new StoreReader(transportClient, addressSelector, sessionContainer);
    }

    QuorumReader createQuorumReader(TransportClient transportClient, AddressSelector addressSelector, StoreReader storeReader, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider authorizationTokenProvider) {
        return new QuorumReader(transportClient, addressSelector, storeReader, serviceConfigurationReader, authorizationTokenProvider, this.configs);
    }
}

