/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;

public final class EpochFormatter {
    @NonNull
    private final String pattern;
    @NonNull
    private final Locale locale;
    @NonNull
    private final TimeZone timeZone;
    @NonNull
    private final ThreadLocal<SimpleDateFormat> dateFormat;
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    public static final EpochFormatter DEFAULT = new EpochFormatter();

    public EpochFormatter(@NonNull String pattern, @NonNull TimeZone timeZone, @NonNull Locale locale) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (timeZone == null) {
            throw new NullPointerException("timeZone is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        this.dateFormat = ThreadLocal.withInitial(() -> {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
            simpleDateFormat.setTimeZone(timeZone);
            return simpleDateFormat;
        });
    }

    public EpochFormatter() {
        this(DEFAULT_PATTERN, DEFAULT_TIMEZONE, DEFAULT_LOCALE);
    }

    public String formatMillis(long epochMillis) {
        return this.dateFormat.get().format(epochMillis);
    }

    public String formatNanos(long epochNanos) {
        return this.dateFormat.get().format(TimeUnit.NANOSECONDS.toMillis(epochNanos));
    }

    @NonNull
    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @NonNull
    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @NonNull
    @Generated
    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

