/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import software.amazon.s3.analyticsaccelerator.util.MetricKey;

public class Metrics {
    private final Map<MetricKey, AtomicLong> metrics = new ConcurrentHashMap<MetricKey, AtomicLong>();

    public void add(MetricKey key, long delta) {
        this.getOrCreate(key).addAndGet(delta);
    }

    public void reduce(MetricKey key, long delta) {
        this.getOrCreate(key).addAndGet(-delta);
    }

    public long get(MetricKey key) {
        return this.getOrCreate(key).get();
    }

    private AtomicLong getOrCreate(MetricKey key) {
        return this.metrics.computeIfAbsent(key, k -> new AtomicLong(0L));
    }
}

