/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;

public class RMAppMetrics {
    final Resource resourcePreempted;
    final int numNonAMContainersPreempted;
    final int numAMContainersPreempted;
    private final Map<String, Long> resourceSecondsMap;
    private final Map<String, Long> preemptedResourceSecondsMap;
    private int totalAllocatedContainers;

    public RMAppMetrics(Resource resourcePreempted, int numNonAMContainersPreempted, int numAMContainersPreempted, Map<String, Long> resourceSecondsMap, Map<String, Long> preemptedResourceSecondsMap, int totalAllocatedContainers) {
        this.resourcePreempted = resourcePreempted;
        this.numNonAMContainersPreempted = numNonAMContainersPreempted;
        this.numAMContainersPreempted = numAMContainersPreempted;
        this.resourceSecondsMap = resourceSecondsMap;
        this.preemptedResourceSecondsMap = preemptedResourceSecondsMap;
        this.totalAllocatedContainers = totalAllocatedContainers;
    }

    public Resource getResourcePreempted() {
        return this.resourcePreempted;
    }

    public int getNumNonAMContainersPreempted() {
        return this.numNonAMContainersPreempted;
    }

    public int getNumAMContainersPreempted() {
        return this.numAMContainersPreempted;
    }

    public long getMemorySeconds() {
        return RMServerUtils.getOrDefault(this.resourceSecondsMap, ResourceInformation.MEMORY_MB.getName(), 0L);
    }

    public long getVcoreSeconds() {
        return RMServerUtils.getOrDefault(this.resourceSecondsMap, ResourceInformation.VCORES.getName(), 0L);
    }

    public long getPreemptedMemorySeconds() {
        return RMServerUtils.getOrDefault(this.preemptedResourceSecondsMap, ResourceInformation.MEMORY_MB.getName(), 0L);
    }

    public long getPreemptedVcoreSeconds() {
        return RMServerUtils.getOrDefault(this.preemptedResourceSecondsMap, ResourceInformation.VCORES.getName(), 0L);
    }

    public Map<String, Long> getResourceSecondsMap() {
        return this.resourceSecondsMap;
    }

    public Map<String, Long> getPreemptedResourceSecondsMap() {
        return this.preemptedResourceSecondsMap;
    }

    public int getTotalAllocatedContainers() {
        return this.totalAllocatedContainers;
    }
}

