/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AzureBlockManager;
import org.apache.hadoop.fs.azurebfs.services.AzureDFSBlockManager;
import org.apache.hadoop.fs.azurebfs.services.AzureIngressHandler;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureDFSIngressHandler
extends AzureIngressHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private AzureDFSBlockManager dfsBlockManager;
    private final AbfsDfsClient dfsClient;
    private String eTag;

    public AzureDFSIngressHandler(AbfsOutputStream abfsOutputStream, AbfsClientHandler clientHandler) {
        super(abfsOutputStream);
        this.dfsClient = clientHandler.getDfsClient();
    }

    public AzureDFSIngressHandler(AbfsOutputStream abfsOutputStream, DataBlocks.BlockFactory blockFactory, int bufferSize, String eTag, AbfsClientHandler clientHandler) {
        this(abfsOutputStream, clientHandler);
        this.eTag = eTag;
        this.dfsBlockManager = new AzureDFSBlockManager(abfsOutputStream, blockFactory, bufferSize);
        LOG.trace("Created a new DFSIngress Handler for AbfsOutputStream instance {} for path {}", (Object)abfsOutputStream.getStreamID(), (Object)abfsOutputStream.getPath());
    }

    @Override
    public int bufferData(AbfsBlock block, byte[] data, int off, int length) throws IOException {
        LOG.trace("Buffering data of length {} to block at offset {}", (Object)length, (Object)off);
        return block.write(data, off, length);
    }

    @Override
    protected AbfsRestOperation remoteWrite(AbfsBlock blockToUpload, DataBlocks.BlockUploadData uploadData, AppendRequestParameters reqParams, TracingContext tracingContext) throws IOException {
        TracingContext tracingContextAppend = new TracingContext(tracingContext);
        String threadIdStr = String.valueOf(Thread.currentThread().getId());
        if (tracingContextAppend.getIngressHandler().equals("")) {
            tracingContextAppend.setIngressHandler("D T " + threadIdStr);
            tracingContextAppend.setPosition(String.valueOf(blockToUpload.getOffset()));
        }
        LOG.trace("Starting remote write for block with offset {} and path {}", (Object)blockToUpload.getOffset(), (Object)this.getAbfsOutputStream().getPath());
        return this.getClient().append(this.getAbfsOutputStream().getPath(), uploadData.toByteArray(), reqParams, this.getAbfsOutputStream().getCachedSasTokenString(), this.getAbfsOutputStream().getContextEncryptionAdapter(), tracingContextAppend);
    }

    @Override
    protected AbfsRestOperation remoteAppendBlobWrite(String path, DataBlocks.BlockUploadData uploadData, AbfsBlock block, AppendRequestParameters reqParams, TracingContext tracingContext) throws IOException {
        return this.remoteWrite(block, uploadData, reqParams, tracingContext);
    }

    @Override
    protected synchronized AbfsRestOperation remoteFlush(long offset, boolean retainUncommitedData, boolean isClose, String leaseId, TracingContext tracingContext) throws IOException {
        TracingContext tracingContextFlush = new TracingContext(tracingContext);
        if (tracingContextFlush.getIngressHandler().equals("")) {
            tracingContextFlush.setIngressHandler("D");
            tracingContextFlush.setPosition(String.valueOf(offset));
        }
        LOG.trace("Flushing data at offset {} and path {}", (Object)offset, (Object)this.getAbfsOutputStream().getPath());
        return this.getClient().flush(this.getAbfsOutputStream().getPath(), offset, retainUncommitedData, isClose, this.getAbfsOutputStream().getCachedSasTokenString(), leaseId, this.getAbfsOutputStream().getContextEncryptionAdapter(), tracingContextFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeAppendBlobCurrentBufferToService() throws IOException {
        AbfsBlock activeBlock = this.dfsBlockManager.getActiveBlock();
        if (!this.getAbfsOutputStream().hasActiveBlockDataToUpload()) {
            return;
        }
        int bytesLength = activeBlock.dataSize();
        DataBlocks.BlockUploadData uploadData = activeBlock.startUpload();
        if (this.dfsBlockManager.hasActiveBlock()) {
            this.dfsBlockManager.clearActiveBlock();
        }
        this.getAbfsOutputStream().getOutputStreamStatistics().writeCurrentBuffer();
        this.getAbfsOutputStream().getOutputStreamStatistics().bytesToUpload(bytesLength);
        long offset = this.getAbfsOutputStream().getPosition();
        this.getAbfsOutputStream().setPosition(offset + (long)bytesLength);
        try (AbfsPerfInfo perfInfo = new AbfsPerfInfo(this.dfsClient.getAbfsPerfTracker(), "writeCurrentBufferToService", "append");){
            LOG.trace("Writing current buffer to service at offset {} and path {}", (Object)offset, (Object)this.getAbfsOutputStream().getPath());
            AppendRequestParameters reqParams = new AppendRequestParameters(offset, 0, bytesLength, AppendRequestParameters.Mode.APPEND_MODE, true, this.getAbfsOutputStream().getLeaseId(), this.getAbfsOutputStream().isExpectHeaderEnabled());
            AbfsRestOperation op = this.remoteWrite(activeBlock, uploadData, reqParams, new TracingContext(this.getAbfsOutputStream().getTracingContext()));
            this.getAbfsOutputStream().getCachedSasToken().update(op.getSasToken());
            this.getAbfsOutputStream().getOutputStreamStatistics().uploadSuccessful(bytesLength);
            perfInfo.registerResult(op.getResult());
            perfInfo.registerSuccess(true);
        }
        catch (Exception ex) {
            try {
                LOG.error("Failed to upload current buffer of length {} and path {}", new Object[]{bytesLength, this.getAbfsOutputStream().getPath(), ex});
                this.getAbfsOutputStream().getOutputStreamStatistics().uploadFailed(bytesLength);
                this.getAbfsOutputStream().failureWhileSubmit(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
                throw throwable;
            }
            IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
        }
        IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
    }

    @Override
    public AzureBlockManager getBlockManager() {
        return this.dfsBlockManager;
    }

    @Override
    public AbfsDfsClient getClient() {
        return this.dfsClient;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }
}

