/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog;

import java.util.regex.Pattern;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.SequenceLogger;
import org.apache.geode.internal.sequencelog.SequenceLoggerImpl;

public class RegionLogger {
    @Immutable
    private static final SequenceLogger GRAPH_LOGGER = SequenceLoggerImpl.getInstance();

    public static void logCreate(String regionName, InternalDistributedMember source) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "create", "created", source, source);
    }

    public static void logGII(String regionName, InternalDistributedMember source, InternalDistributedMember dest, PersistentMemberID persistentMemberID) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "GII", "created", source, dest);
        if (persistentMemberID != null) {
            GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "persist", "persisted", dest, persistentMemberID.getDiskStoreId());
        }
    }

    public static void logPersistence(String regionName, InternalDistributedMember source, PersistentMemberID disk) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "persist", "persisted", source, disk.getDiskStoreId());
    }

    public static void logRecovery(String regionName, PersistentMemberID disk, InternalDistributedMember memberId) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "recover", "created", disk.getDiskStoreId(), memberId);
    }

    public static void logDestroy(String regionName, InternalDistributedMember memberId, PersistentMemberID persistentID, boolean isClose) {
        if (RegionLogger.isEnabled()) {
            Pattern ALL_REGION_KEYS = Pattern.compile(regionName + ".*");
            GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "destroy", "destroyed", memberId, memberId);
            GRAPH_LOGGER.logTransition(GraphType.KEY, ALL_REGION_KEYS, "destroy", "destroyed", memberId, memberId);
            if (!isClose && persistentID != null) {
                GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "destroy", "destroyed", memberId, persistentID.getDiskStoreId());
                GRAPH_LOGGER.logTransition(GraphType.KEY, ALL_REGION_KEYS, "destroy", "destroyed", memberId, persistentID.getDiskStoreId());
            }
        }
    }

    public static boolean isEnabled() {
        return GRAPH_LOGGER.isEnabled(GraphType.REGION);
    }
}

