/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.ByteBufferSharing;

public class ByteBufferVendor {
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean isDestructed = new AtomicBoolean(false);
    private final AtomicInteger counter = new AtomicInteger(1);
    private final ByteBufferSharingInternal sharing;

    public ByteBufferVendor(ByteBuffer bufferArg, BufferPool.BufferType bufferType, BufferPool bufferPool) {
        this.sharing = new ByteBufferSharingInternalImpl(bufferArg, bufferType, bufferPool);
    }

    public ByteBufferSharing open() throws IOException {
        this.lock.lock();
        this.addReferenceAfterLock();
        return this.sharing;
    }

    public ByteBufferSharing open(long time, TimeUnit unit) throws OpenAttemptTimedOut, IOException {
        try {
            if (!this.lock.tryLock(time, unit)) {
                throw new OpenAttemptTimedOut();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpenAttemptTimedOut();
        }
        this.addReferenceAfterLock();
        return this.sharing;
    }

    public void destruct() {
        if (this.isDestructed.compareAndSet(false, true)) {
            this.dropReference();
        }
    }

    private void exposingResource() throws IOException {
        if (this.isDestructed.get()) {
            this.throwClosed();
        }
    }

    private void close() {
        this.lock.unlock();
        this.dropReference();
    }

    private int addReference() throws IOException {
        int usages;
        do {
            if ((usages = this.counter.get()) != 0 && !this.isDestructed.get()) continue;
            this.throwClosed();
        } while (!this.counter.compareAndSet(usages, usages + 1));
        return usages + 1;
    }

    private int dropReference() {
        int usages = this.counter.decrementAndGet();
        if (usages == 0) {
            this.sharing.releaseBuffer();
        }
        return usages;
    }

    private void addReferenceAfterLock() throws IOException {
        try {
            this.addReference();
        }
        catch (IOException e) {
            this.lock.unlock();
            throw e;
        }
    }

    private void throwClosed() throws IOException {
        throw new IOException("NioSslEngine has been closed");
    }

    @VisibleForTesting
    public void setBufferForTestingOnly(ByteBuffer newBufferForTesting) {
        ((ByteBufferSharingInternalImpl)this.sharing).buffer = newBufferForTesting;
    }

    private class ByteBufferSharingInternalImpl
    implements ByteBufferSharingInternal {
        private ByteBuffer buffer;
        private final BufferPool.BufferType bufferType;
        private final BufferPool bufferPool;

        public ByteBufferSharingInternalImpl(ByteBuffer buffer, BufferPool.BufferType bufferType, BufferPool bufferPool) {
            Objects.requireNonNull(buffer);
            this.buffer = buffer;
            this.bufferType = bufferType;
            this.bufferPool = bufferPool;
        }

        @Override
        public ByteBuffer getBuffer() throws IOException {
            ByteBufferVendor.this.exposingResource();
            return this.buffer;
        }

        @Override
        public ByteBuffer expandWriteBufferIfNeeded(int newCapacity) throws IOException {
            this.buffer = this.bufferPool.expandWriteBufferIfNeeded(this.bufferType, this.getBuffer(), newCapacity);
            return this.buffer;
        }

        @Override
        public ByteBuffer expandReadBufferIfNeeded(int newCapacity) throws IOException {
            this.buffer = this.bufferPool.expandReadBufferIfNeeded(this.bufferType, this.getBuffer(), newCapacity);
            return this.buffer;
        }

        @Override
        public void close() {
            ByteBufferVendor.this.close();
        }

        @Override
        public void releaseBuffer() {
            this.bufferPool.releaseBuffer(this.bufferType, this.buffer);
        }
    }

    private static interface ByteBufferSharingInternal
    extends ByteBufferSharing {
        public void releaseBuffer();
    }

    static class OpenAttemptTimedOut
    extends Exception {
        OpenAttemptTimedOut() {
        }
    }
}

