/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.internal.Assert;

public class BufferPool {
    private final DMStats stats;
    private Method parentOfSliceMethod;
    private final ConcurrentLinkedQueue<BBSoftReference> bufferQueue = new ConcurrentLinkedQueue();
    public static final boolean useDirectBuffers = !Boolean.getBoolean("p2p.nodirectBuffers");

    public BufferPool(DMStats stats) {
        this.stats = stats;
    }

    public ByteBuffer acquireDirectSenderBuffer(int size) {
        return this.acquireDirectBuffer(size, true);
    }

    public ByteBuffer acquireDirectReceiveBuffer(int size) {
        return this.acquireDirectBuffer(size, false);
    }

    private ByteBuffer acquireDirectBuffer(int size, boolean send) {
        ByteBuffer result;
        if (useDirectBuffers) {
            IdentityHashMap<BBSoftReference, BBSoftReference> alreadySeen = null;
            BBSoftReference ref = this.bufferQueue.poll();
            while (ref != null) {
                ByteBuffer bb = ref.getBB();
                if (bb == null) {
                    int refSize = ref.consumeSize();
                    if (refSize > 0) {
                        if (ref.getSend()) {
                            this.stats.incSenderBufferSize(-refSize, true);
                        } else {
                            this.stats.incReceiverBufferSize(-refSize, true);
                        }
                    }
                } else {
                    int capacity = bb.capacity();
                    if (capacity > size) {
                        bb.position(0).limit(size);
                        return bb.slice();
                    }
                    if (capacity == size) {
                        bb.rewind();
                        bb.limit(size);
                        return bb;
                    }
                    Assert.assertTrue(this.bufferQueue.offer(ref));
                    if (alreadySeen == null) {
                        alreadySeen = new IdentityHashMap<BBSoftReference, BBSoftReference>();
                    }
                    if (alreadySeen.put(ref, ref) != null) break;
                }
                ref = this.bufferQueue.poll();
            }
            result = ByteBuffer.allocateDirect(size);
        } else {
            result = ByteBuffer.allocate(size);
        }
        if (send) {
            this.stats.incSenderBufferSize(size, useDirectBuffers);
        } else {
            this.stats.incReceiverBufferSize(size, useDirectBuffers);
        }
        return result;
    }

    public ByteBuffer acquireNonDirectSenderBuffer(int size) {
        ByteBuffer result = ByteBuffer.allocate(size);
        this.stats.incSenderBufferSize(size, false);
        return result;
    }

    public ByteBuffer acquireNonDirectReceiveBuffer(int size) {
        ByteBuffer result = ByteBuffer.allocate(size);
        this.stats.incReceiverBufferSize(size, false);
        return result;
    }

    public void releaseSenderBuffer(ByteBuffer bb) {
        this.releaseBuffer(bb, true);
    }

    public void releaseReceiveBuffer(ByteBuffer bb) {
        this.releaseBuffer(bb, false);
    }

    ByteBuffer expandReadBufferIfNeeded(BufferType type, ByteBuffer existing, int desiredCapacity) {
        if (existing.capacity() >= desiredCapacity) {
            if (existing.position() > 0) {
                existing.compact();
                existing.flip();
            }
            return existing;
        }
        ByteBuffer newBuffer = existing.isDirect() ? this.acquireDirectBuffer(type, desiredCapacity) : this.acquireNonDirectBuffer(type, desiredCapacity);
        newBuffer.clear();
        newBuffer.put(existing);
        newBuffer.flip();
        this.releaseBuffer(type, existing);
        return newBuffer;
    }

    ByteBuffer expandWriteBufferIfNeeded(BufferType type, ByteBuffer existing, int desiredCapacity) {
        if (existing.capacity() >= desiredCapacity) {
            return existing;
        }
        ByteBuffer newBuffer = existing.isDirect() ? this.acquireDirectBuffer(type, desiredCapacity) : this.acquireNonDirectBuffer(type, desiredCapacity);
        newBuffer.clear();
        existing.flip();
        newBuffer.put(existing);
        this.releaseBuffer(type, existing);
        return newBuffer;
    }

    ByteBuffer acquireDirectBuffer(BufferType type, int capacity) {
        switch (type) {
            case UNTRACKED: {
                return ByteBuffer.allocate(capacity);
            }
            case TRACKED_SENDER: {
                return this.acquireDirectSenderBuffer(capacity);
            }
            case TRACKED_RECEIVER: {
                return this.acquireDirectReceiveBuffer(capacity);
            }
        }
        throw new IllegalArgumentException("Unexpected buffer type " + type.toString());
    }

    ByteBuffer acquireNonDirectBuffer(BufferType type, int capacity) {
        switch (type) {
            case UNTRACKED: {
                return ByteBuffer.allocate(capacity);
            }
            case TRACKED_SENDER: {
                return this.acquireNonDirectSenderBuffer(capacity);
            }
            case TRACKED_RECEIVER: {
                return this.acquireNonDirectReceiveBuffer(capacity);
            }
        }
        throw new IllegalArgumentException("Unexpected buffer type " + type.toString());
    }

    void releaseBuffer(BufferType type, ByteBuffer buffer) {
        switch (type) {
            case UNTRACKED: {
                return;
            }
            case TRACKED_SENDER: {
                this.releaseSenderBuffer(buffer);
                return;
            }
            case TRACKED_RECEIVER: {
                this.releaseReceiveBuffer(buffer);
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected buffer type " + type.toString());
    }

    private void releaseBuffer(ByteBuffer bb, boolean send) {
        if (bb.isDirect()) {
            bb = this.getPoolableBuffer(bb);
            BBSoftReference bbRef = new BBSoftReference(bb, send);
            this.bufferQueue.offer(bbRef);
        } else if (send) {
            this.stats.incSenderBufferSize(-bb.capacity(), false);
        } else {
            this.stats.incReceiverBufferSize(-bb.capacity(), false);
        }
    }

    @VisibleForTesting
    public ByteBuffer getPoolableBuffer(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return buffer;
        }
        ByteBuffer result = buffer;
        if (this.parentOfSliceMethod == null) {
            Class<?> clazz = buffer.getClass();
            try {
                Method method = clazz.getMethod("attachment", new Class[0]);
                method.setAccessible(true);
                this.parentOfSliceMethod = method;
            }
            catch (Exception e) {
                throw new InternalGemFireException("unable to retrieve underlying byte buffer", e);
            }
        }
        try {
            Object attachment = this.parentOfSliceMethod.invoke((Object)buffer, new Object[0]);
            if (attachment instanceof ByteBuffer) {
                result = (ByteBuffer)attachment;
            } else if (attachment != null) {
                throw new InternalGemFireException("direct byte buffer attachment was not a byte buffer but a " + attachment.getClass().getName());
            }
        }
        catch (Exception e) {
            throw new InternalGemFireException("unable to retrieve underlying byte buffer", e);
        }
        return result;
    }

    private static class BBSoftReference
    extends SoftReference<ByteBuffer> {
        private int size;
        private final boolean send;

        BBSoftReference(ByteBuffer bb, boolean send) {
            super(bb);
            this.size = bb.capacity();
            this.send = send;
        }

        public int getSize() {
            return this.size;
        }

        synchronized int consumeSize() {
            int result = this.size;
            this.size = 0;
            return result;
        }

        public boolean getSend() {
            return this.send;
        }

        public ByteBuffer getBB() {
            return (ByteBuffer)super.get();
        }
    }

    public static enum BufferType {
        UNTRACKED,
        TRACKED_SENDER,
        TRACKED_RECEIVER;

    }
}

