/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class GetClientPartitionAttributesCommand66
extends BaseCommand {
    @Immutable
    private static final GetClientPartitionAttributesCommand66 singleton = new GetClientPartitionAttributesCommand66();

    public static Command getCommand() {
        return singleton;
    }

    GetClientPartitionAttributesCommand66() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        String regionFullPath = null;
        regionFullPath = clientMessage.getPart(0).getCachedString();
        String errMessage = "";
        if (regionFullPath == null) {
            logger.warn("The input region path for the GetClientPartitionAttributes request is null");
            errMessage = "The input region path for the GetClientPartitionAttributes request is null";
            GetClientPartitionAttributesCommand66.writeErrorResponse(clientMessage, 76, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Region region = serverConnection.getCache().getRegion(regionFullPath);
        if (region == null) {
            logger.warn("Region was not found during GetClientPartitionAttributes request for region path : %s", (Object)regionFullPath);
            errMessage = "Region was not found during GetClientPartitionAttributes request for region path : " + regionFullPath;
            GetClientPartitionAttributesCommand66.writeErrorResponse(clientMessage, 76, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            Message responseMsg = serverConnection.getResponseMessage();
            responseMsg.setTransactionId(clientMessage.getTransactionId());
            responseMsg.setMessageType(74);
            if (!(region instanceof PartitionedRegion)) {
                responseMsg.setNumberOfParts(2);
                responseMsg.addObjPart(-1);
                responseMsg.addObjPart(region.getFullPath());
            } else {
                PartitionedRegion prRgion = (PartitionedRegion)region;
                PartitionResolver partitionResolver = prRgion.getPartitionResolver();
                int numParts = 2;
                if (partitionResolver != null) {
                    ++numParts;
                }
                if (prRgion.isFixedPartitionedRegion()) {
                    ++numParts;
                }
                responseMsg.setNumberOfParts(numParts);
                responseMsg.addObjPart(prRgion.getTotalNumberOfBuckets());
                String leaderRegionPath = null;
                PartitionedRegion leaderRegion = null;
                String leaderRegionName = prRgion.getColocatedWith();
                if (leaderRegionName != null) {
                    InternalCache cache = prRgion.getCache();
                    while (leaderRegionName != null) {
                        leaderRegion = (PartitionedRegion)cache.getRegion(leaderRegionName);
                        if (leaderRegion.getColocatedWith() == null) {
                            leaderRegionPath = leaderRegion.getFullPath();
                            break;
                        }
                        leaderRegionName = leaderRegion.getColocatedWith();
                    }
                }
                responseMsg.addObjPart(leaderRegionPath);
                if (partitionResolver != null) {
                    responseMsg.addObjPart(partitionResolver.getClass().toString().substring(6));
                }
                if (prRgion.isFixedPartitionedRegion()) {
                    Set<FixedPartitionAttributes> fpaSet = null;
                    fpaSet = leaderRegion != null ? PartitionedRegionHelper.getAllFixedPartitionAttributes(leaderRegion) : PartitionedRegionHelper.getAllFixedPartitionAttributes(prRgion);
                    responseMsg.addObjPart(fpaSet);
                }
            }
            responseMsg.send();
            clientMessage.clearParts();
        }
        catch (Exception e) {
            GetClientPartitionAttributesCommand66.writeException(clientMessage, e, false, serverConnection);
        }
        finally {
            serverConnection.setAsTrue(1);
        }
    }
}

