/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionOrdinal;

public class ClientInstantiatorMessage
extends ClientUpdateMessageImpl {
    private static final long serialVersionUID = 2949326125521840437L;
    private byte[][] serializedInstantiators;

    public ClientInstantiatorMessage(EnumListenerEvent operation, byte[][] instantiator, ClientProxyMembershipID memberId, EventID eventIdentifier) {
        super(operation, memberId, eventIdentifier);
        this.serializedInstantiators = instantiator;
    }

    @Override
    public boolean isClientInterested(ClientProxyMembershipID clientId) {
        return true;
    }

    @Override
    public boolean needsNoAuthorizationCheck() {
        return true;
    }

    public ClientInstantiatorMessage() {
    }

    @Override
    public boolean shouldBeConflated() {
        return false;
    }

    @Override
    protected Message getMessage(CacheClientProxy proxy, byte[] latestValue) throws IOException {
        Version clientVersion = proxy.getVersion();
        Message message = null;
        if (clientVersion.compareTo((VersionOrdinal)Version.GFE_57) < 0) {
            throw new IOException("Unsupported client version for server-to-client message creation: " + clientVersion);
        }
        message = this.getGFEMessage(proxy.getProxyID(), null, clientVersion);
        return message;
    }

    @Override
    protected Message getGFEMessage(ClientProxyMembershipID proxy, byte[] latestValue, Version clientVersion) throws IOException {
        Message message = null;
        int instantiatorsLength = this.serializedInstantiators.length;
        message = new Message(instantiatorsLength + 1, clientVersion);
        message.setMessageType(51);
        for (int i = 0; i < instantiatorsLength; i += 3) {
            message.addBytesPart(this.serializedInstantiators[i]);
            message.addBytesPart(this.serializedInstantiators[i + 1]);
            message.addBytesPart(this.serializedInstantiators[i + 2]);
        }
        message.setTransactionId(0);
        message.addObjPart(this.getEventId());
        return message;
    }

    @Override
    public int getDSFID() {
        return 11;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeByte(this._operation.getEventCode());
        int instantiatorCount = this.serializedInstantiators.length;
        out.writeInt(instantiatorCount);
        for (int i = 0; i < instantiatorCount; ++i) {
            DataSerializer.writeByteArray(this.serializedInstantiators[i], out);
        }
        context.getSerializer().writeObject((Object)this._membershipId, out);
        context.getSerializer().writeObject((Object)this._eventIdentifier, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this._operation = EnumListenerEvent.getEnumListenerEvent(in.readByte());
        int instantiatorCount = in.readInt();
        this.serializedInstantiators = new byte[instantiatorCount][];
        for (int i = 0; i < instantiatorCount; ++i) {
            this.serializedInstantiators[i] = DataSerializer.readByteArray(in);
        }
        this._membershipId = ClientProxyMembershipID.readCanonicalized(in);
        this._eventIdentifier = (EventID)context.getDeserializer().readObject(in);
    }

    @Override
    public Object getKeyToConflate() {
        return null;
    }

    @Override
    public String getRegionToConflate() {
        return null;
    }

    @Override
    public Object getValueToConflate() {
        return null;
    }

    @Override
    public void setLatestValue(Object value) {
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClientInstantiatorMessage[value=").append(Arrays.toString((Object[])this.serializedInstantiators)).append(";memberId=").append(this.getMembershipId()).append(";eventId=").append(this.getEventId()).append("]");
        return buffer.toString();
    }
}

