/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.execute.metrics.FunctionServiceStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class FunctionStatsImpl
implements FunctionStats {
    private static final String STATISTICS_NAME = "FunctionStatistics";
    @Immutable
    private static final StatisticsType STATISTICS_TYPE;
    private static final String FUNCTION_EXECUTIONS_COMPLETED = "functionExecutionsCompleted";
    private static final String FUNCTION_EXECUTIONS_COMPLETED_PROCESSING_TIME = "functionExecutionsCompletedProcessingTime";
    private static final String FUNCTION_EXECUTIONS_RUNNING = "functionExecutionsRunning";
    private static final String RESULTS_SENT_TO_RESULT_COLLECTOR = "resultsSentToResultCollector";
    private static final String FUNCTION_EXECUTION_CALLS = "functionExecutionCalls";
    private static final String FUNCTION_EXECUTIONS_HAS_RESULT_COMPLETED_PROCESSING_TIME = "functionExecutionsHasResultCompletedProcessingTime";
    private static final String FUNCTION_EXECUTIONS_HAS_RESULT_RUNNING = "functionExecutionsHasResultRunning";
    private static final String RESULTS_RECEIVED = "resultsReceived";
    private static final String FUNCTION_EXECUTION_EXCEPTIONS = "functionExecutionsExceptions";
    private static final int functionExecutionsCompletedId;
    private static final int functionExecutionsCompletedProcessingTimeId;
    private static final int functionExecutionsRunningId;
    private static final int resultsSentToResultCollectorId;
    private static final int functionExecutionCallsId;
    private static final int functionExecutionsHasResultCompletedProcessingTimeId;
    private static final int functionExecutionsHasResultRunningId;
    private static final int resultsReceivedId;
    private static final int functionExecutionExceptionsId;
    private final MeterRegistry meterRegistry;
    private final Statistics statistics;
    private final FunctionServiceStats aggregateStatistics;
    private final LongSupplier clock;
    private final BooleanSupplier timeStatisticsEnabled;
    private final Timer successTimer;
    private final Timer failureTimer;
    private final AtomicBoolean isClosed;

    FunctionStatsImpl(String functionId, MeterRegistry meterRegistry, Statistics statistics, FunctionServiceStats functionServiceStats) {
        this(functionId, meterRegistry, statistics, functionServiceStats, NanoTimer::getTime, () -> DistributionStats.enableClockStats, FunctionStatsImpl::registerSuccessTimer, FunctionStatsImpl::registerFailureTimer);
    }

    @VisibleForTesting
    FunctionStatsImpl(String functionId, MeterRegistry meterRegistry, Statistics statistics, FunctionServiceStats aggregateStatistics, long clockResult, boolean timeStatisticsEnabledResult) {
        this(functionId, meterRegistry, statistics, aggregateStatistics, () -> clockResult, () -> timeStatisticsEnabledResult, FunctionStatsImpl::registerSuccessTimer, FunctionStatsImpl::registerFailureTimer);
    }

    @VisibleForTesting
    FunctionStatsImpl(String functionId, MeterRegistry meterRegistry, Statistics statistics, FunctionServiceStats aggregateStatistics, long clockResult, boolean timeStatisticsEnabledResult, Timer successTimerResult, Timer registerFailureResult) {
        this(functionId, meterRegistry, statistics, aggregateStatistics, () -> clockResult, () -> timeStatisticsEnabledResult, (String a, MeterRegistry b) -> successTimerResult, (String a, MeterRegistry b) -> registerFailureResult);
    }

    private FunctionStatsImpl(String functionId, MeterRegistry meterRegistry, Statistics statistics, FunctionServiceStats aggregateStatistics, LongSupplier clock, BooleanSupplier timeStatisticsEnabled, BiFunction<String, MeterRegistry, Timer> registerSuccessTimerFunction, BiFunction<String, MeterRegistry, Timer> registerFailureTimerFunction) {
        Objects.requireNonNull(meterRegistry);
        this.meterRegistry = meterRegistry;
        this.statistics = statistics;
        this.aggregateStatistics = aggregateStatistics;
        this.clock = clock;
        this.timeStatisticsEnabled = timeStatisticsEnabled;
        this.isClosed = new AtomicBoolean(false);
        this.successTimer = registerSuccessTimerFunction.apply(functionId, meterRegistry);
        this.failureTimer = registerFailureTimerFunction.apply(functionId, meterRegistry);
    }

    @Override
    public void close() {
        this.meterRegistry.remove((Meter)this.successTimer);
        this.successTimer.close();
        this.meterRegistry.remove((Meter)this.failureTimer);
        this.failureTimer.close();
        this.statistics.close();
        this.isClosed.set(true);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public int getFunctionExecutionsCompleted() {
        return this.statistics.getInt(functionExecutionsCompletedId);
    }

    @Override
    public int getFunctionExecutionsRunning() {
        return this.statistics.getInt(functionExecutionsRunningId);
    }

    @Override
    public void incResultsReturned() {
        this.statistics.incInt(resultsSentToResultCollectorId, 1);
        this.aggregateStatistics.incResultsReturned();
    }

    @Override
    public int getResultsReceived() {
        return this.statistics.getInt(resultsReceivedId);
    }

    @Override
    public void incResultsReceived() {
        this.statistics.incInt(resultsReceivedId, 1);
        this.aggregateStatistics.incResultsReceived();
    }

    @Override
    public int getFunctionExecutionCalls() {
        return this.statistics.getInt(functionExecutionCallsId);
    }

    @Override
    public long startFunctionExecution(boolean haveResult) {
        this.statistics.incInt(functionExecutionCallsId, 1);
        this.statistics.incInt(functionExecutionsRunningId, 1);
        if (haveResult) {
            this.statistics.incInt(functionExecutionsHasResultRunningId, 1);
        }
        this.aggregateStatistics.startFunctionExecution(haveResult);
        return this.clock.getAsLong();
    }

    @Override
    public void endFunctionExecution(long startTime, boolean haveResult) {
        long elapsedNanos = this.clock.getAsLong() - startTime;
        this.successTimer.record(elapsedNanos, TimeUnit.NANOSECONDS);
        this.statistics.incInt(functionExecutionsCompletedId, 1);
        this.statistics.incInt(functionExecutionsRunningId, -1);
        if (this.timeStatisticsEnabled.getAsBoolean()) {
            this.statistics.incLong(functionExecutionsCompletedProcessingTimeId, elapsedNanos);
        }
        if (haveResult) {
            this.statistics.incInt(functionExecutionsHasResultRunningId, -1);
            if (this.timeStatisticsEnabled.getAsBoolean()) {
                this.statistics.incLong(functionExecutionsHasResultCompletedProcessingTimeId, elapsedNanos);
            }
        }
        this.aggregateStatistics.endFunctionExecutionWithElapsedTime(elapsedNanos, haveResult);
    }

    @Override
    public void endFunctionExecutionWithException(long startTime, boolean haveResult) {
        long elapsedNanos = this.clock.getAsLong() - startTime;
        this.failureTimer.record(elapsedNanos, TimeUnit.NANOSECONDS);
        this.statistics.incInt(functionExecutionsRunningId, -1);
        this.statistics.incInt(functionExecutionExceptionsId, 1);
        if (haveResult) {
            this.statistics.incInt(functionExecutionsHasResultRunningId, -1);
        }
        this.aggregateStatistics.endFunctionExecutionWithException(haveResult);
    }

    @Override
    @VisibleForTesting
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    @VisibleForTesting
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public static StatisticsType getStatisticsType() {
        return STATISTICS_TYPE;
    }

    @VisibleForTesting
    static int functionExecutionsCompletedId() {
        return functionExecutionsCompletedId;
    }

    @VisibleForTesting
    static int functionExecutionsRunningId() {
        return functionExecutionsRunningId;
    }

    @VisibleForTesting
    static int functionExecutionsHasResultRunningId() {
        return functionExecutionsHasResultRunningId;
    }

    @VisibleForTesting
    static int functionExecutionsCompletedProcessingTimeId() {
        return functionExecutionsCompletedProcessingTimeId;
    }

    @VisibleForTesting
    static int functionExecutionsHasResultCompletedProcessingTimeId() {
        return functionExecutionsHasResultCompletedProcessingTimeId;
    }

    @VisibleForTesting
    static int functionExecutionExceptionsId() {
        return functionExecutionExceptionsId;
    }

    private static Timer registerSuccessTimer(String functionId, MeterRegistry meterRegistry) {
        return Timer.builder((String)"geode.function.executions").description("Count and total time of successful function executions").tag("function", functionId).tag("succeeded", Boolean.TRUE.toString()).register(meterRegistry);
    }

    private static Timer registerFailureTimer(String functionId, MeterRegistry meterRegistry) {
        return Timer.builder((String)"geode.function.executions").description("Count and total time of failed function executions").tag("function", functionId).tag("succeeded", Boolean.FALSE.toString()).register(meterRegistry);
    }

    static {
        String statDescription = "This is the stats for the individual Function's Execution";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        STATISTICS_TYPE = f.createType(STATISTICS_NAME, statDescription, new StatisticDescriptor[]{f.createIntCounter(FUNCTION_EXECUTIONS_COMPLETED, "Total number of completed function.execute() calls for given function", "operations"), f.createLongCounter(FUNCTION_EXECUTIONS_COMPLETED_PROCESSING_TIME, "Total time consumed for all completed invocations of the given function", "nanoseconds"), f.createIntGauge(FUNCTION_EXECUTIONS_RUNNING, "number of currently running invocations of the given function", "operations"), f.createIntCounter(RESULTS_SENT_TO_RESULT_COLLECTOR, "Total number of results sent to the ResultCollector", "operations"), f.createIntCounter(RESULTS_RECEIVED, "Total number of results received and passed to the ResultCollector", "operations"), f.createIntCounter(FUNCTION_EXECUTION_CALLS, "Total number of FunctionService.execute() calls for given function", "operations"), f.createLongCounter(FUNCTION_EXECUTIONS_HAS_RESULT_COMPLETED_PROCESSING_TIME, "Total time consumed for all completed given function.execute() calls where hasResult() returns true.", "nanoseconds"), f.createIntGauge(FUNCTION_EXECUTIONS_HAS_RESULT_RUNNING, "A gauge indicating the number of currently active execute() calls for functions where hasResult() returns true.", "operations"), f.createIntCounter(FUNCTION_EXECUTION_EXCEPTIONS, "Total number of Exceptions Occurred while executing function", "operations")});
        functionExecutionsCompletedId = STATISTICS_TYPE.nameToId(FUNCTION_EXECUTIONS_COMPLETED);
        functionExecutionsCompletedProcessingTimeId = STATISTICS_TYPE.nameToId(FUNCTION_EXECUTIONS_COMPLETED_PROCESSING_TIME);
        functionExecutionsRunningId = STATISTICS_TYPE.nameToId(FUNCTION_EXECUTIONS_RUNNING);
        resultsSentToResultCollectorId = STATISTICS_TYPE.nameToId(RESULTS_SENT_TO_RESULT_COLLECTOR);
        functionExecutionCallsId = STATISTICS_TYPE.nameToId(FUNCTION_EXECUTION_CALLS);
        functionExecutionsHasResultCompletedProcessingTimeId = STATISTICS_TYPE.nameToId(FUNCTION_EXECUTIONS_HAS_RESULT_COMPLETED_PROCESSING_TIME);
        functionExecutionsHasResultRunningId = STATISTICS_TYPE.nameToId(FUNCTION_EXECUTIONS_HAS_RESULT_RUNNING);
        functionExecutionExceptionsId = STATISTICS_TYPE.nameToId(FUNCTION_EXECUTION_EXCEPTIONS);
        resultsReceivedId = STATISTICS_TYPE.nameToId(RESULTS_RECEIVED);
    }
}

