/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryOffHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMStatsLRURegionEntryOffHeapStringKey1
extends VMStatsLRURegionEntryOffHeap {
    private static final AtomicLongFieldUpdater<VMStatsLRURegionEntryOffHeapStringKey1> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapStringKey1.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile long offHeapAddress;
    private static final AtomicLongFieldUpdater<VMStatsLRURegionEntryOffHeapStringKey1> OFF_HEAP_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapStringKey1.class, "offHeapAddress");
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsLRURegionEntryOffHeapStringKey1> HIT_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapStringKey1.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsLRURegionEntryOffHeapStringKey1> MISS_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapStringKey1.class, "missCount");
    private final long bits1;
    private EvictionNode nextEvictionNode;
    private EvictionNode previousEvictionNode;
    private int size;

    public VMStatsLRURegionEntryOffHeapStringKey1(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value);
        long tempBits1 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                tempBits1 <<= 8;
            }
            tempBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)key.charAt(i);
                tempBits1 <<= 16;
            }
        }
        this.bits1 = tempBits1 |= (long)key.length();
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object value) {
        OffHeapRegionEntryHelper.setValue(this, value);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return OFF_HEAP_ADDRESS_UPDATER.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddress, long newAddress) {
        return OFF_HEAP_ADDRESS_UPDATER.compareAndSet(this, expectedAddress, newAddress);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    @Override
    public void setDelayedDiskId(DiskRecoveryStore diskRecoveryStore) {
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController) {
        return this.updateEntrySize(evictionController, this.getValue());
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = evictionController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean isRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed(RegionEntryContext context) {
        if (!this.isRecentlyUsed()) {
            this.setBits(0x1000000000000000L);
            context.incRecentlyUsed();
        }
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean isEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNext(EvictionNode nextEvictionNode) {
        this.nextEvictionNode = nextEvictionNode;
    }

    @Override
    public EvictionNode next() {
        return this.nextEvictionNode;
    }

    @Override
    public void setPrevious(EvictionNode previousEvictionNode) {
        this.previousEvictionNode = previousEvictionNode;
    }

    @Override
    public EvictionNode previous() {
        return this.previousEvictionNode;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public void updateStatsForGet(boolean isHit, long time) {
        this.setLastAccessed(time);
        if (isHit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    @Override
    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        HIT_COUNT_UPDATER.incrementAndGet(this);
    }

    private void incrementMissCount() {
        MISS_COUNT_UPDATER.incrementAndGet(this);
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        HIT_COUNT_UPDATER.set(this, 0);
        MISS_COUNT_UPDATER.set(this, 0);
    }

    @Override
    public void txDidDestroy(long timeStamp) {
        this.setLastModified(timeStamp);
        this.setLastAccessed(timeStamp);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keyLength = this.getKeyLength();
        char[] chars = new char[keyLength];
        long tempBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            int keyLength = this.getKeyLength();
            if (stringKey.length() == keyLength) {
                long tempBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 8) & 0xFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 16) & 0xFFFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

