/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

class BackupConfigFactory {
    private String targetDirPath;
    private String baselineDirPath;

    BackupConfigFactory() {
    }

    BackupConfigFactory withTargetDirPath(String targetDirPath) {
        this.targetDirPath = targetDirPath;
        return this;
    }

    BackupConfigFactory withBaselineDirPath(String baselineDirPath) {
        this.baselineDirPath = baselineDirPath;
        return this;
    }

    Properties createBackupProperties() {
        Properties properties = new Properties();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        properties.setProperty("TIMESTAMP", format.format(new Date()));
        properties.setProperty("TYPE", "FileSystem");
        properties.setProperty("TARGET_DIRECTORY", this.targetDirPath);
        if (this.baselineDirPath != null) {
            properties.setProperty("BASELINE_DIRECTORY", this.baselineDirPath);
        }
        return properties;
    }
}

