/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.GemFireException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.cache.client.internal.ServerRegionDataAccess;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PeerTXStateStub;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXEvent;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXRegionState;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.ClientTXStateStub;
import org.apache.geode.internal.cache.tx.TransactionalOperation;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TXStateProxyImpl
implements TXStateProxy {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    protected static final AtomicBoolean txDistributedClientWarningIssued = new AtomicBoolean();
    private boolean isJTA;
    private TXId txId;
    protected final TXManagerImpl txMgr;
    protected DistributedMember target;
    private boolean commitRequestedByOwner;
    private boolean isJCATransaction;
    private final ReentrantLock lock = new ReentrantLock();
    private int operationCount = 0;
    private Map<Integer, Boolean> buckets = new HashMap<Integer, Boolean>();
    private boolean firstOperationOnPartitionedRegion = false;
    protected volatile TXStateInterface realDeal;
    protected boolean inProgress = true;
    protected InternalDistributedMember onBehalfOfClientMember = null;
    private final InternalCache cache;
    private long lastOperationTimeFromClient;
    private final StatisticsClock statisticsClock;
    private boolean removedCausedByFailover = false;
    protected final boolean restoreSetOperationTransactionBehavior = SystemPropertyHelper.restoreSetOperationTransactionBehavior();

    public TXStateProxyImpl(InternalCache cache, TXManagerImpl managerImpl, TXId id, InternalDistributedMember clientMember, StatisticsClock statisticsClock) {
        this.cache = cache;
        this.txMgr = managerImpl;
        this.txId = id;
        this.isJTA = false;
        this.onBehalfOfClientMember = clientMember;
        this.statisticsClock = statisticsClock;
    }

    public TXStateProxyImpl(InternalCache cache, TXManagerImpl managerImpl, TXId id, boolean isjta, StatisticsClock statisticsClock) {
        this.cache = cache;
        this.txMgr = managerImpl;
        this.txId = id;
        this.isJTA = isjta;
        this.statisticsClock = statisticsClock;
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    protected StatisticsClock getStatisticsClock() {
        return this.statisticsClock;
    }

    boolean isJTA() {
        return this.isJTA;
    }

    @Override
    public TXId getTxId() {
        return this.txId;
    }

    @Override
    public TXManagerImpl getTxMgr() {
        return this.txMgr;
    }

    public TXStateInterface getRealDeal(KeyInfo key, InternalRegion r) {
        if (this.realDeal == null) {
            if (r == null) {
                this.realDeal = new TXState(this, false, this.statisticsClock);
            } else if (r.hasServerProxy()) {
                this.realDeal = new ClientTXStateStub((InternalCache)r.getCache(), r.getDistributionManager(), this, this.target, r);
                if (r.getScope().isDistributed() && txDistributedClientWarningIssued.compareAndSet(false, true)) {
                    logger.warn("Distributed region {} is being used in a client-initiated transaction.  The transaction will only affect servers and this client.  To keep from seeing this message use 'local' scope in client regions used in transactions.", (Object)r.getFullPath());
                }
            } else {
                this.target = null;
                r.waitOnInitialization(r.getInitializationLatchBeforeGetInitialImage());
                this.target = r.getOwnerForKey(key);
                this.realDeal = this.target == null || this.target.equals(this.txMgr.getDM().getId()) ? new TXState(this, false, this.statisticsClock) : new PeerTXStateStub(this, this.target, this.onBehalfOfClientMember);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Built a new TXState: {} me:{}", (Object)this.realDeal, (Object)this.txMgr.getDM().getId());
            }
        }
        if (this.isRealDealLocal() && !((TXState)this.realDeal).hasPerformedAnyOperation() && r != null && (r instanceof PartitionedRegion || r.isUsedForPartitionedRegionBucket())) {
            this.firstOperationOnPartitionedRegion = true;
        }
        return this.realDeal;
    }

    public TXStateInterface getRealDeal(DistributedMember t) {
        assert (t != null);
        if (this.realDeal == null) {
            this.target = t;
            this.realDeal = this.target.equals(this.getCache().getDistributedSystem().getDistributedMember()) ? new TXState(this, false, this.statisticsClock) : new PeerTXStateStub(this, this.target, this.onBehalfOfClientMember);
            if (logger.isDebugEnabled()) {
                logger.debug("Built a new TXState: {} me:{}", (Object)this.realDeal, (Object)this.txMgr.getDM().getId());
            }
        }
        return this.realDeal;
    }

    protected void setTXIDForReplay(TXId id) {
        this.txId = id;
    }

    @Override
    public boolean isOnBehalfOfClient() {
        return this.onBehalfOfClientMember != null;
    }

    @Override
    public void setIsJTA(boolean isJTA) {
        this.isJTA = isJTA;
    }

    @Override
    public void checkJTA(String errmsg) throws IllegalStateException {
        if (this.isJTA()) {
            throw new IllegalStateException(errmsg);
        }
    }

    boolean isRemovedCausedByFailover() {
        return this.removedCausedByFailover;
    }

    void setRemovedCausedByFailover(boolean removedCausedByFailover) {
        this.removedCausedByFailover = removedCausedByFailover;
    }

    @Override
    public void precommit() throws CommitConflictException, UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(String.format("precommit() operation %s meant for Dist Tx is not supported", "precommit"));
    }

    @Override
    public void commit() throws CommitConflictException {
        boolean preserveTx = false;
        try {
            this.getRealDeal(null, null).commit();
        }
        catch (UnsupportedOperationInTransactionException e) {
            preserveTx = true;
            throw e;
        }
        finally {
            this.inProgress = preserveTx;
        }
    }

    TransactionException getTransactionException(KeyInfo keyInfo, GemFireException e) {
        if (this.isRealDealLocal() && !this.buckets.isEmpty() && !this.buckets.containsKey(keyInfo.getBucketId())) {
            TransactionDataNotColocatedException ex = new TransactionDataNotColocatedException(String.format("Key %s is not colocated with transaction", keyInfo.getKey()));
            ex.initCause(e.getCause());
            return ex;
        }
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof PrimaryBucketException)) continue;
            if (this.isRealDealLocal() && !this.firstOperationOnPartitionedRegion) {
                return new TransactionDataNotColocatedException(String.format("Key %s is not colocated with transaction. First operation in a transaction should be on a partitioned region when there are operations on both partitioned regions and replicate regions.", keyInfo.getKey()));
            }
            return new TransactionDataRebalancedException("Transactional data moved, due to rebalancing.");
        }
        return (TransactionException)e;
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo, LocalRegion region) {
        try {
            ++this.operationCount;
            boolean retVal = this.getRealDeal(keyInfo, region).containsValueForKey(keyInfo, region);
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(keyInfo, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(keyInfo, primaryBucketException);
        }
    }

    private TransactionException handleTransactionDataRebalancedException(KeyInfo keyInfo, TransactionDataRebalancedException transactionDataRebalancedException) {
        if (this.isRealDealLocal()) {
            return this.getTransactionException(keyInfo, transactionDataRebalancedException);
        }
        return transactionDataRebalancedException;
    }

    void trackBucketForTx(KeyInfo keyInfo) {
        if (keyInfo.getBucketId() >= 0 && logger.isDebugEnabled()) {
            logger.debug("adding bucket:{} for tx:{}", (Object)keyInfo.getBucketId(), (Object)this.getTransactionId());
        }
        if (keyInfo.getBucketId() >= 0) {
            this.buckets.put(keyInfo.getBucketId(), Boolean.TRUE);
        }
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException {
        try {
            ++this.operationCount;
            this.getRealDeal(event.getKeyInfo(), event.getRegion()).destroyExistingEntry(event, cacheWrite, expectedOldValue);
            this.trackBucketForTx(event.getKeyInfo());
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(event.getKeyInfo(), transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(event.getKeyInfo(), primaryBucketException);
        }
    }

    @Override
    public long getBeginTime() {
        return this.getRealDeal(null, null).getBeginTime();
    }

    @Override
    public InternalCache getCache() {
        return this.cache;
    }

    @Override
    public int getChanges() {
        this.assertBootstrapped();
        return this.getRealDeal(null, null).getChanges();
    }

    @Override
    public Object getDeserializedValue(KeyInfo keyInfo, LocalRegion localRegion, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones, boolean retainResult, boolean createIfAbsent) {
        try {
            Object val = this.getRealDeal(keyInfo, localRegion).getDeserializedValue(keyInfo, localRegion, updateStats, disableCopyOnRead, preferCD, null, false, retainResult, createIfAbsent);
            this.trackBucketForTx(keyInfo);
            if (val != null) {
                ++this.operationCount;
            }
            return val;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(keyInfo, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(keyInfo, primaryBucketException);
        }
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion region, boolean allowTombstones) {
        try {
            ++this.operationCount;
            Region.Entry retVal = this.getRealDeal(keyInfo, region).getEntry(keyInfo, region, allowTombstones);
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(keyInfo, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(keyInfo, primaryBucketException);
        }
    }

    @Override
    public TXEvent getEvent() {
        this.assertBootstrapped();
        return this.getRealDeal(null, null).getEvent();
    }

    @Override
    public List getEvents() {
        this.assertBootstrapped();
        return this.getRealDeal(null, null).getEvents();
    }

    @Override
    public Collection<InternalRegion> getRegions() {
        this.assertBootstrapped();
        return this.getRealDeal(null, null).getRegions();
    }

    @Override
    public TransactionId getTransactionId() {
        return this.txId;
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        try {
            ++this.operationCount;
            this.getRealDeal(event.getKeyInfo(), event.getRegion()).invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
            this.trackBucketForTx(event.getKeyInfo());
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(event.getKeyInfo(), transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(event.getKeyInfo(), primaryBucketException);
        }
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public void setInProgress(boolean progress) {
        this.inProgress = progress;
    }

    @Override
    public boolean needsLargeModCount() {
        this.assertBootstrapped();
        return this.getRealDeal(null, null).needsLargeModCount();
    }

    @Override
    public int nextModSerialNum() {
        this.assertBootstrapped();
        return this.getRealDeal(null, null).nextModSerialNum();
    }

    @Override
    public TXRegionState readRegion(InternalRegion r) {
        this.assertBootstrapped();
        return this.getRealDeal(null, r).readRegion(r);
    }

    @Override
    public void rmRegion(LocalRegion r) {
        this.assertBootstrapped();
        this.getRealDeal(null, r).rmRegion(r);
    }

    @Override
    public void rollback() {
        try {
            this.getRealDeal(null, null).rollback();
        }
        finally {
            this.inProgress = false;
        }
    }

    @Override
    public boolean txPutEntry(EntryEventImpl event, boolean ifNew, boolean requireOldValue, boolean checkResources, Object expectedOldValue) {
        try {
            ++this.operationCount;
            boolean retVal = this.getRealDeal(event.getKeyInfo(), (LocalRegion)event.getRegion()).txPutEntry(event, ifNew, requireOldValue, checkResources, expectedOldValue);
            this.trackBucketForTx(event.getKeyInfo());
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(event.getKeyInfo(), transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(event.getKeyInfo(), primaryBucketException);
        }
    }

    @Override
    public TXEntryState txReadEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead, boolean createTxEntryIfAbsent) {
        try {
            ++this.operationCount;
            TXEntryState retVal = this.getRealDeal(keyInfo, localRegion).txReadEntry(keyInfo, localRegion, rememberRead, createTxEntryIfAbsent);
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(keyInfo, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(keyInfo, primaryBucketException);
        }
    }

    @Override
    public TXRegionState txReadRegion(InternalRegion internalRegion) {
        this.assertBootstrapped();
        return this.getRealDeal(null, internalRegion).txReadRegion(internalRegion);
    }

    @Override
    public TXRegionState txWriteRegion(InternalRegion internalRegion, KeyInfo entryKey) {
        return this.getRealDeal(entryKey, internalRegion).txWriteRegion(internalRegion, entryKey);
    }

    @Override
    public TXRegionState writeRegion(InternalRegion r) {
        this.assertBootstrapped();
        return this.getRealDeal(null, r).writeRegion(r);
    }

    private void assertBootstrapped() {
        assert (this.realDeal != null);
    }

    public void afterCompletion(int status) {
        this.assertBootstrapped();
        try {
            this.getRealDeal(null, null).afterCompletion(status);
        }
        finally {
            this.inProgress = false;
        }
    }

    public void beforeCompletion() {
        this.assertBootstrapped();
        this.getRealDeal(null, null).beforeCompletion();
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        try {
            ++this.operationCount;
            boolean retVal = this.getRealDeal(keyInfo, localRegion).containsKey(keyInfo, localRegion);
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(keyInfo, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(keyInfo, primaryBucketException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="This method unlocks and then conditionally undoes the unlock in the finally-block. Review again at later time.")
    public int entryCount(LocalRegion localRegion) {
        boolean resetTXState = this.realDeal == null;
        TXStateProxy txp = null;
        boolean txUnlocked = false;
        if (resetTXState) {
            txp = this.getTxMgr().pauseTransaction();
        } else if (this.getLock().isHeldByCurrentThread()) {
            txUnlocked = true;
            this.getLock().unlock();
        }
        try {
            if (resetTXState) {
                int n = localRegion.getSharedDataView().entryCount(localRegion);
                return n;
            }
            int n = this.getRealDeal(null, localRegion).entryCount(localRegion);
            return n;
        }
        finally {
            if (resetTXState) {
                this.getTxMgr().unpauseTransaction(txp);
            } else if (txUnlocked) {
                this.getLock().lock();
            }
        }
    }

    @Override
    public Object findObject(KeyInfo key, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        try {
            ++this.operationCount;
            Object retVal = this.getRealDeal(key, r).findObject(key, r, isCreate, generateCallbacks, value, disableCopyOnRead, preferCD, requestingClient, clientEvent, false);
            this.trackBucketForTx(key);
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(key, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(key, primaryBucketException);
        }
    }

    @Override
    public Set getAdditionalKeysForIterator(LocalRegion currRgn) {
        if (this.realDeal == null) {
            return null;
        }
        return this.getRealDeal(null, currRgn).getAdditionalKeysForIterator(currRgn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getEntryForIterator(KeyInfo key, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        boolean resetTxState = this.isTransactionInternalSuspendNeeded(currRgn);
        TXStateProxy txp = null;
        if (resetTxState) {
            txp = this.getTxMgr().pauseTransaction();
        }
        try {
            if (resetTxState) {
                Region.Entry entry = currRgn.getSharedDataView().getEntry(key, currRgn, allowTombstones);
                return entry;
            }
            Object object = this.getRealDeal(key, currRgn).getEntryForIterator(key, currRgn, rememberReads, allowTombstones);
            return object;
        }
        finally {
            if (resetTxState) {
                this.getTxMgr().unpauseTransaction(txp);
            }
        }
    }

    private boolean isTransactionInternalSuspendNeeded(LocalRegion region) {
        boolean resetTxState = this.realDeal == null && (this.isPeerAccessor(region) || this.restoreSetOperationTransactionBehavior);
        return resetTxState;
    }

    private boolean isPeerAccessor(LocalRegion region) {
        if (region.hasServerProxy()) {
            return false;
        }
        return !region.canStoreDataLocally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getKeyForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        boolean resetTxState = this.isTransactionInternalSuspendNeeded(currRgn);
        TXStateProxy txp = null;
        if (resetTxState) {
            txp = this.getTxMgr().pauseTransaction();
        }
        try {
            if (resetTxState) {
                Object object = currRgn.getSharedDataView().getKeyForIterator(keyInfo, currRgn, rememberReads, allowTombstones);
                return object;
            }
            Object object = this.getRealDeal(keyInfo, currRgn).getKeyForIterator(keyInfo, currRgn, rememberReads, allowTombstones);
            return object;
        }
        finally {
            if (resetTxState) {
                this.getTxMgr().unpauseTransaction(txp);
            }
        }
    }

    @Override
    public Object getValueInVM(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead) {
        ++this.operationCount;
        return this.getRealDeal(keyInfo, localRegion).getValueInVM(keyInfo, localRegion, rememberRead);
    }

    @Override
    public boolean isDeferredStats() {
        this.assertBootstrapped();
        return this.getRealDeal(null, null).isDeferredStats();
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        return this.putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, true, false);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwConcurrentModification) {
        try {
            ++this.operationCount;
            boolean retVal = this.getRealDeal(event.getKeyInfo(), event.getRegion()).putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
            this.trackBucketForTx(event.getKeyInfo());
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(event.getKeyInfo(), transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(event.getKeyInfo(), primaryBucketException);
        }
    }

    @Override
    public boolean isInProgressAndSameAs(TXStateInterface otherState) {
        return this.isInProgress() && otherState == this;
    }

    @Override
    public void setLocalTXState(TXStateInterface state) {
        this.realDeal = state;
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo key, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws DataLocationException {
        ++this.operationCount;
        try {
            Object retVal = this.getRealDeal(key, localRegion).getSerializedValue(localRegion, key, doNotLockEntry, requestingClient, clientEvent, returnTombstones);
            this.trackBucketForTx(key);
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(key, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(key, primaryBucketException);
        }
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        ++this.operationCount;
        TXStateInterface tx = this.getRealDeal(event.getKeyInfo(), event.getRegion());
        assert (tx instanceof TXState) : tx.getClass().getSimpleName();
        try {
            boolean retVal = tx.putEntryOnRemote(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
            this.trackBucketForTx(event.getKeyInfo());
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(event.getKeyInfo(), transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(event.getKeyInfo(), primaryBucketException);
        }
    }

    @Override
    public boolean isFireCallbacks() {
        return this.getRealDeal(null, null).isFireCallbacks();
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        ++this.operationCount;
        TXStateInterface tx = this.getRealDeal(event.getKeyInfo(), event.getRegion());
        assert (tx instanceof TXState);
        try {
            tx.destroyOnRemote(event, cacheWrite, expectedOldValue);
            this.trackBucketForTx(event.getKeyInfo());
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(event.getKeyInfo(), transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(event.getKeyInfo(), primaryBucketException);
        }
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        ++this.operationCount;
        TXStateInterface tx = this.getRealDeal(event.getKeyInfo(), event.getRegion());
        assert (tx instanceof TXState);
        try {
            tx.invalidateOnRemote(event, invokeCallbacks, forceNewEntry);
            this.trackBucketForTx(event.getKeyInfo());
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(event.getKeyInfo(), transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(event.getKeyInfo(), primaryBucketException);
        }
    }

    @Override
    public void checkSupportsRegionDestroy() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException("destroyRegion() is not supported while in a transaction");
    }

    @Override
    public void checkSupportsRegionInvalidate() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException("invalidateRegion() is not supported while in a transaction");
    }

    @Override
    public void checkSupportsRegionClear() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException("clear() is not supported while in a transaction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        boolean resetTxState = this.isTransactionInternalSuspendNeeded(localRegion);
        TXStateProxy txp = null;
        if (resetTxState) {
            txp = this.getTxMgr().pauseTransaction();
        }
        try {
            if (resetTxState) {
                Set set = localRegion.getSharedDataView().getBucketKeys(localRegion, bucketId, false);
                return set;
            }
            Set set = this.getRealDeal(null, localRegion).getBucketKeys(localRegion, bucketId, false);
            return set;
        }
        finally {
            if (resetTxState) {
                this.getTxMgr().unpauseTransaction(txp);
            }
        }
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo keyInfo, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        ++this.operationCount;
        TXStateInterface tx = this.getRealDeal(keyInfo, localRegion);
        assert (tx instanceof TXState);
        try {
            return tx.getEntryOnRemote(keyInfo, localRegion, allowTombstones);
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(keyInfo, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(keyInfo, primaryBucketException);
        }
    }

    public void forceLocalBootstrap() {
        this.getRealDeal(null, null);
    }

    @Override
    public DistributedMember getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(DistributedMember target) {
        assert (this.target == null);
        this.getRealDeal(target);
        if (this.target == null && this.isRealDealLocal()) {
            assert (target.equals(this.getCache().getDistributedSystem().getDistributedMember()));
            this.target = target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> getRegionKeysForIteration(LocalRegion currRegion) {
        if (currRegion.isUsedForPartitionedRegionBucket()) {
            return currRegion.getRegionKeysForIteration();
        }
        boolean resetTxState = this.isTransactionInternalSuspendNeeded(currRegion);
        TXStateProxy txp = null;
        if (resetTxState) {
            txp = this.getTxMgr().pauseTransaction();
        }
        try {
            if (resetTxState) {
                Collection<?> collection = currRegion.getSharedDataView().getRegionKeysForIteration(currRegion);
                return collection;
            }
            Collection collection = this.getRealDeal(null, currRegion).getRegionKeysForIteration(currRegion);
            return collection;
        }
        finally {
            if (resetTxState) {
                this.getTxMgr().unpauseTransaction(txp);
            }
        }
    }

    @Override
    public boolean isCommitOnBehalfOfRemoteStub() {
        return this.commitRequestedByOwner;
    }

    @Override
    public boolean setCommitOnBehalfOfRemoteStub(boolean requestedByOwner) {
        this.commitRequestedByOwner = requestedByOwner;
        return this.commitRequestedByOwner;
    }

    @Override
    public boolean isRealDealLocal() {
        if (this.realDeal != null) {
            return this.realDeal.isRealDealLocal();
        }
        return false;
    }

    public TXState getLocalRealDeal() {
        if (this.realDeal != null && this.realDeal.isRealDealLocal()) {
            return (TXState)this.realDeal;
        }
        return null;
    }

    public boolean hasRealDeal() {
        return this.realDeal != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TXStateProxyImpl@").append(System.identityHashCode(this)).append(" txId:").append(this.txId).append(" realDeal:").append(this.realDeal).append(" isJTA:").append(this.isJTA);
        return builder.toString();
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        if (this.realDeal == null) {
            return null;
        }
        return this.realDeal.getOriginatingMember();
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        if (this.realDeal == null) {
            return false;
        }
        return this.realDeal.isMemberIdForwardingRequired();
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        if (this.realDeal == null) {
            return null;
        }
        return this.realDeal.getCommitMessage();
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, InternalRegion reg) {
        if (putallOp.putAllData.length == 0) {
            return;
        }
        reg.getCancelCriterion().checkCancelInProgress(null);
        Object key = null;
        if (putallOp.putAllData[0] != null) {
            key = putallOp.putAllData[0].key;
        }
        KeyInfo ki = new KeyInfo(key, null, null);
        TXStateInterface tsi = this.getRealDeal(ki, reg);
        tsi.postPutAll(putallOp, successfulPuts, reg);
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, InternalRegion reg) {
        if (op.removeAllData.length == 0) {
            return;
        }
        reg.getCancelCriterion().checkCancelInProgress(null);
        Object key = null;
        if (op.removeAllData[0] != null) {
            key = op.removeAllData[0].key;
        }
        KeyInfo ki = new KeyInfo(key, null, null);
        TXStateInterface tsi = this.getRealDeal(ki, reg);
        tsi.postRemoveAll(op, successfulOps, reg);
    }

    @Override
    public boolean isJCATransaction() {
        return this.isJCATransaction;
    }

    @Override
    public void setJCATransaction() {
        this.isJCATransaction = true;
    }

    @Override
    public Region.Entry accessEntry(KeyInfo keyInfo, LocalRegion region) {
        try {
            ++this.operationCount;
            Region.Entry retVal = this.getRealDeal(keyInfo, region).accessEntry(keyInfo, region);
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionDataRebalancedException transactionDataRebalancedException) {
            throw this.handleTransactionDataRebalancedException(keyInfo, transactionDataRebalancedException);
        }
        catch (PrimaryBucketException primaryBucketException) {
            throw this.getTransactionException(keyInfo, primaryBucketException);
        }
    }

    @Override
    public void suspend() {
        if (this.realDeal != null) {
            this.getRealDeal(null, null).suspend();
        }
    }

    @Override
    public void resume() {
        if (this.realDeal != null) {
            this.getRealDeal(null, null).resume();
        }
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key, Object[] arguments) {
        if (ClientTXStateStub.transactionRecordingEnabled()) {
            this.getRealDeal(null, (LocalRegion)region.getRegion()).recordTXOperation(region, op, key, arguments);
        }
    }

    @Override
    public int operationCount() {
        return this.operationCount;
    }

    public void incOperationCount() {
        ++this.operationCount;
    }

    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
    }

    @Override
    public void close() {
        if (this.realDeal != null) {
            this.realDeal.close();
        }
    }

    @Override
    public boolean isTxState() {
        return false;
    }

    @Override
    public boolean isTxStateStub() {
        return false;
    }

    @Override
    public boolean isTxStateProxy() {
        return true;
    }

    @Override
    public boolean isDistTx() {
        return false;
    }

    @Override
    public boolean isCreatedOnDistTxCoordinator() {
        return false;
    }

    @Override
    public void updateProxyServer(InternalDistributedMember proxy) {
        if (this.realDeal != null && this.realDeal.isRealDealLocal() && this.isOnBehalfOfClient()) {
            ((TXState)this.realDeal).setProxyServer(proxy);
        }
    }

    public boolean isOverTransactionTimeoutLimit() {
        return this.getCurrentTime() - this.getLastOperationTimeFromClient() > TimeUnit.SECONDS.toMillis(this.txMgr.getTransactionTimeToLive());
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    synchronized long getLastOperationTimeFromClient() {
        return this.lastOperationTimeFromClient;
    }

    public synchronized void setLastOperationTimeFromClient(long lastOperationTimeFromClient) {
        this.lastOperationTimeFromClient = lastOperationTimeFromClient;
    }

    @Override
    public InternalDistributedMember getOnBehalfOfClientMember() {
        return this.onBehalfOfClientMember;
    }

    void setFirstOperationOnPartitionedRegion(boolean firstOperationOnPartitionedRegion) {
        this.firstOperationOnPartitionedRegion = firstOperationOnPartitionedRegion;
    }
}

