/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryExecutor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketSetHelper;
import org.apache.geode.internal.cache.EntriesSet;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.InternalRegionFunctionContext;
import org.apache.geode.internal.cache.snapshot.RegionSnapshotServiceImpl;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LocalDataSet
implements Region,
QueryExecutor {
    private static final Logger logger = LogService.getLogger();
    private final PartitionedRegion proxy;
    private final Set<Integer> buckets;
    private InternalRegionFunctionContext rfContext;

    public LocalDataSet(PartitionedRegion pr, int[] buckets) {
        this.proxy = pr;
        this.buckets = BucketSetHelper.toSet(buckets);
    }

    public LocalDataSet(PartitionedRegion pr, Set<Integer> buckets) {
        this.proxy = pr;
        this.buckets = buckets;
    }

    public Set<Region.Entry> entrySet(boolean recursive) {
        return this.proxy.entrySet(this.getBucketSet());
    }

    @Override
    public Set<Region.Entry> entrySet() {
        return this.entrySet(false);
    }

    @Override
    public Collection values() {
        this.proxy.checkReadiness();
        PartitionedRegion partitionedRegion = this.proxy;
        partitionedRegion.getClass();
        return new PartitionedRegion.ValuesSet(partitionedRegion, this.getBucketSet());
    }

    public Set keys() {
        return this.proxy.keySet(this.getBucketSet());
    }

    @Override
    public Set keySet() {
        return this.keys();
    }

    public Collection localValues() {
        return new LocalEntriesSet(LocalRegion.IteratorType.VALUES);
    }

    public Set<Region.Entry> localEntrySet() {
        return new LocalEntriesSet(LocalRegion.IteratorType.ENTRIES);
    }

    public Set<Region.Entry> localKeys() {
        return new LocalEntriesSet(LocalRegion.IteratorType.KEYS);
    }

    int getHashKey(Operation op, Object key, Object value, Object callbackArg) {
        return PartitionedRegionHelper.getHashKey(this.proxy, op, key, value, callbackArg);
    }

    private boolean isInDataSet(Object key, Object callbackArgument) {
        int bucketId = this.getHashKey(Operation.CONTAINS_KEY, key, null, callbackArgument);
        Integer bucketIdInt = bucketId;
        return this.buckets.contains(bucketIdInt);
    }

    public InternalRegionFunctionContext getFunctionContext() {
        return this.rfContext;
    }

    public void setFunctionContext(InternalRegionFunctionContext fContext) {
        this.rfContext = fContext;
    }

    public SelectResults query(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryService qs = this.getCache().getLocalQueryService();
        DefaultQuery query = (DefaultQuery)qs.newQuery("select * from " + this.getFullPath() + " this where " + queryPredicate);
        QueryExecutionContext executionContext = new QueryExecutionContext(null, this.getCache(), query);
        Object[] params = null;
        return (SelectResults)this.executeQuery(query, executionContext, params, this.getBucketSet());
    }

    @Override
    public Object selectValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults result = this.query(queryPredicate);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new FunctionDomainException(String.format("selectValue expects results of size 1, but found results of size %s", result.size()));
        }
        return result.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeQuery(DefaultQuery query, ExecutionContext executionContext, Object[] parameters, Set buckets) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean traceOn;
        long startTime = 0L;
        Object result = null;
        boolean bl = traceOn = DefaultQuery.QUERY_VERBOSE || query.isTraced();
        if (traceOn && this.proxy != null) {
            startTime = NanoTimer.getTime();
        }
        QueryObserver indexObserver = query.startTrace();
        try {
            result = this.proxy.executeQuery(query, executionContext, parameters, buckets);
            query.endTrace(indexObserver, startTime, result);
        }
        catch (Throwable throwable) {
            query.endTrace(indexObserver, startTime, result);
            throw throwable;
        }
        return result;
    }

    public PartitionedRegion getProxy() {
        return this.proxy;
    }

    public Set<Integer> getBucketSet() {
        return this.buckets;
    }

    @Override
    public void becomeLockGrantor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.proxy.close();
    }

    @Override
    public boolean containsKeyOnServer(Object key) {
        return this.proxy.containsKeyOnServer(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public void create(Object key, Object value) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.create(key, value, (Object)null);
    }

    public void create(Object key, Object value, Object callbackArgument) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.proxy.create(key, value, callbackArgument);
    }

    public Region createSubregion(String subregionName, RegionAttributes regionAttributes) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public Object destroy(Object key) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        return this.destroy(key, null);
    }

    public Object destroy(Object key, Object callbackArgument) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        return this.proxy.destroy(key, callbackArgument);
    }

    @Override
    public void destroyRegion() throws CacheWriterException, TimeoutException {
        this.destroyRegion(null);
    }

    @Override
    public void destroyRegion(Object callbackArgument) throws CacheWriterException, TimeoutException {
        this.proxy.destroyRegion(callbackArgument);
    }

    @Override
    public boolean existsValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.proxy.existsValue(queryPredicate);
    }

    @Override
    public void forceRolling() {
        this.proxy.forceRolling();
    }

    @Override
    public InternalCache getCache() {
        return this.proxy.getCache();
    }

    @Override
    public String getFullPath() {
        return this.proxy.getFullPath();
    }

    public List getInterestList() throws CacheWriterException {
        return this.proxy.getInterestList();
    }

    public List getInterestListRegex() throws CacheWriterException {
        return this.proxy.getInterestListRegex();
    }

    @Override
    public String getName() {
        return this.proxy.getName();
    }

    public Region getParentRegion() {
        return this.proxy.getParentRegion();
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStatistics getStatistics() throws StatisticsDisabledException {
        throw new UnsupportedOperationException();
    }

    public Region getSubregion(String path) {
        return this.proxy.getSubregion(path);
    }

    public RegionAttributes getAttributes() {
        return this.proxy.getAttributes();
    }

    public AttributesMutator getAttributesMutator() {
        return this.proxy.getAttributesMutator();
    }

    @Override
    public Lock getDistributedLock(Object key) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object key) throws TimeoutException, EntryNotFoundException {
        this.invalidate(key, null);
    }

    @Override
    public void invalidate(Object key, Object callbackArgument) throws TimeoutException, EntryNotFoundException {
        this.proxy.invalidate(key, callbackArgument);
    }

    @Override
    public void invalidateRegion() throws TimeoutException {
        this.invalidateRegion(null);
    }

    @Override
    public void invalidateRegion(Object callbackArgument) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDestroyed() {
        return this.proxy.isDestroyed();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object getUserAttribute() {
        return this.proxy.getUserAttribute();
    }

    public int[] getDiskDirSizes() {
        return this.proxy.getDiskDirSizes();
    }

    public Set subregions(boolean recursive) {
        return this.proxy.subregions(recursive);
    }

    public void unregisterInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeToDisk() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUserAttribute(Object value) {
        this.proxy.setUserAttribute(value);
    }

    @Override
    public Object remove(Object key) {
        return this.proxy.remove(key);
    }

    public void registerInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public Set keySetOnServer() {
        return this.proxy.keySetOnServer();
    }

    @Override
    public int sizeOnServer() {
        return this.proxy.sizeOnServer();
    }

    @Override
    public boolean isEmptyOnServer() {
        return this.proxy.isEmptyOnServer();
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public Map getAll(Collection keys) {
        return this.getAll(keys, (Object)null);
    }

    public Map getAll(Collection keys, Object callback) {
        HashMap result = new HashMap();
        for (Object key : keys) {
            try {
                result.put(key, this.get(key, callback));
            }
            catch (Exception e) {
                logger.warn(String.format("The following exception occurred attempting to get key=%s", key), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void localClear() {
        this.proxy.localClear();
    }

    @Override
    public void localDestroyRegion() {
        this.localDestroyRegion(null);
    }

    @Override
    public void localDestroyRegion(Object callbackArgument) {
        this.proxy.localDestroyRegion(callbackArgument);
    }

    @Override
    public void localInvalidateRegion() {
        this.localInvalidateRegion(null);
    }

    @Override
    public void localInvalidateRegion(Object callbackArgument) {
        this.proxy.localInvalidateRegion(callbackArgument);
    }

    @Override
    public void localDestroy(Object key) throws EntryNotFoundException {
        this.localDestroy(key, null);
    }

    @Override
    public void localDestroy(Object key, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localInvalidate(Object key) throws EntryNotFoundException {
        this.localInvalidate(key, null);
    }

    @Override
    public void localInvalidate(Object key, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(Object key, Object value) throws TimeoutException, CacheWriterException {
        return this.put(key, value, (Object)null);
    }

    public Object put(Object key, Object value, Object callbackArgument) throws TimeoutException, CacheWriterException {
        return this.proxy.put(key, value, callbackArgument);
    }

    @Override
    public void putAll(Map map) {
        this.proxy.putAll(map);
    }

    public void putAll(Map map, Object callbackArg) {
        this.proxy.putAll(map, callbackArg);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isInDataSet(key, null)) {
            return this.proxy.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValueForKey(Object key) {
        if (this.isInDataSet(key, null)) {
            return this.proxy.containsValueForKey(key);
        }
        return false;
    }

    public Region.Entry getEntry(Object key) {
        if (this.isInDataSet(key, null)) {
            return this.proxy.getEntry(key);
        }
        return null;
    }

    @Override
    public int size() {
        return this.proxy.entryCount(this.getBucketSet());
    }

    @Override
    public Object get(Object key) throws CacheLoaderException, TimeoutException {
        return this.get(key, null);
    }

    public Object get(Object key, Object aCallbackArgument) throws TimeoutException, CacheLoaderException {
        if (this.isInDataSet(key, aCallbackArgument)) {
            return this.proxy.get(key, aCallbackArgument);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[path='").append(this.getFullPath());
        sb.append("';scope=").append(this.proxy.getScope());
        sb.append("';dataPolicy=").append(this.proxy.getDataPolicy());
        sb.append(" ;bucketIds=").append(this.buckets);
        return sb.append(']').toString();
    }

    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
    }

    public void registerInterest(Object key, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.proxy.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.proxy.remove(key, value);
    }

    @Override
    public Object replace(Object key, Object value) {
        return this.proxy.replace(key, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.proxy.replace(key, oldValue, newValue);
    }

    @Override
    public RegionService getRegionService() {
        return this.getCache();
    }

    public RegionSnapshotService<?, ?> getSnapshotService() {
        return new RegionSnapshotServiceImpl(this);
    }

    public void removeAll(Collection keys) {
        this.proxy.removeAll(keys);
    }

    public void removeAll(Collection keys, Object aCallbackArgument) {
        this.proxy.removeAll(keys, aCallbackArgument);
    }

    protected class LocalEntriesSet
    extends EntriesSet {
        public LocalEntriesSet(LocalRegion.IteratorType type) {
            super(LocalDataSet.this.proxy, false, type, false);
        }

        public LocalEntriesSet() {
            this(LocalRegion.IteratorType.ENTRIES);
        }

        @Override
        public Iterator iterator() {
            return new LocalEntriesSetIterator();
        }

        @Override
        public int size() {
            int size = 0;
            for (Integer bId : LocalDataSet.this.buckets) {
                BucketRegion br = LocalDataSet.this.proxy.getDataStore().getLocalBucketById(bId);
                size += br.size();
            }
            return size;
        }

        protected class LocalEntriesSetIterator
        implements Iterator<Object> {
            Iterator curBucketIter = null;
            Integer curBucketId;
            List<Integer> localBuckets;
            int index;
            int localBucketsSize;
            boolean hasNext;
            Object next;

            LocalEntriesSetIterator() {
                this.localBuckets = new ArrayList<Integer>(LocalDataSet.this.buckets);
                this.index = 0;
                this.localBucketsSize = this.localBuckets.size();
                this.hasNext = false;
                this.next = null;
                this.next = this.moveNext();
            }

            @Override
            public Object next() {
                Object result = this.next;
                if (result != null) {
                    this.next = this.moveNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private Object moveNext() {
                LocalDataSet.this.proxy.checkReadiness();
                try {
                    while (true) {
                        if (this.curBucketIter == null || !(this.hasNext = this.curBucketIter.hasNext())) {
                            if (this.index >= this.localBucketsSize) {
                                return null;
                            }
                            this.curBucketId = this.localBuckets.get(this.index++);
                            BucketRegion br = LocalDataSet.this.proxy.getDataStore().getLocalBucketById(this.curBucketId);
                            if (br == null) {
                                throw new BucketMovedException("The Bucket region with id " + this.curBucketId + " is moved/destroyed.");
                            }
                            br.waitForData();
                            this.curBucketIter = br.entrySet().iterator();
                            continue;
                        }
                        if (!this.hasNext) return this.next;
                        Map.Entry e = (Map.Entry)this.curBucketIter.next();
                        try {
                            if (LocalEntriesSet.this.iterType == LocalRegion.IteratorType.VALUES) {
                                this.next = LocalEntriesSet.this.isKeepSerialized() ? ((NonTXEntry)e).getRawValue() : (LocalEntriesSet.this.ignoreCopyOnReadForQuery ? ((NonTXEntry)e).getValue(true) : e.getValue());
                                if (this.next == null) continue;
                                if (!Token.isInvalidOrRemoved(this.next)) return this.next;
                                continue;
                            }
                            if (LocalEntriesSet.this.iterType == LocalRegion.IteratorType.KEYS) {
                                this.next = e.getKey();
                                return this.next;
                            }
                            if (((NonTXEntry)e).isDestroyed()) {
                                throw new EntryDestroyedException();
                            }
                            this.next = e;
                            return this.next;
                        }
                        catch (EntryDestroyedException ede) {
                            continue;
                        }
                        break;
                    }
                }
                catch (RegionDestroyedException rde) {
                    throw new BucketMovedException("The Bucket region with id " + this.curBucketId + " is moved/destroyed.");
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This iterator does not support modification");
            }
        }
    }
}

