/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.locks.DLockToken;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.DLockInfo;

public class RemoteDLockInfo
implements DLockInfo,
DataSerializable {
    private static final long serialVersionUID = 3350265007784675017L;
    private String serviceName;
    private String threadId;
    private String lockName;
    private boolean acquired;
    private int recursion;
    private InternalDistributedMember owner;
    private long startTime;
    private long leaseExpiration;
    private transient Date expirationDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDLockInfo(String serviceName, String name, DLockToken lock, InternalDistributedMember localId) {
        this.serviceName = serviceName;
        this.lockName = name;
        DLockToken dLockToken = lock;
        synchronized (dLockToken) {
            this.threadId = lock.getThreadName();
            boolean bl = this.acquired = this.threadId != null;
            if (this.acquired) {
                this.owner = localId;
            }
            this.recursion = lock.getRecursion();
            this.leaseExpiration = lock.getLeaseExpireTime();
        }
    }

    public RemoteDLockInfo() {
    }

    @Override
    public String getService() {
        return this.serviceName;
    }

    @Override
    public String getThreadId() {
        return this.threadId;
    }

    @Override
    public String getLockName() {
        return this.lockName;
    }

    @Override
    public boolean isAcquired() {
        return this.acquired;
    }

    @Override
    public int getRecursionCount() {
        return this.recursion;
    }

    @Override
    public InternalDistributedMember getOwner() {
        return this.owner;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized Date getLeaseExpireTime() {
        if (this.expirationDate == null && this.leaseExpiration > -1L) {
            this.expirationDate = new Date(this.leaseExpiration);
        }
        return this.expirationDate;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.serviceName, out);
        DataSerializer.writeString(this.threadId, out);
        DataSerializer.writeString(this.lockName, out);
        out.writeBoolean(this.acquired);
        out.writeInt(this.recursion);
        DataSerializer.writeObject(this.owner, out);
        out.writeLong(this.startTime);
        out.writeLong(this.leaseExpiration);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.serviceName = DataSerializer.readString(in);
        this.threadId = DataSerializer.readString(in);
        this.lockName = DataSerializer.readString(in);
        this.acquired = in.readBoolean();
        this.recursion = in.readInt();
        this.owner = (InternalDistributedMember)DataSerializer.readObject(in);
        this.startTime = in.readLong();
        this.leaseExpiration = in.readLong();
    }
}

