/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.BridgeServerResponse;
import org.apache.geode.internal.admin.remote.RemoteBridgeServer;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class BridgeServerRequest
extends AdminRequest {
    static final int ADD_OPERATION = 10;
    static final int INFO_OPERATION = 11;
    static final int START_OPERATION = 12;
    static final int STOP_OPERATION = 13;
    private int cacheId;
    private int operation;
    private RemoteBridgeServer bridgeInfo;
    private int bridgeId;

    public static BridgeServerRequest createForAdd(CacheInfo cache) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 10;
        request.friendlyName = "Add cache server";
        request.bridgeInfo = null;
        return request;
    }

    public static BridgeServerRequest createForInfo(CacheInfo cache, int id) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 11;
        request.friendlyName = String.format("Get info about cache server %s", id);
        request.bridgeId = id;
        request.bridgeInfo = null;
        return request;
    }

    public static BridgeServerRequest createForStart(CacheInfo cache, RemoteBridgeServer bridge) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 12;
        request.friendlyName = String.format("Start cache server %s", bridge);
        request.bridgeInfo = bridge;
        return request;
    }

    public static BridgeServerRequest createForStop(CacheInfo cache, RemoteBridgeServer bridge) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 13;
        request.friendlyName = String.format("Stop cache server %s", bridge);
        request.bridgeInfo = bridge;
        return request;
    }

    private static String getOperationDescription(int op) {
        switch (op) {
            case 10: {
                return "Add cache server";
            }
            case 11: {
                return "Get info about cache server";
            }
        }
        return String.format("Unknown operation %s", op);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return BridgeServerResponse.create(dm, this);
    }

    int getCacheId() {
        return this.cacheId;
    }

    int getOperation() {
        return this.operation;
    }

    int getBridgeId() {
        return this.bridgeId;
    }

    RemoteBridgeServer getBridgeInfo() {
        return this.bridgeInfo;
    }

    public int getDSFID() {
        return 1010;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.cacheId);
        out.writeInt(this.operation);
        DataSerializer.writeObject(this.bridgeInfo, out);
        out.writeInt(this.bridgeId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.cacheId = in.readInt();
        this.operation = in.readInt();
        this.bridgeInfo = (RemoteBridgeServer)DataSerializer.readObject(in);
        this.bridgeId = in.readInt();
    }

    @Override
    public String toString() {
        return "BridgeServerRequest: " + BridgeServerRequest.getOperationDescription(this.operation);
    }
}

