/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.geode.distributed.internal.membership.api.CacheOperationMessageMarker;
import org.apache.geode.distributed.internal.membership.api.MemberDisconnectedException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberShunnedException;
import org.apache.geode.distributed.internal.membership.api.MemberStartupException;
import org.apache.geode.distributed.internal.membership.api.MembershipClosedException;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipStatistics;
import org.apache.geode.distributed.internal.membership.gms.GMSMemberData;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.HealthMonitor;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Manager;
import org.apache.geode.distributed.internal.membership.gms.interfaces.MessageHandler;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Messenger;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinResponseMessage;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSEncrypt;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSPingPonger;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSQuorumChecker;
import org.apache.geode.distributed.internal.membership.gms.messenger.JGAddress;
import org.apache.geode.distributed.internal.membership.gms.messenger.MembershipInformationImpl;
import org.apache.geode.distributed.internal.membership.gms.messenger.StatRecorder;
import org.apache.geode.distributed.internal.membership.gms.messenger.Transport;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.serialization.BufferDataOutputStream;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataInputStream;
import org.apache.geode.logging.internal.OSProcess;
import org.apache.logging.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.NakAckHeader2;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Digest;
import org.jgroups.util.StackType;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class JGroupsMessenger<ID extends MemberIdentifier>
implements Messenger<ID> {
    private static final Logger logger = Services.getLogger();
    private static final String DEFAULT_JGROUPS_TCP_CONFIG = "org/apache/geode/distributed/internal/membership/gms/messenger/jgroups-config.xml";
    private static final String JGROUPS_MCAST_CONFIG_FILE_NAME = "org/apache/geode/distributed/internal/membership/gms/messenger/jgroups-mcast.xml";
    private static final short JGROUPS_TYPE_JGADDRESS = 2000;
    private static final short JGROUPS_PROTOCOL_TRANSPORT = 1000;
    protected String jgStackConfig;
    JChannel myChannel;
    ID localAddress;
    JGAddress jgAddress;
    private Services<ID> services;
    private final Map<Class<?>, MessageHandler<?>> handlers = new ConcurrentHashMap();
    private volatile GMSMembershipView<ID> view;
    protected final GMSPingPonger pingPonger = new GMSPingPonger();
    protected final AtomicLong pongsReceived = new AtomicLong(0L);
    protected final Map<ID, MessageTracker> scheduledMcastSeqnos = new HashMap<ID, MessageTracker>();
    protected short nackack2HeaderId;
    private final Set<Address> addressesWithIoExceptionsProcessed = Collections.synchronizedSet(new HashSet());
    private GMSEncrypt<ID> encrypt;
    private Queue<Message> queuedMessagesFromReconnect;
    private JGroupsReceiver jgroupsReceiver;
    private AtomicInteger requestId = new AtomicInteger(new Random().nextInt());
    private HashMap<Integer, ID> requestIdVsRecipients = new HashMap();

    public static void setChannelReceiver(JChannel channel, Receiver r) {
        try {
            Field receiver = Channel.class.getDeclaredField("receiver");
            receiver.setAccessible(true);
            receiver.set(channel, r);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("unable to establish a JGroups receiver", e);
        }
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void init(Services<ID> s) throws MembershipConfigurationException {
        String properties;
        this.services = s;
        MembershipConfig config = this.services.getConfig();
        boolean enableNetworkPartitionDetection = config.isNetworkPartitionDetectionEnabled();
        System.setProperty("jgroups.resolve_dns", String.valueOf(!enableNetworkPartitionDetection));
        InputStream is = null;
        String r = config.isMulticastEnabled() ? JGROUPS_MCAST_CONFIG_FILE_NAME : DEFAULT_JGROUPS_TCP_CONFIG;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            is = contextClassLoader.getResourceAsStream(r);
        }
        if (is == null) {
            is = this.getClass().getResourceAsStream(r);
        }
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(r);
        }
        if (is == null) {
            throw new MembershipConfigurationException(String.format("Cannot find %s", r));
        }
        try {
            String input;
            StringBuilder sb = new StringBuilder(3000);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
            while ((input = br.readLine()) != null) {
                sb.append(input);
            }
            br.close();
            properties = sb.toString();
        }
        catch (Exception ex) {
            throw new MembershipConfigurationException("An Exception was thrown while reading JGroups config.", ex);
        }
        if (properties.startsWith("<!--")) {
            int commentEnd = properties.indexOf("-->");
            properties = properties.substring(commentEnd + 3);
        }
        if (config.isMulticastEnabled()) {
            properties = GMSUtil.replaceStrings(properties, "MCAST_PORT", String.valueOf(config.getMcastPort()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_ADDRESS", config.getMcastAddress());
            properties = GMSUtil.replaceStrings(properties, "MCAST_TTL", String.valueOf(config.getMcastTtl()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_SEND_BUFFER_SIZE", String.valueOf(config.getMcastSendBufferSize()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_RECV_BUFFER_SIZE", String.valueOf(config.getMcastRecvBufferSize()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_RETRANSMIT_INTERVAL", "" + Integer.getInteger("gemfire.mcast-retransmit-interval", 500));
            properties = GMSUtil.replaceStrings(properties, "RETRANSMIT_LIMIT", String.valueOf(config.getUdpFragmentSize() - 256));
        }
        properties = config.isMulticastEnabled() || config.getDisableTcp() || config.getUdpRecvBufferSize() != 0x100000 ? GMSUtil.replaceStrings(properties, "UDP_RECV_BUFFER_SIZE", "" + config.getUdpRecvBufferSize()) : GMSUtil.replaceStrings(properties, "UDP_RECV_BUFFER_SIZE", "65535");
        properties = GMSUtil.replaceStrings(properties, "UDP_SEND_BUFFER_SIZE", "" + config.getUdpSendBufferSize());
        String str = config.getBindAddress();
        if (str == null || str.length() == 0) {
            try {
                str = LocalHostUtil.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new MembershipConfigurationException(e.getMessage(), e);
            }
        }
        properties = GMSUtil.replaceStrings(properties, "BIND_ADDR_SETTING", "bind_addr=\"" + str + "\"");
        int port = Integer.getInteger("gemfire.jg-bind-port", 0);
        if (port != 0) {
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE_START", "" + port);
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE", "0");
        } else {
            int[] ports = config.getMembershipPortRange();
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE_START", "" + ports[0]);
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE", "" + (ports[1] - ports[0]));
        }
        properties = GMSUtil.replaceStrings(properties, "UDP_FRAGMENT_SIZE", "" + config.getUdpFragmentSize());
        properties = GMSUtil.replaceStrings(properties, "FC_MAX_CREDITS", "" + config.getMcastByteAllowance());
        properties = GMSUtil.replaceStrings(properties, "FC_THRESHOLD", "" + config.getMcastRechargeThreshold());
        this.jgStackConfig = properties = GMSUtil.replaceStrings(properties, "FC_MAX_BLOCK", "" + config.getMcastRechargeBlockMs());
        if (!config.getSecurityUDPDHAlgo().isEmpty()) {
            try {
                this.encrypt = new GMSEncrypt<ID>(this.services, config.getSecurityUDPDHAlgo());
                logger.info("Initializing GMSEncrypt ");
            }
            catch (Exception e) {
                throw new MembershipConfigurationException("problem initializing encryption protocol", e);
            }
        }
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void start() throws MemberStartupException {
        boolean reconnecting;
        long start;
        block11: {
            String properties = this.jgStackConfig;
            start = System.currentTimeMillis();
            reconnecting = false;
            try {
                Object oldDSMembershipInfo = this.services.getConfig().getOldDSMembershipInfo();
                if (oldDSMembershipInfo != null) {
                    logger.debug("Reusing JGroups channel from previous system", (Object)properties);
                    MembershipInformationImpl oldInfo = (MembershipInformationImpl)oldDSMembershipInfo;
                    this.myChannel = oldInfo.getChannel();
                    this.queuedMessagesFromReconnect = oldInfo.getQueuedMessages();
                    ViewId vid = new ViewId(new JGAddress(), 0L);
                    ArrayList<Address> members = new ArrayList<Address>();
                    members.add(new UUID(0L, 0L));
                    View jgv = new View(vid, members);
                    this.myChannel.down(new Event(6, jgv));
                    try {
                        Method setAddressMethod = JChannel.class.getDeclaredMethod("setAddress", new Class[0]);
                        setAddressMethod.setAccessible(true);
                        setAddressMethod.invoke((Object)this.myChannel, new Object[0]);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        logger.warn("Unable to establish a new JGroups address.  My address will be exactly the same as last time. Exception={}", (Object)e.getMessage());
                    }
                    reconnecting = true;
                    break block11;
                }
                logger.debug("JGroups configuration: {}", (Object)properties);
                this.checkForIPv6();
                ByteArrayInputStream is = new ByteArrayInputStream(properties.getBytes("UTF-8"));
                this.myChannel = new JChannel(is);
            }
            catch (Exception e) {
                throw new MembershipConfigurationException("unable to create jgroups channel", e);
            }
        }
        StatRecorder sr = (StatRecorder)this.myChannel.getProtocolStack().findProtocol((Class<?>)StatRecorder.class);
        if (sr != null) {
            sr.setServices(this.services);
        }
        Transport transport = (Transport)this.myChannel.getProtocolStack().getTransport();
        transport.setMessenger(this);
        this.nackack2HeaderId = ClassConfigurator.getProtocolId(NAKACK2.class);
        try {
            this.jgroupsReceiver = new JGroupsReceiver();
            try {
                JGroupsMessenger.setChannelReceiver(this.myChannel, this.jgroupsReceiver);
            }
            catch (IllegalStateException e) {
                throw new MemberStartupException("problem initializing JGroups", e);
            }
            if (!reconnecting) {
                this.myChannel.connect("AG");
            }
        }
        catch (Exception e) {
            this.myChannel.close();
            throw new MemberStartupException("unable to create jgroups channel", e);
        }
        this.establishLocalAddress();
        logger.info("JGroups channel {} (took {}ms)", (Object)(reconnecting ? "reinitialized" : "created"), (Object)(System.currentTimeMillis() - start));
    }

    private void checkForIPv6() throws Exception {
        boolean preferIpV6Addr = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (!preferIpV6Addr) {
            logger.debug("forcing JGroups to think IPv4 is being used so it will choose an IPv4 address");
            Field m = Util.class.getDeclaredField("ip_stack_type");
            m.setAccessible(true);
            m.set(null, (Object)StackType.IPv4);
        }
    }

    @Override
    public void started() throws MemberStartupException {
        if (this.queuedMessagesFromReconnect != null && !this.services.getConfig().isUDPSecurityEnabled()) {
            logger.info("Delivering {} messages queued by quorum checker", (Object)this.queuedMessagesFromReconnect.size());
            for (Message message : this.queuedMessagesFromReconnect) {
                this.jgroupsReceiver.receive(message, true);
            }
            this.queuedMessagesFromReconnect.clear();
            this.queuedMessagesFromReconnect = null;
        }
    }

    @Override
    public void stop() {
        if (!(this.myChannel == null || this.services.isShutdownDueToForcedDisconnect() && this.services.isAutoReconnectEnabled() || this.services.getManager().isReconnectingDS())) {
            this.myChannel.close();
        }
    }

    @Override
    public void stopped() {
    }

    @Override
    public void memberSuspected(ID initiator, ID suspect, String reason) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installView(GMSMembershipView<ID> v) {
        this.view = v;
        if (this.jgAddress.getVmViewId() < 0) {
            this.jgAddress.setVmViewId(this.localAddress.getVmViewId());
        }
        List mbrs = v.getMembers().stream().map(JGAddress::new).collect(Collectors.toList());
        ViewId vid = new ViewId(new JGAddress((MemberIdentifier)v.getCoordinator()), v.getViewId());
        View jgv = new View(vid, new ArrayList<Address>(mbrs));
        logger.trace("installing view into JGroups stack: {}", (Object)jgv);
        this.myChannel.down(new Event(6, jgv));
        this.addressesWithIoExceptionsProcessed.clear();
        if (this.encrypt != null) {
            this.encrypt.installView(v);
        }
        Map<ID, MessageTracker> map = this.scheduledMcastSeqnos;
        synchronized (map) {
            for (MemberIdentifier mbr : v.getCrashedMembers()) {
                this.scheduledMcastSeqnos.remove(mbr);
            }
            for (MemberIdentifier mbr : v.getShutdownMembers()) {
                this.scheduledMcastSeqnos.remove(mbr);
            }
        }
    }

    public void handleJGroupsIOException(IOException e, Address dest) {
        if (this.services.getManager().shutdownInProgress()) {
            return;
        }
        GMSMembershipView<ID> v = this.view;
        JGAddress jgMbr = (JGAddress)dest;
        if (jgMbr != null && v != null) {
            List<ID> members = v.getMembers();
            MemberIdentifier recipient = null;
            for (MemberIdentifier gmsMbr : members) {
                if (jgMbr.getUUIDLsbs() != gmsMbr.getUuidLeastSignificantBits() || jgMbr.getUUIDMsbs() != gmsMbr.getUuidMostSignificantBits() || jgMbr.getVmViewId() != gmsMbr.getVmViewId()) continue;
                recipient = gmsMbr;
                break;
            }
            if (recipient != null) {
                if (!this.addressesWithIoExceptionsProcessed.contains(dest)) {
                    logger.warn("Unable to send message to " + recipient, (Throwable)e);
                    this.addressesWithIoExceptionsProcessed.add(dest);
                }
                this.services.getHealthMonitor().checkIfAvailable(recipient, "Unable to send messages to this member via JGroups", true);
            }
        }
    }

    private void establishLocalAddress() throws MemberStartupException {
        UUID logicalAddress = (UUID)this.myChannel.getAddress();
        logicalAddress = logicalAddress.copy();
        IpAddress ipaddr = (IpAddress)this.myChannel.down(new Event(87));
        if (ipaddr != null) {
            this.jgAddress = new JGAddress(logicalAddress, ipaddr);
        } else {
            UDP udp = (UDP)this.myChannel.getProtocolStack().getTransport();
            try {
                Method getAddress = UDP.class.getDeclaredMethod("getPhysicalAddress", new Class[0]);
                getAddress.setAccessible(true);
                ipaddr = (IpAddress)getAddress.invoke((Object)udp, new Object[0]);
                this.jgAddress = new JGAddress(logicalAddress, ipaddr);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new MemberStartupException("Unable to configure JGroups channel for membership communications", e);
            }
        }
        this.myChannel.down(new Event(8, this.jgAddress));
        MembershipConfig config = this.services.getConfig();
        boolean isLocator = config.getVmKind() == 11 || !config.getStartLocator().isEmpty();
        String hostname = !config.isNetworkPartitionDetectionEnabled() ? this.jgAddress.getInetAddress().getHostName() : this.jgAddress.getInetAddress().getHostAddress();
        GMSMemberData gmsMember = new GMSMemberData(this.jgAddress.getInetAddress(), hostname, this.jgAddress.getPort(), OSProcess.getId(), (byte)this.services.getConfig().getVmKind(), -1, -1, config.getName(), GMSUtil.parseGroups(config.getRoles(), config.getGroups()), config.getDurableClientId(), config.getDurableClientTimeout(), config.isNetworkPartitionDetectionEnabled(), isLocator, Version.getCurrentVersion().ordinal(), this.jgAddress.getUUIDMsbs(), this.jgAddress.getUUIDLsbs(), (byte)(this.services.getConfig().getMemberWeight() & 0xFF), false, null);
        this.localAddress = this.services.getMemberFactory().create(gmsMember);
        logger.info("Established local address {}", this.localAddress);
        this.services.setLocalAddress(this.localAddress);
    }

    @Override
    public void beSick() {
    }

    @Override
    public void playDead() {
    }

    @Override
    public void beHealthy() {
    }

    @Override
    public <T extends org.apache.geode.distributed.internal.membership.api.Message<ID>> void addHandler(Class<T> c, MessageHandler<T> h) {
        this.handlers.put(c, h);
    }

    @Override
    public boolean testMulticast(long timeout) throws InterruptedException {
        long pongsSnapshot = this.pongsReceived.longValue();
        JGAddress dest = null;
        try {
            this.pingPonger.sendPingMessage(this.myChannel, this.jgAddress, dest);
        }
        catch (Exception e) {
            logger.warn("unable to send multicast message: {}", this.jgAddress == null ? "multicast recipients" : this.jgAddress, (Object)e.getMessage());
            return false;
        }
        long giveupTime = System.currentTimeMillis() + timeout;
        while (this.pongsReceived.longValue() == pongsSnapshot && System.currentTimeMillis() < giveupTime) {
            Thread.sleep(100L);
        }
        return this.pongsReceived.longValue() > pongsSnapshot;
    }

    @Override
    public void getMessageState(ID target, Map<String, Long> state, boolean includeMulticast) {
        NAKACK2 nakack;
        if (includeMulticast && (nakack = (NAKACK2)this.myChannel.getProtocolStack().findProtocol("NAKACK2")) != null) {
            long seqno = nakack.getCurrentSeqno();
            state.put("JGroups.mcastState", seqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForMessageState(ID sender, Map<String, Long> state) throws InterruptedException, TimeoutException {
        Long seqno = state.get("JGroups.mcastState");
        if (seqno == null) {
            return;
        }
        long timeout = this.services.getConfig().getAckWaitThreshold() * 1000L;
        long startTime = System.currentTimeMillis();
        long warnTime = startTime + timeout;
        long quitTime = warnTime + timeout - 1000L;
        boolean warned = false;
        while (true) {
            String received = "none";
            long highSeqno = 0L;
            Map<ID, MessageTracker> map = this.scheduledMcastSeqnos;
            synchronized (map) {
                MessageTracker tracker = this.scheduledMcastSeqnos.get(sender);
                if (tracker == null) {
                    break;
                }
                highSeqno = tracker.get();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("waiting for multicast messages from {}.  Current seqno={} and expected seqno={}", sender, (Object)highSeqno, (Object)seqno);
            }
            if (highSeqno >= seqno) break;
            long now = System.currentTimeMillis();
            if (!warned && now >= warnTime) {
                warned = true;
                received = String.valueOf(highSeqno);
                logger.warn("{} seconds have elapsed while waiting for multicast messages from {}.  Received {} but expecting at least {}.", (Object)Long.toString((warnTime - startTime) / 1000L), sender, (Object)received, (Object)seqno);
            }
            if (now >= quitTime) {
                throw new TimeoutException("Multicast operations from " + sender + " did not distribute within " + (now - startTime) + " milliseconds");
            }
            Thread.sleep(50L);
        }
    }

    @Override
    public Set<ID> sendUnreliably(org.apache.geode.distributed.internal.membership.api.Message<ID> msg) {
        return this.send(msg, false);
    }

    @Override
    public Set<ID> send(org.apache.geode.distributed.internal.membership.api.Message<ID> msg) {
        return this.send(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ID> send(org.apache.geode.distributed.internal.membership.api.Message<ID> msg, boolean reliably) {
        LinkedList<ID> calculatedMembers;
        int calculatedLen;
        MembershipStatistics theStats = this.services.getStatistics();
        GMSMembershipView<ID> oldView = this.view;
        if (!this.myChannel.isConnected()) {
            logger.info("JGroupsMessenger channel is closed - messaging is not possible");
            throw new MembershipClosedException("Distributed System is shutting down");
        }
        this.filterOutgoingMessage(msg);
        List<ID> destinations = msg.getRecipients();
        boolean allDestinations = msg.forAll();
        boolean useMcast = false;
        if (this.services.getConfig().isMulticastEnabled() && (msg.getMulticast() || allDestinations)) {
            useMcast = this.services.getManager().isMulticastAllowed();
        }
        if (logger.isDebugEnabled() && reliably) {
            String recips = useMcast ? "multicast" : destinations.toString();
            logger.debug("sending via JGroups: [{}] recipients: {}", msg, (Object)recips);
        }
        JGAddress local = this.jgAddress;
        HashSet<MemberIdentifier> failedRecipients = new HashSet<MemberIdentifier>();
        if (useMcast) {
            Message jmsg;
            long startSer = theStats.startMsgSerialization();
            try {
                jmsg = this.createJGMessage(msg, local, null, Version.getCurrentVersion().ordinal());
            }
            catch (IOException e) {
                HashSet<ID> hashSet = new HashSet<ID>(msg.getRecipients());
                return hashSet;
            }
            finally {
                theStats.endMsgSerialization(startSer);
            }
            try {
                jmsg.setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
                if (!reliably) {
                    jmsg.setFlag(Message.Flag.NO_RELIABILITY);
                }
                theStats.incSentBytes(jmsg.getLength());
                logger.trace("Sending JGroups message: {}", (Object)jmsg);
                this.myChannel.send(jmsg);
            }
            catch (Exception e) {
                logger.debug("caught unexpected exception", (Throwable)e);
                Throwable cause = e.getCause();
                Exception problem = cause instanceof MemberDisconnectedException ? (Exception)cause : e;
                if (this.services.getShutdownCause() != null) {
                    Exception shutdownCause = this.services.getShutdownCause();
                    if (shutdownCause instanceof MemberDisconnectedException) {
                        problem = shutdownCause;
                    } else {
                        Throwable ne = problem;
                        while (ne.getCause() != null) {
                            ne = ne.getCause();
                        }
                        ne.initCause(this.services.getShutdownCause());
                    }
                }
                String channelClosed = "Channel closed";
                throw new MembershipClosedException("Channel closed", problem);
            }
        }
        int len = destinations.size();
        if (len == 1 && destinations.get(0) == AbstractGMSMessage.ALL_RECIPIENTS) {
            GMSMembershipView<ID> v = this.services.getJoinLeave().getView();
            calculatedLen = v.size();
            calculatedMembers = new LinkedList();
            for (int i = 0; i < calculatedLen; ++i) {
                ID m = v.get(i);
                calculatedMembers.add(m);
            }
        } else {
            calculatedLen = len;
            calculatedMembers = new LinkedList<ID>();
            for (int i = 0; i < calculatedLen; ++i) {
                calculatedMembers.add(destinations.get(i));
            }
        }
        Int2ObjectOpenHashMap messages = new Int2ObjectOpenHashMap();
        long startSer = theStats.startMsgSerialization();
        boolean firstMessage = true;
        for (MemberIdentifier mbr : calculatedMembers) {
            Message jmsg;
            short version = mbr.getVersionOrdinal();
            if (messages.containsKey((int)version)) continue;
            try {
                jmsg = this.createJGMessage(msg, local, mbr, version);
                messages.put((int)version, (Object)jmsg);
            }
            catch (IOException e) {
                failedRecipients.add(mbr);
                continue;
            }
            if (!firstMessage) continue;
            theStats.incSentBytes(jmsg.getLength());
            firstMessage = false;
        }
        theStats.endMsgSerialization(startSer);
        Collections.shuffle(calculatedMembers);
        int i = 0;
        for (MemberIdentifier mbr : calculatedMembers) {
            JGAddress to = new JGAddress(mbr);
            short version = mbr.getVersionOrdinal();
            Message jmsg = (Message)messages.get((int)version);
            if (jmsg == null) continue;
            Exception problem = null;
            try {
                Message tmp;
                Message message = tmp = i < calculatedLen - 1 ? jmsg.copy(true) : jmsg;
                if (!reliably) {
                    jmsg.setFlag(Message.Flag.NO_RELIABILITY);
                }
                tmp.setDest(to);
                tmp.setSrc(this.jgAddress);
                logger.trace("Unicasting to {}", (Object)to);
                this.myChannel.send(tmp);
            }
            catch (Exception e) {
                problem = e;
            }
            if (problem == null) continue;
            Exception cause = this.services.getShutdownCause();
            if (cause != null) {
                if (cause instanceof MemberDisconnectedException) {
                    problem = cause;
                } else {
                    Throwable ne = problem;
                    while (ne.getCause() != null) {
                        ne = ne.getCause();
                    }
                    ne.initCause(cause);
                }
            }
            String channelClosed = "Channel closed";
            throw new MembershipClosedException("Channel closed", problem);
        }
        if (failedRecipients.isEmpty() && msg.forAll()) {
            return Collections.emptySet();
        }
        GMSMembershipView<MemberIdentifier> newView = this.view;
        if (newView != null && newView != oldView) {
            for (MemberIdentifier d : destinations) {
                if (newView.contains(d)) continue;
                logger.debug("messenger: member has left the view: {}  view is now {}", (Object)d, newView);
                failedRecipients.add(d);
            }
        }
        return failedRecipients;
    }

    Message createJGMessage(org.apache.geode.distributed.internal.membership.api.Message<ID> gfmsg, JGAddress src, ID dst, short version) throws IOException {
        gfmsg.registerProcessor();
        Message msg = new Message();
        msg.setDest(null);
        msg.setSrc(src);
        this.setMessageFlags(gfmsg, msg);
        try {
            long start = this.services.getStatistics().startMsgSerialization();
            BufferDataOutputStream out_stream = new BufferDataOutputStream(Version.fromOrdinalNoThrow((short)version, (boolean)false));
            Version.writeOrdinal((DataOutput)out_stream, (short)Version.getCurrentVersion().ordinal(), (boolean)true);
            if (this.encrypt != null) {
                out_stream.writeBoolean(true);
                this.writeEncryptedMessage(gfmsg, dst, version, out_stream);
            } else {
                out_stream.writeBoolean(false);
                this.serializeMessage(gfmsg, out_stream);
            }
            msg.setBuffer(out_stream.toByteArray());
            this.services.getStatistics().endMsgSerialization(start);
        }
        catch (IOException ex) {
            logger.warn("Error serializing message", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("Error serializing message", (Throwable)ex);
            IOException ioe = new IOException("Error serializing message", ex.getCause());
            throw ioe;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeEncryptedMessage(org.apache.geode.distributed.internal.membership.api.Message<ID> gfmsg, ID recipient, short version, BufferDataOutputStream out) throws Exception {
        long start = this.services.getStatistics().startUDPMsgEncryption();
        try {
            this.services.getSerializer().writeDSFIDHeader(gfmsg.getDSFID(), (DataOutput)out);
            byte[] pk = null;
            int requestId = 0;
            Object pkMbr = null;
            switch (gfmsg.getDSFID()) {
                case -145: 
                case -142: {
                    pk = this.encrypt.getPublicKey(this.localAddress);
                    pkMbr = recipient;
                    requestId = this.getRequestId(gfmsg, pkMbr, true);
                    break;
                }
                case -144: 
                case -143: {
                    pkMbr = recipient;
                    requestId = this.getRequestId(gfmsg, pkMbr, false);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("writeEncryptedMessage gfmsg.getDSFID() = {} for {} with requestid {}", (Object)gfmsg.getDSFID(), pkMbr, (Object)requestId);
            }
            out.writeInt(requestId);
            if (pk != null) {
                StaticSerialization.writeByteArray((byte[])pk, (DataOutput)out);
            }
            BufferDataOutputStream out_stream = new BufferDataOutputStream(Version.fromOrdinalNoThrow((short)version, (boolean)false));
            byte[] messageBytes = this.serializeMessage(gfmsg, out_stream);
            messageBytes = pkMbr != null ? this.encrypt.encryptData(messageBytes, pkMbr) : this.encrypt.encryptData(messageBytes);
            StaticSerialization.writeByteArray((byte[])messageBytes, (DataOutput)out);
        }
        finally {
            this.services.getStatistics().endUDPMsgEncryption(start);
        }
    }

    int getRequestId(org.apache.geode.distributed.internal.membership.api.Message<ID> gfmsg, ID destination, boolean add) {
        int requestId = 0;
        if (gfmsg instanceof FindCoordinatorRequest) {
            requestId = ((FindCoordinatorRequest)gfmsg).getRequestId();
        } else if (gfmsg instanceof JoinRequestMessage) {
            requestId = ((JoinRequestMessage)gfmsg).getRequestId();
        } else if (gfmsg instanceof FindCoordinatorResponse) {
            requestId = ((FindCoordinatorResponse)gfmsg).getRequestId();
        } else if (gfmsg instanceof JoinResponseMessage) {
            requestId = ((JoinResponseMessage)gfmsg).getRequestId();
        }
        if (add) {
            this.addRequestId(requestId, destination);
        }
        return requestId;
    }

    byte[] serializeMessage(org.apache.geode.distributed.internal.membership.api.Message<ID> gfmsg, BufferDataOutputStream out_stream) throws IOException {
        ID m = this.localAddress;
        m.getMemberData().writeEssentialData((DataOutput)out_stream, this.services.getSerializer().createSerializationContext((DataOutput)out_stream));
        this.services.getSerializer().getObjectSerializer().writeObject(gfmsg, (DataOutput)out_stream);
        return out_stream.toByteArray();
    }

    void setMessageFlags(org.apache.geode.distributed.internal.membership.api.Message<ID> gfmsg, Message msg) {
        msg.setFlag(Message.Flag.DONT_BUNDLE);
        if (gfmsg.isHighPriority()) {
            msg.setFlag(Message.Flag.OOB);
            msg.setFlag(Message.Flag.NO_FC);
            msg.setFlag(Message.Flag.SKIP_BARRIER);
        }
        msg.setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
    }

    Object readJGMessage(Message jgmsg) {
        org.apache.geode.distributed.internal.membership.api.Message<ID> result = null;
        int messageLength = jgmsg.getLength();
        if (logger.isTraceEnabled()) {
            logger.trace("deserializing a message of length " + messageLength);
        }
        if (messageLength == 0) {
            logger.trace("message length is zero - ignoring");
            return null;
        }
        Exception problem = null;
        byte[] buf = jgmsg.getRawBuffer();
        try {
            boolean isEncrypted;
            long start = this.services.getStatistics().startMsgDeserialization();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf, jgmsg.getOffset(), jgmsg.getLength()));
            short ordinal = Version.readOrdinal((DataInput)dis);
            if (ordinal < Version.getCurrentVersion().ordinal()) {
                dis = new VersionedDataInputStream((InputStream)dis, Version.fromOrdinalNoThrow((short)ordinal, (boolean)false));
            }
            if ((isEncrypted = dis.readBoolean()) && this.encrypt == null) {
                throw new MembershipConfigurationException("Got remote message as encrypted");
            }
            result = isEncrypted ? this.readEncryptedMessage(dis, ordinal, this.encrypt) : this.deserializeMessage(dis, ordinal);
            this.services.getStatistics().endMsgDeserialization(start);
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            problem = e;
        }
        catch (Exception e) {
            problem = e;
        }
        if (problem != null) {
            logger.error(String.format("Exception deserializing message payload: %s", jgmsg), (Throwable)problem);
            return null;
        }
        return result;
    }

    void setSender(org.apache.geode.distributed.internal.membership.api.Message<ID> dm, ID m, short ordinal) {
        Object sender = null;
        sender = dm.getDSFID() == -142 ? (Object)((JoinRequestMessage)dm).getMemberID() : (Object)this.getMemberFromView(m, ordinal);
        dm.setSender(sender);
    }

    org.apache.geode.distributed.internal.membership.api.Message<ID> readEncryptedMessage(DataInputStream dis, short ordinal, GMSEncrypt<ID> encryptLocal) throws Exception {
        int dfsid = this.services.getSerializer().readDSFIDHeader((DataInput)dis);
        int requestId = dis.readInt();
        long start = this.services.getStatistics().startUDPMsgDecryption();
        try {
            byte[] data;
            if (logger.isDebugEnabled()) {
                logger.debug("readEncryptedMessage Reading Request id " + dfsid + " and requestid is " + requestId + " myid " + this.localAddress);
            }
            Object pkMbr = null;
            boolean readPK = false;
            switch (dfsid) {
                case -145: 
                case -142: {
                    readPK = true;
                    break;
                }
                case -144: 
                case -143: {
                    pkMbr = this.getRequestedMember(requestId);
                }
            }
            byte[] pk = null;
            if (readPK) {
                pk = StaticSerialization.readByteArray((DataInput)dis);
                data = StaticSerialization.readByteArray((DataInput)dis);
                data = encryptLocal.decryptData(data, pk);
            } else {
                data = StaticSerialization.readByteArray((DataInput)dis);
                data = pkMbr != null ? encryptLocal.decryptData(data, pkMbr) : encryptLocal.decryptData(data);
            }
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            if (ordinal < Version.getCurrentVersion().ordinal()) {
                in = new VersionedDataInputStream((InputStream)in, Version.fromOrdinalNoThrow((short)ordinal, (boolean)false));
            }
            org.apache.geode.distributed.internal.membership.api.Message<ID> result = this.deserializeMessage(in, ordinal);
            if (pk != null) {
                logger.info("Setting public key for " + result.getSender() + " len " + pk.length);
                this.setPublicKey(pk, result.getSender());
            }
            org.apache.geode.distributed.internal.membership.api.Message<ID> message = result;
            return message;
        }
        catch (Exception e) {
            throw new Exception("Message id is " + dfsid, e);
        }
        finally {
            this.services.getStatistics().endUDPMsgDecryption(start);
        }
    }

    org.apache.geode.distributed.internal.membership.api.Message<ID> deserializeMessage(DataInputStream in, short ordinal) throws ClassNotFoundException, IOException {
        GMSMemberData info = new GMSMemberData();
        info.readEssentialData(in, this.services.getSerializer().createDeserializationContext((DataInput)in));
        ID m = this.services.getMemberFactory().create(info);
        org.apache.geode.distributed.internal.membership.api.Message result = (org.apache.geode.distributed.internal.membership.api.Message)this.services.getSerializer().getObjectDeserializer().readObject((DataInput)in);
        this.setSender(result, m, ordinal);
        return result;
    }

    void filterOutgoingMessage(org.apache.geode.distributed.internal.membership.api.Message<ID> m) {
        switch (m.getDSFID()) {
            case -143: {
                JoinResponseMessage jrsp = (JoinResponseMessage)m;
                if (jrsp.getRejectionMessage() != null || !this.services.getConfig().isMulticastEnabled()) break;
                Digest digest = (Digest)this.myChannel.getProtocolStack().getTopProtocol().down(Event.GET_DIGEST_EVT);
                BufferDataOutputStream hdos = new BufferDataOutputStream(500, Version.CURRENT);
                try {
                    digest.writeTo((DataOutput)hdos);
                }
                catch (Exception e) {
                    logger.fatal("Unable to serialize JGroups messaging digest", (Throwable)e);
                }
                jrsp.setMessengerData(hdos.toByteArray());
                break;
            }
        }
    }

    void filterIncomingMessage(org.apache.geode.distributed.internal.membership.api.Message<ID> m) {
        switch (m.getDSFID()) {
            case -143: {
                JoinResponseMessage jrsp = (JoinResponseMessage)m;
                if (jrsp.getRejectionMessage() != null || !this.services.getConfig().isMulticastEnabled()) break;
                byte[] serializedDigest = jrsp.getMessengerData();
                ByteArrayInputStream bis = new ByteArrayInputStream(serializedDigest);
                DataInputStream dis = new DataInputStream(bis);
                try {
                    Digest digest = new Digest();
                    digest.readFrom(dis);
                    logger.trace("installing JGroups message digest {} from {}", (Object)digest, m);
                    this.myChannel.getProtocolStack().getTopProtocol().down(new Event(53, digest));
                    jrsp.setMessengerData(null);
                }
                catch (Exception e) {
                    logger.fatal("Unable to read JGroups messaging digest", (Throwable)e);
                }
                break;
            }
        }
    }

    @Override
    public ID getMemberID() {
        return this.localAddress;
    }

    private ID getMemberFromView(ID jgId, short version) {
        return this.services.getJoinLeave().getMemberID(jgId);
    }

    @Override
    public void emergencyClose() {
        this.view = null;
        if (!(this.myChannel == null || this.services.isShutdownDueToForcedDisconnect() && this.services.isAutoReconnectEnabled() || this.services.getManager().isReconnectingDS())) {
            this.myChannel.disconnect();
        }
    }

    @Override
    public GMSQuorumChecker<ID> getQuorumChecker() {
        GMSMembershipView<ID> view = this.view;
        if (view == null && (view = this.services.getJoinLeave().getView()) == null && (view = this.services.getJoinLeave().getPreviousView()) == null) {
            return null;
        }
        GMSQuorumChecker<ID> qc = new GMSQuorumChecker<ID>(view, this.services.getConfig().getLossThreshold(), this.myChannel);
        qc.initialize();
        return qc;
    }

    @Override
    public Set<ID> send(org.apache.geode.distributed.internal.membership.api.Message<ID> msg, GMSMembershipView<ID> alternateView) {
        if (this.encrypt != null) {
            this.encrypt.installView(alternateView);
        }
        return this.send(msg, true);
    }

    @Override
    public byte[] getPublicKey(ID mbr) {
        if (this.encrypt != null) {
            return this.encrypt.getPublicKey(mbr);
        }
        return null;
    }

    @Override
    public void setPublicKey(byte[] publickey, ID mbr) {
        if (this.encrypt != null) {
            logger.debug("Setting PK for member " + mbr);
            this.encrypt.setPublicKey(publickey, mbr);
        }
    }

    @Override
    public void setClusterSecretKey(byte[] clusterSecretKey) {
        if (this.encrypt != null) {
            logger.debug("Setting cluster key");
            this.encrypt.setClusterKey(clusterSecretKey);
        }
    }

    @Override
    public byte[] getClusterSecretKey() {
        if (this.encrypt != null) {
            return this.encrypt.getClusterSecretKey();
        }
        return null;
    }

    ID getRequestedMember(int requestId) {
        return (ID)((MemberIdentifier)this.requestIdVsRecipients.remove(requestId));
    }

    void addRequestId(int requestId, ID mbr) {
        this.requestIdVsRecipients.put(requestId, mbr);
    }

    @Override
    public int getRequestId() {
        return this.requestId.incrementAndGet();
    }

    @Override
    public void initClusterKey() {
        if (this.encrypt != null) {
            try {
                logger.info("Initializing cluster key");
                this.encrypt.initClusterSecretKey();
            }
            catch (Exception e) {
                throw new RuntimeException("unable to create cluster key ", e);
            }
        }
    }

    static {
        ClassConfigurator.add((short)2000, JGAddress.class);
        ClassConfigurator.addProtocol((short)1000, Transport.class);
    }

    static class MessageTracker {
        long highestSeqno;

        MessageTracker(long seqno) {
            this.highestSeqno = seqno;
        }

        long get() {
            return this.highestSeqno;
        }

        void record(long seqno) {
            if (seqno > this.highestSeqno) {
                this.highestSeqno = seqno;
            }
        }
    }

    class JGroupsReceiver
    extends ReceiverAdapter {
        JGroupsReceiver() {
        }

        @Override
        public void receive(Message jgmsg) {
            this.receive(jgmsg, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receive(Message jgmsg, boolean fromQuorumChecker) {
            long startTime = JGroupsMessenger.this.services.getStatistics().startUDPDispatchRequest();
            try {
                byte[] contents;
                if (JGroupsMessenger.this.services.getManager().shutdownInProgress()) {
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("JGroupsMessenger received {} headers: {}", (Object)jgmsg, jgmsg.getHeaders());
                }
                if ((contents = jgmsg.getBuffer()) == null) {
                    return;
                }
                if (JGroupsMessenger.this.pingPonger.isPingMessage(contents)) {
                    try {
                        JGroupsMessenger.this.pingPonger.sendPongMessage(JGroupsMessenger.this.myChannel, JGroupsMessenger.this.jgAddress, jgmsg.getSrc());
                    }
                    catch (Exception e) {
                        logger.info("Failed sending Pong response to " + jgmsg.getSrc());
                    }
                    return;
                }
                if (JGroupsMessenger.this.pingPonger.isPongMessage(contents)) {
                    JGroupsMessenger.this.pongsReceived.incrementAndGet();
                    return;
                }
                Object o = JGroupsMessenger.this.readJGMessage(jgmsg);
                if (o == null) {
                    return;
                }
                org.apache.geode.distributed.internal.membership.api.Message msg = (org.apache.geode.distributed.internal.membership.api.Message)o;
                if (JGroupsMessenger.this.services.getConfig().getVmKind() == 12 && msg instanceof CacheOperationMessageMarker) {
                    return;
                }
                msg.resetTimestamp();
                msg.setBytesRead(jgmsg.getLength());
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("JGroupsMessenger dispatching {} from {}", (Object)msg, msg.getSender());
                    }
                    JGroupsMessenger.this.filterIncomingMessage(msg);
                    MessageHandler handler = this.getMessageHandler(msg);
                    if (!fromQuorumChecker || !(handler instanceof HealthMonitor)) {
                        handler.processMessage(msg);
                    }
                    NakAckHeader2 header = (NakAckHeader2)jgmsg.getHeader(JGroupsMessenger.this.nackack2HeaderId);
                    if (header != null && !jgmsg.isFlagSet(Message.Flag.OOB)) {
                        this.recordScheduledSeqno(msg.getSender(), header.getSeqno());
                    }
                }
                catch (MemberShunnedException memberShunnedException) {
                    // empty catch block
                }
            }
            finally {
                JGroupsMessenger.this.services.getStatistics().endUDPDispatchRequest(startTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordScheduledSeqno(ID member, long seqno) {
            Map map = JGroupsMessenger.this.scheduledMcastSeqnos;
            synchronized (map) {
                MessageTracker counter = JGroupsMessenger.this.scheduledMcastSeqnos.get(member);
                if (counter == null) {
                    counter = new MessageTracker(seqno);
                    JGroupsMessenger.this.scheduledMcastSeqnos.put(member, counter);
                }
                counter.record(seqno);
            }
        }

        private MessageHandler<org.apache.geode.distributed.internal.membership.api.Message<ID>> getMessageHandler(org.apache.geode.distributed.internal.membership.api.Message<ID> msg) {
            Class<?> msgClazz = msg.getClass();
            MessageHandler h = (Manager)JGroupsMessenger.this.handlers.get(msgClazz);
            if (h == null) {
                for (Class clazz : JGroupsMessenger.this.handlers.keySet()) {
                    if (!clazz.isAssignableFrom(msgClazz)) continue;
                    h = (MessageHandler)JGroupsMessenger.this.handlers.get(clazz);
                    JGroupsMessenger.this.handlers.put(msg.getClass(), h);
                    break;
                }
            }
            if (h == null) {
                h = JGroupsMessenger.this.services.getManager();
            }
            return h;
        }
    }
}

