/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.felix.http.base.internal.util.MimeTypes;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final String prefix;

    public ResourceServlet(String prefix) {
        this.prefix = prefix;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String target = req.getPathInfo();
        String resName = target == null ? this.prefix : this.prefix.concat(target);
        URL url = this.getServletContext().getResource(resName);
        if (url == null) {
            res.sendError(404);
        } else {
            this.handle(req, res, url, resName);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse res, URL url, String resName) throws IOException {
        URLConnection conn;
        long lastModified;
        String contentType = this.getServletContext().getMimeType(resName);
        if (contentType == null) {
            contentType = MimeTypes.get().getByFile(resName);
        }
        if (contentType != null) {
            res.setContentType(contentType);
        }
        if ((lastModified = this.getLastModified(conn = url.openConnection())) != 0L) {
            res.setDateHeader("Last-Modified", lastModified);
        }
        if (!this.resourceModified(lastModified, req.getDateHeader("If-Modified-Since"))) {
            res.setStatus(304);
        } else {
            this.copyResource(conn, res);
        }
    }

    private File getFile(URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                return new File(url.getPath());
            }
        }
        return null;
    }

    private long getLastModified(URLConnection conn) {
        File f;
        long lastModified = conn.getLastModified();
        if (lastModified == 0L && (f = this.getFile(conn.getURL())) != null && f.exists()) {
            lastModified = f.lastModified();
        }
        return lastModified;
    }

    private boolean resourceModified(long resTimestamp, long modSince) {
        return (resTimestamp /= 1000L) == 0L || (modSince /= 1000L) == -1L || resTimestamp > modSince;
    }

    private void copyResource(URLConnection conn, HttpServletResponse res) throws IOException {
        try (InputStream is = conn.getInputStream();){
            int n;
            long len = this.getContentLength(conn);
            if (len >= 0L) {
                res.setContentLengthLong(len);
            }
            byte[] buf = new byte[1024];
            ServletOutputStream os = res.getOutputStream();
            while ((n = is.read(buf, 0, buf.length)) > 0) {
                os.write(buf, 0, n);
            }
            os.flush();
        }
    }

    private long getContentLength(URLConnection conn) {
        File f;
        long length = conn.getContentLengthLong();
        if (length < 0L && (f = this.getFile(conn.getURL())) != null && f.exists()) {
            length = f.length();
        }
        return length;
    }
}

