/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.AddResponse;

public class AddResponseDecorator
extends ResponseDecorator<AddResponse>
implements AddResponse {
    private int addResponseLength;

    public AddResponseDecorator(LdapApiService codec, AddResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public AddResponse getAddResponse() {
        return (AddResponse)this.getDecorated();
    }

    @Override
    public int computeLength() {
        AddResponse addResponse = this.getAddResponse();
        this.setLdapResult(new LdapResultDecorator(this.getCodecService(), addResponse.getLdapResult()));
        this.addResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        return 1 + TLV.getNbBytes((int)this.addResponseLength) + this.addResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)105);
            buffer.put(TLV.getBytes((int)this.addResponseLength));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
            return buffer;
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
    }
}

