/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestDerefAlias
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestDerefAlias.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSearchRequestDerefAlias() {
        super("Store SearchRequest derefAlias flag");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        int derefAliases = 0;
        try {
            derefAliases = IntegerDecoder.parse((BerValue)value, (int)0, (int)3);
        }
        catch (IntegerDecoderException ide) {
            String msg = I18n.err((I18n)I18n.ERR_04102, (Object[])new Object[]{value.toString()});
            LOG.error(msg);
            throw new DecoderException(msg, (Throwable)ide);
        }
        searchRequest.setDerefAliases(AliasDerefMode.getDerefMode((int)derefAliases));
        if (IS_DEBUG) {
            switch (derefAliases) {
                case 0: {
                    LOG.debug("Handling object strategy : NEVER_DEREF_ALIASES");
                    break;
                }
                case 1: {
                    LOG.debug("Handling object strategy : DEREF_IN_SEARCHING");
                    break;
                }
                case 2: {
                    LOG.debug("Handling object strategy : DEREF_FINDING_BASE_OBJ");
                    break;
                }
                case 3: {
                    LOG.debug("Handling object strategy : DEREF_ALWAYS");
                    break;
                }
                default: {
                    LOG.debug("Handling object strategy : UNKNOWN");
                }
            }
        }
    }
}

