/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.util.Strings;

public class ObjectIdentifierNormalizer
extends Normalizer {
    public ObjectIdentifierNormalizer() {
        super("2.5.13.0");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        if (value == null) {
            return null;
        }
        String str = value.getString().trim();
        if (str.length() == 0) {
            return new StringValue("");
        }
        if (Character.isDigit(str.charAt(0))) {
            return new StringValue(str);
        }
        return new StringValue(Strings.toLowerCaseAscii((String)str));
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (value == null) {
            return null;
        }
        String str = value.trim();
        if (str.length() == 0) {
            return "";
        }
        if (Character.isDigit(str.charAt(0))) {
            return str;
        }
        return Strings.toLowerCaseAscii((String)str);
    }
}

