/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.tdml.DFDLTestSuite;
import org.apache.daffodil.tdml.ExpectedErrors;
import org.apache.daffodil.tdml.ExpectedValidationErrors;
import org.apache.daffodil.tdml.ExpectedWarnings;
import org.apache.daffodil.tdml.Infoset;
import org.apache.daffodil.tdml.NoRoundTrip$;
import org.apache.daffodil.tdml.OnePassRoundTrip$;
import org.apache.daffodil.tdml.ParserTestCase$;
import org.apache.daffodil.tdml.RoundTrip;
import org.apache.daffodil.tdml.TDMLDiagnostic;
import org.apache.daffodil.tdml.TDMLException;
import org.apache.daffodil.tdml.TDMLException$;
import org.apache.daffodil.tdml.TestCase;
import org.apache.daffodil.tdml.ThreePassRoundTrip$;
import org.apache.daffodil.tdml.TwoPassRoundTrip$;
import org.apache.daffodil.tdml.VerifyTestCase$;
import org.apache.daffodil.tdml.processor.TDMLDFDLProcessor;
import org.apache.daffodil.tdml.processor.TDMLParseResult;
import org.apache.daffodil.tdml.processor.TDMLUnparseResult;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import scala.xml.Node;
import scala.xml.NodeSeq;

public class ParserTestCase
extends TestCase
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ParserTestCase.class.getDeclaredField("optExpectedInfoset$lzy1"));
    private final NodeSeq ptc;
    private final DFDLTestSuite parentArg;
    private volatile Object optExpectedInfoset$lzy1;

    public static ParserTestCase apply(NodeSeq nodeSeq, DFDLTestSuite dFDLTestSuite) {
        return ParserTestCase$.MODULE$.apply(nodeSeq, dFDLTestSuite);
    }

    public static ParserTestCase fromProduct(Product product) {
        return ParserTestCase$.MODULE$.fromProduct(product);
    }

    public static ParserTestCase unapply(ParserTestCase parserTestCase) {
        return ParserTestCase$.MODULE$.unapply(parserTestCase);
    }

    public ParserTestCase(NodeSeq ptc, DFDLTestSuite parentArg) {
        this.ptc = ptc;
        this.parentArg = parentArg;
        super(ptc, parentArg);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1846399418, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ParserTestCase)) return false;
        ParserTestCase parserTestCase = (ParserTestCase)object;
        NodeSeq nodeSeq = this.ptc();
        NodeSeq nodeSeq2 = parserTestCase.ptc();
        if (nodeSeq == null) {
            if (nodeSeq2 != null) {
                return false;
            }
        } else if (!nodeSeq.equals(nodeSeq2)) return false;
        DFDLTestSuite dFDLTestSuite = this.parentArg();
        DFDLTestSuite dFDLTestSuite2 = parserTestCase.parentArg();
        if (dFDLTestSuite == null) {
            if (dFDLTestSuite2 != null) {
                return false;
            }
        } else if (!dFDLTestSuite.equals(dFDLTestSuite2)) return false;
        if (!parserTestCase.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ParserTestCase;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ParserTestCase";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "ptc";
        }
        if (1 == n2) {
            return "parentArg";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public NodeSeq ptc() {
        return this.ptc;
    }

    public DFDLTestSuite parentArg() {
        return this.parentArg;
    }

    public Option<Infoset> optExpectedInfoset() {
        Object object = this.optExpectedInfoset$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.optExpectedInfoset$lzyINIT1();
    }

    private Object optExpectedInfoset$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.optExpectedInfoset$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Option<Infoset> option = null;
                    Option<Infoset> option2 = null;
                    try {
                        option2 = this.optExpectedOrInputInfoset();
                        option = option2 == null ? LazyVals.NullValue$.MODULE$ : option2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, option)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.optExpectedInfoset$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, option);
                            waiting.countDown();
                        }
                    }
                    return option2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void runProcessor(Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> compileResult, Option<InputStream> optDataToParse, Option<Object> optLengthLimitInBits, Option<Seq<ExpectedErrors>> optExpectedErrors, Option<Seq<ExpectedWarnings>> optExpectedWarnings, Option<Seq<ExpectedValidationErrors>> optExpectedValidationErrors, RoundTrip roundTrip, Option<String> implString) {
        if (!optLengthLimitInBits.isDefined()) {
            throw Assert$.MODULE$.usageError2("TDML tests should always have a length limit.", "optLengthLimitInBits.isDefined");
        }
        long nBits = BoxesRunTime.unboxToLong((Object)optLengthLimitInBits.get());
        InputStream dataToParse = (InputStream)optDataToParse.get();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.optExpectedInfoset(), optExpectedErrors);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some && None$.MODULE$.equals(option2)) {
                Tuple2 tuple22;
                Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> either = compileResult;
                if (either instanceof Left) {
                    List diags = (List)((Left)either).value();
                    this.checkDiagnosticMessages((Iterable<Diagnostic>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala(), optExpectedErrors, optExpectedWarnings, optExpectedValidationErrors, implString);
                    return;
                }
                if (either instanceof Right && (tuple22 = (Tuple2)((Right)either).value()) != null) {
                    List diags = (List)tuple22._1();
                    TDMLDFDLProcessor proc = (TDMLDFDLProcessor)tuple22._2();
                    this.processor_$eq(proc);
                    this.runParseExpectSuccess(dataToParse, nBits, optExpectedWarnings, optExpectedValidationErrors, roundTrip, implString, (Iterable<Diagnostic>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala());
                    return;
                }
                throw new MatchError(either);
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                Tuple2 tuple23;
                Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> either = compileResult;
                if (either instanceof Left) {
                    List diags = (List)((Left)either).value();
                    this.checkDiagnosticMessages((Iterable<Diagnostic>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala(), optExpectedErrors, optExpectedWarnings, optExpectedValidationErrors, implString);
                    return;
                }
                if (either instanceof Right && (tuple23 = (Tuple2)((Right)either).value()) != null) {
                    List diags = (List)tuple23._1();
                    TDMLDFDLProcessor proc = (TDMLDFDLProcessor)tuple23._2();
                    this.processor_$eq(proc);
                    this.runParseExpectErrors(dataToParse, nBits, optExpectedErrors, optExpectedWarnings, optExpectedValidationErrors, implString, (Iterable<Diagnostic>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala());
                    return;
                }
                throw new MatchError(either);
            }
        }
        throw TDMLException$.MODULE$.apply("Either tdml:infoset or tdml:errors must be present in the test.", implString);
    }

    public void runParseExpectErrors(InputStream dataToParse, long lengthLimitInBits, Option<Seq<ExpectedErrors>> optErrors, Option<Seq<ExpectedWarnings>> optWarnings, Option<Seq<ExpectedValidationErrors>> optValidationErrors, Option<String> implString, Iterable<Diagnostic> compileWarnings) {
        boolean bl;
        TDMLParseResult tDMLParseResult;
        try {
            this.processor_$eq(this.processor().withExternalDFDLVariables(this.externalVarBindings()));
        }
        catch (Exception e) {
            throw TDMLException$.MODULE$.apply(e, implString);
        }
        try {
            tDMLParseResult = this.processor().parse(dataToParse, lengthLimitInBits);
        }
        catch (Throwable t) {
            throw this.toss(t, implString);
        }
        TDMLParseResult actual = tDMLParseResult;
        actual.cleanUp();
        if (actual.isProcessingError()) {
            bl = true;
        } else {
            DataLocation loc = actual.currentLocation();
            if (loc.bitPos1b() >= 0L && loc.bitPos1b() <= lengthLimitInBits) {
                String leftOverMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Left over data. Consumed %s bit(s) with %s bit(s) remaining."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(loc.bitPos1b() - 1L)), BoxesRunTime.boxToLong((long)(lengthLimitInBits - (loc.bitPos1b() - 1L)))}));
                actual.addDiagnostic(new TDMLDiagnostic(leftOverMsg, implString));
                bl = true;
            } else {
                bl = false;
            }
        }
        boolean isErr = bl;
        Iterable diagnostics = (Iterable)compileWarnings.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(actual.getDiagnostics()).asScala());
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)actual, (Object)diagnostics, (Object)BoxesRunTime.boxToBoolean((boolean)isErr));
        TDMLParseResult parseResult = (TDMLParseResult)tuple3._1();
        Iterable diagnostics2 = (Iterable)tuple3._2();
        boolean isError = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        if (!isError) {
            throw this.toss(TDMLException$.MODULE$.apply("Expected error. Didn't get one. Actual result was\n" + parseResult.getResult().toString(), implString), implString);
        }
        this.checkDiagnosticMessages((Iterable<Diagnostic>)diagnostics2, optErrors, optWarnings, optValidationErrors, implString);
    }

    private TDMLParseResult doParseExpectSuccess(byte[] testData, Infoset testInfoset, long lengthLimitInBits, Option<String> implString) {
        long testDataLength = lengthLimitInBits;
        try {
            this.processor_$eq(this.processor().withExternalDFDLVariables(this.externalVarBindings()));
        }
        catch (Exception e) {
            throw TDMLException$.MODULE$.apply(e, implString);
        }
        TDMLParseResult actual = this.processor().parse(new ByteArrayInputStream(testData), testDataLength);
        Buffer diagObjs = CollectionConverters$.MODULE$.ListHasAsScala(actual.getDiagnostics()).asScala();
        if (actual.isProcessingError()) {
            if (diagObjs.length() == 1) {
                throw TDMLException$.MODULE$.apply((Throwable)diagObjs.head(), implString);
            }
            String diags = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(actual.getDiagnostics()).asScala().map((Function1 & Serializable)_$14 -> _$14.toString())).mkString("\n");
            throw TDMLException$.MODULE$.apply(diags, implString);
        }
        boolean hasErrorDiags = diagObjs.exists((Function1 & Serializable)diag -> diag.isError() && !diag.isValidation());
        if (hasErrorDiags) {
            throw Assert$.MODULE$.abort("Invariant broken: hasErrorDiags.unary_!");
        }
        return actual;
    }

    private Option<Nothing$> verifyLeftOverData(TDMLParseResult actual, long lengthLimitInBits, Option<String> implString) {
        None$ none$;
        DataLocation loc = actual.currentLocation();
        if (loc.bitPos1b() >= 0L && loc.bitPos1b() < lengthLimitInBits) {
            String leftOverMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Left over data. Consumed %s bit(s) with %s bit(s) remaining."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(loc.bitPos1b() - 1L)), BoxesRunTime.boxToLong((long)(lengthLimitInBits - (loc.bitPos1b() - 1L)))}));
            none$ = Some$.MODULE$.apply((Object)TDMLException$.MODULE$.apply(leftOverMsg, implString));
        } else {
            none$ = None$.MODULE$;
        }
        None$ leftOverException = none$;
        return leftOverException.map((Function1 & Serializable)_$15 -> {
            throw _$15;
        });
    }

    private void verifyParseResults(Iterable<Diagnostic> compileWarnings, TDMLParseResult actual, Infoset testInfoset, Option<String> implString) {
        Node resultXmlNode = actual.getResult();
        VerifyTestCase$.MODULE$.verifyParserTestData(resultXmlNode, testInfoset, implString);
        Iterable allDiags = (Iterable)compileWarnings.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(actual.getDiagnostics()).asScala());
        this.checkDiagnosticMessages((Iterable<Diagnostic>)allDiags, (Option<Seq<ExpectedErrors>>)None$.MODULE$, this.optExpectedWarnings(), this.optExpectedValidationErrors(), implString);
    }

    private TDMLUnparseResult doOnePassRoundTripUnparseExpectSuccess(OutputStream outStream, TDMLParseResult parseResult, Option<String> implString) {
        TDMLUnparseResult unparseResult = this.processor().unparse(parseResult, outStream);
        if (unparseResult.isProcessingError()) {
            Buffer diagObjs = CollectionConverters$.MODULE$.ListHasAsScala(unparseResult.getDiagnostics()).asScala();
            if (diagObjs.length() == 1) {
                throw TDMLException$.MODULE$.apply((Throwable)diagObjs.head(), implString);
            }
            throw TDMLException$.MODULE$.apply((Iterable<Throwable>)diagObjs, implString);
        }
        return unparseResult;
    }

    private Tuple3<TDMLParseResult, byte[], Object> doTwoPassRoundTripExpectSuccess(Option<String> implString, TDMLParseResult parseResult, byte[] firstParseTestData, Infoset testInfoset, String passesLabel) {
        long fullBytesNeeded;
        boolean bl;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TDMLUnparseResult unparseResult = this.doOnePassRoundTripUnparseExpectSuccess(outStream, parseResult, implString);
        try {
            VerifyTestCase$.MODULE$.verifyUnparserTestData(new ByteArrayInputStream(firstParseTestData), outStream, implString);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof TDMLException) {
                bl = false;
            }
            throw throwable;
        }
        boolean isUnparseOutputDataMatching = bl;
        if (isUnparseOutputDataMatching) {
            String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected data from first unparse of %s to NOT match original input, but it did match.\nShould this really be a %s test?"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{passesLabel, passesLabel}));
            throw TDMLException$.MODULE$.apply(msg, implString);
        }
        byte[] reParseTestData = outStream.toByteArray();
        long reParseTestDataLength = unparseResult.bitPos0b();
        if (reParseTestDataLength >= 0L && (long)reParseTestData.length != (fullBytesNeeded = (reParseTestDataLength + 7L) / 8L)) {
            throw TDMLException$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unparse result data was was %d bytes, but the result length (%d bits) requires %d bytes."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)reParseTestData.length), BoxesRunTime.boxToLong((long)reParseTestDataLength), BoxesRunTime.boxToLong((long)fullBytesNeeded)})), implString);
        }
        TDMLParseResult actual = this.doParseExpectSuccess(reParseTestData, testInfoset, reParseTestDataLength, implString);
        return Tuple3$.MODULE$.apply((Object)actual, (Object)reParseTestData, (Object)BoxesRunTime.boxToLong((long)reParseTestDataLength));
    }

    private String doTwoPassRoundTripExpectSuccess$default$5() {
        return TwoPassRoundTrip$.MODULE$.propValueName();
    }

    public void runParseExpectSuccess(InputStream dataToParse, long lengthLimitInBits, Option<Seq<ExpectedWarnings>> warnings, Option<Seq<ExpectedValidationErrors>> validationErrors, RoundTrip roundTripArg, Option<String> implString, Iterable<Diagnostic> compileWarnings) {
        RoundTrip roundTrip = roundTripArg;
        byte[] firstParseTestData = IOUtils.toByteArray((InputStream)dataToParse);
        Infoset testInfoset = (Infoset)this.optExpectedInfoset().get();
        TDMLParseResult firstParseResult = this.doParseExpectSuccess(firstParseTestData, testInfoset, lengthLimitInBits, implString);
        RoundTrip roundTrip2 = roundTrip;
        if (NoRoundTrip$.MODULE$.equals(roundTrip2) || OnePassRoundTrip$.MODULE$.equals(roundTrip2)) {
            this.verifyParseResults(compileWarnings, firstParseResult, testInfoset, implString);
            v0 = this.verifyLeftOverData(firstParseResult, lengthLimitInBits, implString);
        } else if (TwoPassRoundTrip$.MODULE$.equals(roundTrip2)) {
            v0 = BoxedUnit.UNIT;
        } else if (ThreePassRoundTrip$.MODULE$.equals(roundTrip2)) {
            v0 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)roundTrip2);
        }
        RoundTrip roundTrip3 = roundTrip;
        if (NoRoundTrip$.MODULE$.equals(roundTrip3)) {
            firstParseResult.cleanUp();
            return;
        }
        if (OnePassRoundTrip$.MODULE$.equals(roundTrip3)) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.doOnePassRoundTripUnparseExpectSuccess(outStream, firstParseResult, implString);
            VerifyTestCase$.MODULE$.verifyUnparserTestData(new ByteArrayInputStream(firstParseTestData), outStream, implString);
            firstParseResult.cleanUp();
            return;
        }
        if (TwoPassRoundTrip$.MODULE$.equals(roundTrip3)) {
            Tuple3<TDMLParseResult, byte[], Object> tuple3 = this.doTwoPassRoundTripExpectSuccess(implString, firstParseResult, firstParseTestData, testInfoset, this.doTwoPassRoundTripExpectSuccess$default$5());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            TDMLParseResult actual = (TDMLParseResult)tuple3._1();
            long reParseTestDataLength = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)actual, (Object)BoxesRunTime.boxToLong((long)reParseTestDataLength));
            TDMLParseResult actual2 = (TDMLParseResult)tuple2._1();
            long reParseTestDataLength2 = BoxesRunTime.unboxToLong((Object)tuple2._2());
            this.verifyParseResults(compileWarnings, actual2, testInfoset, implString);
            this.verifyLeftOverData(actual2, reParseTestDataLength2, implString);
            firstParseResult.cleanUp();
            actual2.cleanUp();
            return;
        }
        if (ThreePassRoundTrip$.MODULE$.equals(roundTrip3)) {
            Tuple3<TDMLParseResult, byte[], Object> tuple3 = this.doTwoPassRoundTripExpectSuccess(implString, firstParseResult, firstParseTestData, testInfoset, ThreePassRoundTrip$.MODULE$.propValueName());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            TDMLParseResult secondParseResult = (TDMLParseResult)tuple3._1();
            byte[] reParseTestData = (byte[])tuple3._2();
            long reParseTestDataLength = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)secondParseResult, (Object)reParseTestData, (Object)BoxesRunTime.boxToLong((long)reParseTestDataLength));
            TDMLParseResult secondParseResult2 = (TDMLParseResult)tuple32._1();
            byte[] reParseTestData2 = (byte[])tuple32._2();
            long reParseTestDataLength3 = BoxesRunTime.unboxToLong((Object)tuple32._3());
            this.verifyParseResults(compileWarnings, secondParseResult2, testInfoset, implString);
            this.verifyLeftOverData(secondParseResult2, reParseTestDataLength3, implString);
            ByteArrayOutputStream thirdPassOutStream = new ByteArrayOutputStream();
            this.doOnePassRoundTripUnparseExpectSuccess(thirdPassOutStream, firstParseResult, implString);
            VerifyTestCase$.MODULE$.verifyUnparserTestData(new ByteArrayInputStream(reParseTestData2), thirdPassOutStream, implString);
            firstParseResult.cleanUp();
            secondParseResult2.cleanUp();
            return;
        }
        throw new MatchError((Object)roundTrip3);
    }

    public ParserTestCase copy(NodeSeq ptc, DFDLTestSuite parentArg) {
        return new ParserTestCase(ptc, parentArg);
    }

    public NodeSeq copy$default$1() {
        return this.ptc();
    }

    public DFDLTestSuite copy$default$2() {
        return this.parentArg();
    }

    public NodeSeq _1() {
        return this.ptc();
    }

    public DFDLTestSuite _2() {
        return this.parentArg();
    }
}

