/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingResultSet;
import org.apache.commons.dbcp2.Jdbc41Bridge;

public class DelegatingDatabaseMetaData
implements DatabaseMetaData {
    private final DatabaseMetaData databaseMetaData;
    private final DelegatingConnection<?> connection;

    public DelegatingDatabaseMetaData(DelegatingConnection<?> connection, DatabaseMetaData databaseMetaData) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.databaseMetaData = Objects.requireNonNull(databaseMetaData, "databaseMetaData");
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.getB(this.databaseMetaData::allProceduresAreCallable);
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.getB(this.databaseMetaData::allTablesAreSelectable);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return this.getB(this.databaseMetaData::autoCommitFailureClosesAllResultSets);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getB(this.databaseMetaData::dataDefinitionCausesTransactionCommit);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getB(this.databaseMetaData::dataDefinitionIgnoredInTransactions);
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.deletesAreDetected(type));
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.getB(this.databaseMetaData::doesMaxRowSizeIncludeBlobs);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        this.connection.checkOpen();
        return this.getB(() -> Jdbc41Bridge.generatedKeyAlwaysReturned(this.databaseMetaData));
    }

    private <T> T get(Callable<T> s) throws SQLException {
        return this.get(s, null);
    }

    private <T> T get(Callable<T> s, T defaultValue) throws SQLException {
        try {
            return s.call();
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                this.handleException((SQLException)e);
            }
            return defaultValue;
        }
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern));
    }

    private boolean getB(Callable<Boolean> s) throws SQLException {
        return this.get(s, false);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getBestRowIdentifier(catalog, schema, table, scope, nullable));
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.getRS(this.databaseMetaData::getCatalogs);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.get(this.databaseMetaData::getCatalogSeparator);
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.get(this.databaseMetaData::getCatalogTerm);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getRS(this.databaseMetaData::getClientInfoProperties);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getColumnPrivileges(catalog, schema, table, columnNamePattern));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable));
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.getI(this.databaseMetaData::getDatabaseMajorVersion);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.getI(this.databaseMetaData::getDatabaseMinorVersion);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.get(this.databaseMetaData::getDatabaseProductName);
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.get(this.databaseMetaData::getDatabaseProductVersion);
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.getI(this.databaseMetaData::getDefaultTransactionIsolation);
    }

    public DatabaseMetaData getDelegate() {
        return this.databaseMetaData;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.databaseMetaData.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.databaseMetaData.getDriverMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.get(this.databaseMetaData::getDriverName);
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.get(this.databaseMetaData::getDriverVersion);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getExportedKeys(catalog, schema, table));
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.get(this.databaseMetaData::getExtraNameCharacters);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern));
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getFunctions(catalog, schemaPattern, functionNamePattern));
    }

    private int getI(Callable<Integer> s) throws SQLException {
        return this.get(s, 0);
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.get(this.databaseMetaData::getIdentifierQuoteString);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getImportedKeys(catalog, schema, table));
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getIndexInfo(catalog, schema, table, unique, approximate));
    }

    public DatabaseMetaData getInnermostDelegate() {
        DatabaseMetaData m = this.databaseMetaData;
        while (m instanceof DelegatingDatabaseMetaData) {
            if (this != (m = ((DelegatingDatabaseMetaData)m).getDelegate())) continue;
            return null;
        }
        return m;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return this.getI(this.databaseMetaData::getJDBCMajorVersion);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return this.getI(this.databaseMetaData::getJDBCMinorVersion);
    }

    private long getL(Callable<Long> s) throws SQLException {
        return this.get(s, 0L);
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxBinaryLiteralLength);
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxCatalogNameLength);
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxCharLiteralLength);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxColumnNameLength);
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxColumnsInGroupBy);
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxColumnsInIndex);
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxColumnsInOrderBy);
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxColumnsInSelect);
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxColumnsInTable);
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxConnections);
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxCursorNameLength);
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxIndexLength);
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        return this.getL(this.databaseMetaData::getMaxLogicalLobSize);
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxProcedureNameLength);
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxRowSize);
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxSchemaNameLength);
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxStatementLength);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxStatements);
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxTableNameLength);
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxTablesInSelect);
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getI(this.databaseMetaData::getMaxUserNameLength);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.get(this.databaseMetaData::getNumericFunctions);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getPrimaryKeys(catalog, schema, table));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern));
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getProcedures(catalog, schemaPattern, procedureNamePattern));
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.get(this.databaseMetaData::getProcedureTerm);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getRS(() -> Jdbc41Bridge.getPseudoColumns(this.databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getI(this.databaseMetaData::getResultSetHoldability);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return this.get(this.databaseMetaData::getRowIdLifetime);
    }

    private ResultSet getRS(Callable<ResultSet> s) throws SQLException {
        this.connection.checkOpen();
        return DelegatingResultSet.wrapResultSet(this.connection, this.get(s));
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getRS(this.databaseMetaData::getSchemas);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getSchemas(catalog, schemaPattern));
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.get(this.databaseMetaData::getSchemaTerm);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.get(this.databaseMetaData::getSearchStringEscape);
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.get(this.databaseMetaData::getSQLKeywords);
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return this.getI(this.databaseMetaData::getSQLStateType);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.get(this.databaseMetaData::getStringFunctions);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getSuperTables(catalog, schemaPattern, tableNamePattern));
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getSuperTypes(catalog, schemaPattern, typeNamePattern));
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.get(this.databaseMetaData::getSystemFunctions);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getTablePrivileges(catalog, schemaPattern, tableNamePattern));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getTables(catalog, schemaPattern, tableNamePattern, types));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.getRS(this.databaseMetaData::getTableTypes);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.get(this.databaseMetaData::getTimeDateFunctions);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.getRS(this.databaseMetaData::getTypeInfo);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getUDTs(catalog, schemaPattern, typeNamePattern, types));
    }

    @Override
    public String getURL() throws SQLException {
        return this.get(this.databaseMetaData::getURL);
    }

    @Override
    public String getUserName() throws SQLException {
        return this.get(this.databaseMetaData::getUserName);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.getRS(() -> this.databaseMetaData.getVersionColumns(catalog, schema, table));
    }

    protected void handleException(SQLException e) throws SQLException {
        if (this.connection == null) {
            throw e;
        }
        this.connection.handleException(e);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.insertsAreDetected(type));
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.getB(this.databaseMetaData::isCatalogAtStart);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getB(this.databaseMetaData::isReadOnly);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (iface.isAssignableFrom(this.databaseMetaData.getClass())) {
            return true;
        }
        return this.databaseMetaData.isWrapperFor(iface);
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.getB(this.databaseMetaData::locatorsUpdateCopy);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.getB(this.databaseMetaData::nullPlusNonNullIsNull);
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getB(this.databaseMetaData::nullsAreSortedAtEnd);
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getB(this.databaseMetaData::nullsAreSortedAtStart);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getB(this.databaseMetaData::nullsAreSortedHigh);
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.getB(this.databaseMetaData::nullsAreSortedLow);
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.othersDeletesAreVisible(type));
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.othersInsertsAreVisible(type));
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.othersUpdatesAreVisible(type));
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.ownDeletesAreVisible(type));
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.ownInsertsAreVisible(type));
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.ownUpdatesAreVisible(type));
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::storesLowerCaseIdentifiers);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::storesLowerCaseQuotedIdentifiers);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::storesMixedCaseIdentifiers);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::storesMixedCaseQuotedIdentifiers);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::storesUpperCaseIdentifiers);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::storesUpperCaseQuotedIdentifiers);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.getB(this.databaseMetaData::supportsAlterTableWithAddColumn);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.getB(this.databaseMetaData::supportsAlterTableWithDropColumn);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.getB(this.databaseMetaData::supportsANSI92EntryLevelSQL);
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.getB(this.databaseMetaData::supportsANSI92FullSQL);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.getB(this.databaseMetaData::supportsANSI92IntermediateSQL);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.getB(this.databaseMetaData::supportsBatchUpdates);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.getB(this.databaseMetaData::supportsCatalogsInDataManipulation);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsCatalogsInIndexDefinitions);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsCatalogsInPrivilegeDefinitions);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.getB(this.databaseMetaData::supportsCatalogsInProcedureCalls);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsCatalogsInTableDefinitions);
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.getB(this.databaseMetaData::supportsColumnAliasing);
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.getB(this.databaseMetaData::supportsConvert);
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.getB(() -> this.databaseMetaData.supportsConvert(fromType, toType));
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.getB(this.databaseMetaData::supportsCoreSQLGrammar);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.getB(this.databaseMetaData::supportsCorrelatedSubqueries);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsDataDefinitionAndDataManipulationTransactions);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.getB(this.databaseMetaData::supportsDataManipulationTransactionsOnly);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.getB(this.databaseMetaData::supportsDifferentTableCorrelationNames);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.getB(this.databaseMetaData::supportsExpressionsInOrderBy);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.getB(this.databaseMetaData::supportsExtendedSQLGrammar);
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.getB(this.databaseMetaData::supportsFullOuterJoins);
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.getB(this.databaseMetaData::supportsGetGeneratedKeys);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.getB(this.databaseMetaData::supportsGroupBy);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.getB(this.databaseMetaData::supportsGroupByBeyondSelect);
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.getB(this.databaseMetaData::supportsGroupByUnrelated);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.getB(this.databaseMetaData::supportsIntegrityEnhancementFacility);
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.getB(this.databaseMetaData::supportsLikeEscapeClause);
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.getB(this.databaseMetaData::supportsLimitedOuterJoins);
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.getB(this.databaseMetaData::supportsMinimumSQLGrammar);
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::supportsMixedCaseIdentifiers);
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getB(this.databaseMetaData::supportsMixedCaseQuotedIdentifiers);
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.getB(this.databaseMetaData::supportsMultipleOpenResults);
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.getB(this.databaseMetaData::supportsMultipleResultSets);
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsMultipleTransactions);
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return this.getB(this.databaseMetaData::supportsNamedParameters);
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.getB(this.databaseMetaData::supportsNonNullableColumns);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.getB(this.databaseMetaData::supportsOpenCursorsAcrossCommit);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.getB(this.databaseMetaData::supportsOpenCursorsAcrossRollback);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.getB(this.databaseMetaData::supportsOpenStatementsAcrossCommit);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.getB(this.databaseMetaData::supportsOpenStatementsAcrossRollback);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.getB(this.databaseMetaData::supportsOrderByUnrelated);
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.getB(this.databaseMetaData::supportsOuterJoins);
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.getB(this.databaseMetaData::supportsPositionedDelete);
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.getB(this.databaseMetaData::supportsPositionedUpdate);
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return this.getB(this.databaseMetaData::supportsRefCursors);
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.getB(() -> this.databaseMetaData.supportsResultSetConcurrency(type, concurrency));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return this.getB(() -> this.databaseMetaData.supportsResultSetHoldability(holdability));
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.supportsResultSetType(type));
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSavepoints);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSchemasInDataManipulation);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSchemasInIndexDefinitions);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSchemasInPrivilegeDefinitions);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSchemasInProcedureCalls);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSchemasInTableDefinitions);
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSelectForUpdate);
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return this.getB(this.databaseMetaData::supportsStatementPooling);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.getB(this.databaseMetaData::supportsStoredFunctionsUsingCallSyntax);
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.getB(this.databaseMetaData::supportsStoredProcedures);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSubqueriesInComparisons);
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSubqueriesInExists);
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSubqueriesInIns);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.getB(this.databaseMetaData::supportsSubqueriesInQuantifieds);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.getB(this.databaseMetaData::supportsTableCorrelationNames);
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.getB(() -> this.databaseMetaData.supportsTransactionIsolationLevel(level));
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.getB(this.databaseMetaData::supportsTransactions);
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.getB(this.databaseMetaData::supportsUnion);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.getB(this.databaseMetaData::supportsUnionAll);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.isAssignableFrom(this.databaseMetaData.getClass())) {
            return iface.cast(this.databaseMetaData);
        }
        return this.databaseMetaData.unwrap(iface);
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return this.getB(() -> this.databaseMetaData.updatesAreDetected(type));
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getB(this.databaseMetaData::usesLocalFilePerTable);
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.getB(this.databaseMetaData::usesLocalFiles);
    }
}

