/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.AbstractAegisIoImpl;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.AegisReader;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.aegis.xml.stax.ElementReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

public class AegisXMLStreamDataReader
extends AbstractAegisIoImpl
implements AegisReader<XMLStreamReader> {
    private static final Logger LOG = LogUtils.getL7dLogger(AegisXMLStreamDataReader.class);

    public AegisXMLStreamDataReader(AegisContext globalContext) {
        super(globalContext);
    }

    public AegisXMLStreamDataReader(AegisContext globalContext, Context context) {
        super(globalContext, context);
    }

    private void setupReaderPosition(XMLStreamReader reader) throws Exception {
        if (reader.getEventType() == 7) {
            while (1 != reader.getEventType()) {
                reader.nextTag();
            }
        }
        if (reader.getEventType() != 1) {
            Message message = new Message("STREAM_BAD_POSITION", LOG, new Object[0]);
            throw new DatabindingException(message.toString());
        }
    }

    @Override
    public Object read(XMLStreamReader reader) throws Exception {
        return this.read(reader, (AegisType)null);
    }

    @Override
    public Object read(XMLStreamReader reader, AegisType desiredType) throws Exception {
        this.setupReaderPosition(reader);
        ElementReader elReader = new ElementReader(reader);
        if (elReader.isXsiNil()) {
            elReader.readToEnd();
            return null;
        }
        AegisType type = TypeUtil.getReadTypeStandalone(reader, this.aegisContext, desiredType);
        if (type == null) {
            throw new DatabindingException(new Message("NO_MAPPING", LOG, new Object[0]));
        }
        return type.readObject(elReader, this.context);
    }

    public Object readFlatArray(XMLStreamReader input, ArrayType arrayType, QName concreteName) throws Exception {
        this.setupReaderPosition(input);
        ElementReader elReader = new ElementReader(input);
        return arrayType.readObject(elReader, concreteName, this.context, true);
    }
}

