/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.digest.MurmurHash2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MurmurHash2Test {
    static final byte[][] input = new byte[][]{{-19, 83, -60, -91, 59, 27, -67, -62, 82, 125, -61, -17, 83, 95, -82, 59}, {33, 101, 89, 78, -40, 18, -7, 5, -128, -23, 30, -19, -28, 86, -69}, {43, 2, -79, -48, 61, -50, 49, 61, -105, -60, -111, 13, -9, 23}, {-114, -89, -102, 2, -24, -71, 106, -38, -110, -83, -23, 45, 33}, {-87, 109, -22, 119, 6, -50, 27, -123, 72, 39, 76, -2}, {-20, -109, -96, 18, 96, -18, -56, 10, -59, -112, 98}, {85, 109, -109, 102, 20, 109, -33, 0, 88, -103}, {60, 114, 32, 31, -46, 89, 25, -37, -95}, {35, -88, -79, -121, 85, -9, -118, 75}, {-30, 66, 28, 45, -63, -28, 62}, {102, -90, -75, 90, 116, -39}, {-24, 118, -88, -112, 118}, {-21, 37, 63, -121}, {55, -96, -87}, {91, 93}, {126}, new byte[0]};
    static final int[] results32_standard = new int[]{-1769910349, 1214106298, 857588910, -962085073, -839688736, -639711284, 1671901578, -791428386, -1869464849, -1355431454, 1934849970, 913086707, -1672942039, 190928784, -1271887167, -325578150, 275646681};
    static final int[] results32_seed = new int[]{-651278018, -1957654469, -1019794821, 1223720606, -1973532050, 1469148660, -1555687649, 506567814, -1642462259, -1617478036, 764180469, -1410496687, 694618294, 620234635, 286987603, -1478878826, -25727888};
    static final long[] results64_standard = new long[]{5298426777973720025L, 2946101404357596377L, -8122803952233456635L, -6873856431612409101L, 2734604471859150110L, 3673482376089552831L, 5418034425446471969L, 5646857525615881435L, 469038636937432896L, -50679821058819835L, 9186944168760337255L, -9071693785927624567L, 7865757844850698346L, -7191575070520231006L, -2996326043242114542L, 4101988635730059279L, -7207201254813729732L};
    static final long[] results64_seed = new long[]{586225824753183099L, -528853823250750755L, 5425119473863375497L, -3931596921417641535L, -2091367290918293361L, 3099701235113069665L, 3998800552872373897L, -3257037914213588761L, -65816040879518649L, -1067910478091085737L, -2685372353099747275L, -5984396939344933618L, 439087983138344452L, 1565035130751738290L, 2936908094069335482L, 7587953037712641193L, -6237394598364664212L};
    static final String text = "Lorem ipsum dolor sit amet, consectetur adipisicing elit";

    MurmurHash2Test() {
    }

    @Test
    void testHash32ByteArrayInt() {
        for (int i = 0; i < input.length; ++i) {
            int hash = MurmurHash2.hash32((byte[])input[i], (int)input[i].length);
            if (hash == results32_standard[i]) continue;
            Assertions.fail((String)String.format("Unexpected hash32 result for example %d: 0x%08x instead of 0x%08x", i, hash, results32_standard[i]));
        }
    }

    @Test
    void testHash32ByteArrayIntInt() {
        for (int i = 0; i < input.length; ++i) {
            int hash = MurmurHash2.hash32((byte[])input[i], (int)input[i].length, (int)1907660109);
            if (hash == results32_seed[i]) continue;
            Assertions.fail((String)String.format("Unexpected hash32 result for example %d: 0x%08x instead of 0x%08x", i, hash, results32_seed[i]));
        }
    }

    @Test
    void testHash32String() {
        int hash = MurmurHash2.hash32((String)text);
        Assertions.assertEquals((int)-1279305346, (int)hash);
    }

    @Test
    void testHash32StringIntInt() {
        int hash = MurmurHash2.hash32((String)text, (int)2, (int)(text.length() - 4));
        Assertions.assertEquals((int)1298558352, (int)hash);
    }

    @Test
    void testHash64ByteArrayInt() {
        for (int i = 0; i < input.length; ++i) {
            long hash = MurmurHash2.hash64((byte[])input[i], (int)input[i].length);
            if (hash == results64_standard[i]) continue;
            Assertions.fail((String)String.format("Unexpected hash64 result for example %d: 0x%016x instead of 0x%016x", i, hash, results64_standard[i]));
        }
    }

    @Test
    void testHash64ByteArrayIntInt() {
        for (int i = 0; i < input.length; ++i) {
            long hash = MurmurHash2.hash64((byte[])input[i], (int)input[i].length, (int)877469532);
            if (hash == results64_seed[i]) continue;
            Assertions.fail((String)String.format("Unexpected hash64 result for example %d: 0x%016x instead of 0x%016x", i, hash, results64_seed[i]));
        }
    }

    @Test
    void testHash64String() {
        long hash = MurmurHash2.hash64((String)text);
        Assertions.assertEquals((long)657772668215276129L, (long)hash);
    }

    @Test
    void testHash64StringIntInt() {
        long hash = MurmurHash2.hash64((String)text, (int)2, (int)(text.length() - 4));
        Assertions.assertEquals((long)-6290630081659697758L, (long)hash);
    }
}

