/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.valueholder;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PersistentDescriptorFactory;
import org.apache.cayenne.reflect.valueholder.ValueHolderListProperty;
import org.apache.cayenne.reflect.valueholder.ValueHolderMapProperty;
import org.apache.cayenne.reflect.valueholder.ValueHolderProperty;
import org.apache.cayenne.reflect.valueholder.ValueHolderSetProperty;

public class ValueHolderDescriptorFactory
extends PersistentDescriptorFactory {
    public ValueHolderDescriptorFactory(ClassDescriptorMap descriptorMap) {
        super(descriptorMap);
    }

    protected void createToManyCollectionProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), List.class);
        descriptor.addDeclaredProperty(new ValueHolderListProperty(descriptor, targetDescriptor, accessor, reverseName));
    }

    protected void createToManyListProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), List.class);
        descriptor.addDeclaredProperty(new ValueHolderListProperty(descriptor, targetDescriptor, accessor, reverseName));
    }

    protected void createToManyMapProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), Map.class);
        Accessor mapKeyAccessor = this.createMapKeyAccessor(relationship, targetDescriptor);
        ValueHolderMapProperty property = new ValueHolderMapProperty(descriptor, targetDescriptor, accessor, reverseName, mapKeyAccessor);
        descriptor.addDeclaredProperty(property);
    }

    protected void createToManySetProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), Set.class);
        descriptor.addDeclaredProperty(new ValueHolderSetProperty(descriptor, targetDescriptor, accessor, reverseName));
    }

    protected void createToOneProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), ValueHolder.class);
        ValueHolderProperty property = new ValueHolderProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }
}

