/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DbAdapterFactory;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationException;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class ModelerDbAdapter
extends AutoAdapter {
    protected String adapterClassName;

    public ModelerDbAdapter(DataSource dataSource) {
        this(null, dataSource);
    }

    public ModelerDbAdapter(String adapterClassName, DataSource dataSource) {
        super(dataSource);
        this.adapterClassName = adapterClassName;
    }

    public void validate() throws ValidationException {
        ValidationFailure failure;
        if (this.adapterClassName != null && (failure = BeanValidationFailure.validateJavaClassName((Object)((Object)this), (String)"adapterClassName", (String)this.adapterClassName)) != null) {
            ValidationResult result = new ValidationResult();
            result.addFailure(failure);
            throw new ValidationException(failure.getDescription(), result);
        }
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    protected DbAdapterFactory createDefaultFactory() {
        return new AdapterFactory();
    }

    class AdapterFactory
    implements DbAdapterFactory {
        AdapterFactory() {
        }

        public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
            if (ModelerDbAdapter.this.adapterClassName == null) {
                return AutoAdapter.getDefaultFactory().createAdapter(md);
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                return (DbAdapter)Class.forName(ModelerDbAdapter.this.adapterClassName, true, loader).newInstance();
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Can't load DbAdapter class: " + ModelerDbAdapter.this.adapterClassName);
            }
        }
    }
}

