/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.ProxyIterator;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.GraphUtils;

public class FilterArcIterator
extends ProxyIterator
implements ArcIterator {
    private Predicate acceptOrigin;
    private Predicate acceptDestination;
    private Predicate acceptArc;
    private Object nextArc;
    private Object nextOrigin;
    private Object nextDst;
    private boolean nextObjectSet = false;

    public FilterArcIterator(ArcIterator iterator, Predicate acceptOrigin, Predicate acceptDestination, Predicate acceptArc) {
        super((Iterator)iterator);
        this.acceptOrigin = acceptOrigin;
        this.acceptDestination = acceptDestination;
        this.acceptArc = acceptArc;
        this.nextOrigin = iterator.getOrigin();
        if (!acceptOrigin.evaluate(this.nextOrigin)) {
            this.nextOrigin = null;
        }
        this.nextDst = iterator.getDestination();
        if (!acceptDestination.evaluate(this.nextDst)) {
            this.nextDst = null;
        }
    }

    public FilterArcIterator(ArcIterator iterator, Predicate acceptVertex, Predicate acceptArc) {
        this(iterator, acceptVertex, acceptVertex, acceptArc);
    }

    public FilterArcIterator(ArcIterator iterator, Predicate acceptVertex) {
        this(iterator, acceptVertex, acceptVertex, GraphUtils.TRUE_PREDICATE);
    }

    public Object getOrigin() {
        return this.nextOrigin;
    }

    public Object getDestination() {
        return this.nextDst;
    }

    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    public Object next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        this.nextObjectSet = false;
        return this.nextArc;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean setNextObject() {
        ArcIterator iterator = (ArcIterator)this.getIterator();
        while (iterator.hasNext()) {
            Object arc = iterator.next();
            Object origin = iterator.getOrigin();
            Object dst = iterator.getDestination();
            if (!this.acceptOrigin.evaluate(origin) || !this.acceptArc.evaluate(arc) || !this.acceptDestination.evaluate(dst)) continue;
            this.nextArc = arc;
            this.nextOrigin = origin;
            this.nextDst = dst;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }
}

