/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ZipUnzipFile;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.ScriptRunner;
import org.hsqldb.persist.TextCache;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptWriterBase;

public class Log {
    private HsqlDatabaseProperties properties;
    private String fileName;
    private Database database;
    private FileAccess fa;
    private ScriptWriterBase dbLogWriter;
    private String scriptFileName;
    private String logFileName;
    private boolean filesReadOnly;
    private long maxLogSize;
    private int writeDelay;
    private int scriptFormat;
    private DataFileCache cache;
    private HashMap textCacheList = new HashMap();

    Log(Database database) throws HsqlException {
        this.database = database;
        this.fa = database.getFileAccess();
        this.fileName = database.getPath();
        this.properties = database.getProperties();
    }

    void open() throws HsqlException {
        int n = this.properties.getIntegerProperty("hsqldb.log_size", 0);
        this.maxLogSize = n * 1024 * 1024;
        this.scriptFormat = this.properties.getIntegerProperty("hsqldb.script_format", 0);
        this.writeDelay = this.properties.getDefaultWriteDelay();
        this.filesReadOnly = this.database.isFilesReadOnly();
        this.scriptFileName = this.fileName + ".script";
        this.logFileName = this.fileName + ".log";
        int n2 = this.properties.getDBModified();
        switch (n2) {
            case 1: {
                this.deleteNewAndOldFiles();
                this.restoreBackup();
                this.processScript();
                this.processDataFile();
                this.processLog();
                this.close(false);
                if (this.cache != null) {
                    this.cache.open(this.filesReadOnly);
                }
                this.reopenAllTextCaches();
                break;
            }
            case 2: {
                this.processNewFiles();
            }
            case 0: {
                this.processScript();
                if (!this.isAnyCacheModified()) break;
                this.close(false);
                if (this.cache != null) {
                    this.cache.open(this.filesReadOnly);
                }
                this.reopenAllTextCaches();
            }
        }
        this.openLog();
        if (!this.filesReadOnly) {
            this.properties.setDBModified(1);
        }
    }

    void close(boolean bl) throws HsqlException {
        this.closeLog();
        this.deleteNewAndOldFiles();
        this.writeScript(bl);
        this.closeAllTextCaches(bl);
        if (this.cache != null) {
            this.cache.close(!bl);
        }
        this.properties.setProperty("version", "1.8.0");
        this.properties.setProperty("hsqldb.compatible_version", "1.8.0");
        this.properties.setDBModified(2);
        if (this.cache != null) {
            this.cache.postClose(!bl);
        }
        try {
            this.fa.renameElement(this.scriptFileName + ".new", this.scriptFileName);
            this.fa.removeElement(this.logFileName);
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException);
        }
        this.properties.setDBModified(0);
    }

    void processNewFiles() throws HsqlException {
        try {
            if (this.fa.isStreamElement(this.fileName + ".data")) {
                ZipUnzipFile.compressFile(this.fileName + ".data", this.fileName + ".backup", this.database.getFileAccess());
            } else {
                this.fa.removeElement(this.fileName + ".backup");
            }
            this.fa.renameElement(this.scriptFileName + ".new", this.scriptFileName);
            this.fa.removeElement(this.logFileName);
            this.properties.setDBModified(0);
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException);
        }
    }

    void shutdown() throws HsqlException {
        this.synchLog();
        if (this.cache != null) {
            this.cache.close(false);
        }
        this.closeAllTextCaches(false);
        this.closeLog();
    }

    void deleteNewAndOldFiles() {
        try {
            this.fa.removeElement(this.fileName + ".data" + ".old");
            this.fa.removeElement(this.fileName + ".data" + ".new");
            this.fa.removeElement(this.fileName + ".backup" + ".new");
            this.fa.removeElement(this.scriptFileName + ".new");
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException);
        }
    }

    boolean isAnyCacheModified() {
        if (this.cache != null && this.cache.isFileModified()) {
            return true;
        }
        return this.isAnyTextCacheModified();
    }

    void checkpoint(boolean bl) throws HsqlException {
        if (this.filesReadOnly) {
            return;
        }
        this.closeLog();
        this.closeAllTextCaches(false);
        this.reopenAllTextCaches();
        if (this.cache != null) {
            if (this.forceDefrag()) {
                bl = true;
            }
            if (bl) {
                try {
                    this.cache.defrag();
                }
                catch (Exception exception) {
                    this.cache.close(true);
                    this.cache.postClose(true);
                    this.cache.open(false);
                }
            } else {
                this.cache.close(true);
                this.cache.postClose(true);
                this.cache.open(false);
            }
        }
        this.writeScript(false);
        try {
            this.fa.renameElement(this.scriptFileName + ".new", this.scriptFileName);
            this.fa.removeElement(this.logFileName);
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException);
        }
        this.properties.setDBModified(1);
        if (this.dbLogWriter == null) {
            return;
        }
        this.openLog();
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        try {
            for (int i = 0; i < sessionArray.length; ++i) {
                Session session = sessionArray[i];
                if (session.isAutoCommit()) continue;
                this.dbLogWriter.writeLogStatement(session, session.getAutoCommitStatement());
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.logFileName);
        }
    }

    boolean forceDefrag() {
        long l = this.properties.getIntegerProperty("hsqldb.defrag_limit", 200);
        long l2 = l * 1024L * 1024L;
        return this.cache.freeBlocks.getLostBlocksSize() > l2;
    }

    boolean hasCache() {
        return this.cache != null;
    }

    DataFileCache getCache() throws HsqlException {
        if (this.cache == null) {
            this.cache = new DataFileCache(this.database, this.fileName);
            this.cache.open(this.filesReadOnly);
        }
        return this.cache;
    }

    int getLogSize() {
        return (int)(this.maxLogSize / 11288576L);
    }

    void setLogSize(int n) {
        this.properties.setProperty("hsqldb.log_size", n);
        this.maxLogSize = n * 1024 * 1024;
    }

    int getScriptType() {
        return this.scriptFormat;
    }

    void setScriptType(int n) throws HsqlException {
        if (this.database.isStoredFileAccess()) {
            return;
        }
        boolean bl = this.scriptFormat != n;
        this.scriptFormat = n;
        this.properties.setProperty("hsqldb.script_format", this.scriptFormat);
        if (bl) {
            this.checkpoint(false);
        }
    }

    int getWriteDelay() {
        return this.writeDelay;
    }

    void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.dbLogWriter != null) {
            this.synchLog();
            this.dbLogWriter.setWriteDelay(n);
        }
    }

    void writeStatement(Session session, String string) throws HsqlException {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            this.dbLogWriter.writeLogStatement(session, string);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void writeInsertStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        try {
            this.dbLogWriter.writeInsertStatement(session, table, objectArray);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void writeDeleteStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        try {
            this.dbLogWriter.writeDeleteStatement(session, table, objectArray);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void writeSequenceStatement(Session session, NumberSequence numberSequence) throws HsqlException {
        try {
            this.dbLogWriter.writeSequenceStatement(session, numberSequence);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void writeCommitStatement(Session session) throws HsqlException {
        try {
            this.dbLogWriter.writeCommitStatement(session);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void synchLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.sync();
        }
    }

    private void openLog() throws HsqlException {
        if (this.filesReadOnly) {
            return;
        }
        try {
            this.dbLogWriter = ScriptWriterBase.newScriptWriter(this.database, this.logFileName, false, false, 0);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            this.dbLogWriter.start();
        }
        catch (Exception exception) {
            throw Trace.error(29, this.logFileName);
        }
    }

    private synchronized void closeLog() throws HsqlException {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.close();
        }
    }

    private void writeScript(boolean bl) throws HsqlException {
        String string = this.scriptFileName + ".new";
        try {
            if (this.fa.isStreamElement(string)) {
                this.fa.removeElement(string);
            }
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException);
        }
        ScriptWriterBase scriptWriterBase = ScriptWriterBase.newScriptWriter(this.database, this.scriptFileName + ".new", bl, true, this.scriptFormat);
        scriptWriterBase.writeAll();
        scriptWriterBase.close();
    }

    private void processScript() throws HsqlException {
        ScriptReaderBase scriptReaderBase = null;
        try {
            if (this.database.isFilesInJar() || this.fa.isStreamElement(this.scriptFileName)) {
                scriptReaderBase = ScriptReaderBase.newScriptReader(this.database, this.scriptFileName, this.scriptFormat);
                scriptReaderBase.readAll(this.database.sessionManager.getSysSession(null, true));
                scriptReaderBase.close();
            }
        }
        catch (Throwable throwable) {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
                if (this.cache != null) {
                    this.cache.close(false);
                }
                this.closeAllTextCaches(false);
            }
            this.database.logger.appLog.logContext(throwable);
            if (throwable instanceof HsqlException) {
                throw (HsqlException)throwable;
            }
            if (throwable instanceof IOException) {
                throw Trace.error(29, throwable.getMessage());
            }
            if (throwable instanceof OutOfMemoryError) {
                throw Trace.error(72);
            }
            throw Trace.error(40, throwable.getMessage());
        }
    }

    private void processDataFile() throws HsqlException {
        long l;
        if (this.cache == null || this.filesReadOnly || this.database.isStoredFileAccess() || !this.fa.isStreamElement(this.logFileName)) {
            return;
        }
        File file = new File(this.logFileName);
        long l2 = file.length();
        if (l2 + (l = this.cache.getFileFreePos()) > this.cache.maxDataFileSize) {
            this.checkpoint(true);
        }
    }

    private void processLog() throws HsqlException {
        if (!this.database.isFilesInJar() && this.fa.isStreamElement(this.logFileName)) {
            ScriptRunner.runScript(this.database, this.logFileName, 0);
        }
    }

    private void restoreBackup() throws HsqlException {
        DataFileCache.deleteOrResetFreePos(this.database, this.fileName + ".data");
        try {
            ZipUnzipFile.decompressFile(this.fileName + ".backup", this.fileName + ".data", this.database.getFileAccess());
        }
        catch (Exception exception) {
            throw Trace.error(29, 115, new Object[]{this.fileName + ".backup", exception.getMessage()});
        }
    }

    DataFileCache openTextCache(Table table, String string, boolean bl, boolean bl2) throws HsqlException {
        Object object;
        this.closeTextCache(table);
        if (!this.properties.isPropertyTrue("textdb.allow_full_path")) {
            if (string.indexOf("..") != -1) {
                throw Trace.error(33, string);
            }
            object = new File(new File(this.database.getPath() + ".properties").getAbsolutePath()).getParent();
            if (object != null) {
                string = (String)object + File.separator + string;
            }
        }
        object = bl2 ? new TextCache(table, string) : new TextCache(table, string);
        ((TextCache)object).open(bl || this.filesReadOnly);
        this.textCacheList.put(table.getName(), object);
        return object;
    }

    void closeTextCache(Table table) throws HsqlException {
        TextCache textCache = (TextCache)this.textCacheList.remove(table.getName());
        if (textCache != null) {
            textCache.close(true);
        }
    }

    private void closeAllTextCaches(boolean bl) throws HsqlException {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                ((TextCache)iterator.next()).purge();
                continue;
            }
            ((TextCache)iterator.next()).close(true);
        }
    }

    private void reopenAllTextCaches() throws HsqlException {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            ((TextCache)iterator.next()).reopen();
        }
    }

    private boolean isAnyTextCacheModified() {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            if (!((TextCache)iterator.next()).isFileModified()) continue;
            return true;
        }
        return false;
    }
}

