/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.rop.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.configuration.rop.client.CayenneClientModuleProvider;
import org.apache.cayenne.configuration.rop.client.ClientModule;
import org.apache.cayenne.configuration.rop.client.ClientRuntime;
import org.apache.cayenne.configuration.rop.client.LocalClientServerChannelProvider;
import org.apache.cayenne.configuration.rop.client.LocalConnectionProvider;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.ModuleLoader;
import org.apache.cayenne.remote.ClientConnection;

public class ClientRuntimeBuilder {
    private List<Module> modules = new ArrayList<Module>();
    private boolean autoLoadModules = true;
    private boolean local = false;
    Injector serverInjector;
    private Map<String, String> properties = null;

    ClientRuntimeBuilder() {
    }

    public ClientRuntimeBuilder disableModulesAutoLoading() {
        this.autoLoadModules = false;
        return this;
    }

    public ClientRuntimeBuilder addModule(Module module) {
        this.modules.add(module);
        return this;
    }

    public ClientRuntimeBuilder addModules(Collection<Module> modules) {
        this.modules.addAll(modules);
        return this;
    }

    public ClientRuntimeBuilder properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ClientRuntimeBuilder local(Injector serverInjector) {
        this.local = true;
        this.serverInjector = serverInjector;
        return this;
    }

    public ClientRuntime build() {
        ArrayList<Module> allModules = new ArrayList<Module>();
        allModules.addAll(this.autoLoadModules ? this.autoLoadedModules() : this.defaultModules());
        allModules.addAll(this.modules);
        allModules.addAll(this.builderModules());
        return new ClientRuntime(allModules);
    }

    private Collection<? extends Module> autoLoadedModules() {
        return new ModuleLoader().load(CayenneClientModuleProvider.class);
    }

    private Collection<? extends Module> defaultModules() {
        return Collections.singleton(new ClientModule());
    }

    private Collection<? extends Module> builderModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.properties != null) {
            modules.add(binder -> ServerModule.contributeProperties((Binder)binder).putAll(this.properties));
        }
        if (this.local) {
            modules.add(binder -> {
                binder.bind(Key.get(DataChannel.class, (String)"client-server-channel")).toProviderInstance((Provider)new LocalClientServerChannelProvider(this.serverInjector));
                binder.bind(ClientConnection.class).toProviderInstance((Provider)new LocalConnectionProvider());
            });
        }
        return modules;
    }
}

