/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.util.CayenneAction;

public abstract class DBConnectionAwareAction
extends CayenneAction {
    public DBConnectionAwareAction(String name, Application application) {
        super(name, application);
    }

    protected DBConnectionInfo getConnectionInfo(String title) {
        DBConnectionInfo connectionInfo;
        if (this.datamapPrefNotExist()) {
            DataSourceWizard connectWizard = this.getDataSourceWizard(title);
            if (connectWizard == null) {
                return null;
            }
            connectionInfo = connectWizard.getConnectionInfo();
            this.saveConnectionInfo(connectWizard);
        } else {
            connectionInfo = this.getConnectionInfoFromPreferences();
        }
        return connectionInfo;
    }

    protected DataSourceWizard getDataSourceWizard(String title, String[] buttons) {
        DataSourceWizard connectWizard = new DataSourceWizard(this.getProjectController(), title, buttons);
        if (!connectWizard.startupAction()) {
            return null;
        }
        return connectWizard;
    }

    protected DataSourceWizard getDataSourceWizard(String title) {
        DataSourceWizard connectWizard = new DataSourceWizard(this.getProjectController(), title);
        if (!connectWizard.startupAction()) {
            return null;
        }
        return connectWizard;
    }

    protected boolean datamapPrefNotExist() {
        Preferences dataMapPreference = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap()).getCurrentPreference();
        return dataMapPreference == null || dataMapPreference.get("url", null) == null;
    }

    protected DBConnectionInfo getConnectionInfoFromPreferences() {
        DBConnectionInfo connectionInfo = new DBConnectionInfo();
        DataMapDefaults dataMapDefaults = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap());
        connectionInfo.setDbAdapter(dataMapDefaults.getCurrentPreference().get("dbAdapter", null));
        connectionInfo.setUrl(dataMapDefaults.getCurrentPreference().get("url", null));
        connectionInfo.setUserName(dataMapDefaults.getCurrentPreference().get("userName", null));
        connectionInfo.setPassword(dataMapDefaults.getCurrentPreference().get("password", null));
        connectionInfo.setJdbcDriver(dataMapDefaults.getCurrentPreference().get("jdbcDriver", null));
        return connectionInfo;
    }

    protected void saveConnectionInfo(DataSourceWizard connectWizard) {
        DataMapDefaults dataMapDefaults = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap());
        String dbAdapter = connectWizard.getConnectionInfo().getDbAdapter();
        if (dbAdapter != null) {
            dataMapDefaults.getCurrentPreference().put("dbAdapter", dbAdapter);
        } else {
            dataMapDefaults.getCurrentPreference().remove("dbAdapter");
        }
        dataMapDefaults.getCurrentPreference().put("url", connectWizard.getConnectionInfo().getUrl());
        dataMapDefaults.getCurrentPreference().put("userName", connectWizard.getConnectionInfo().getUserName());
        dataMapDefaults.getCurrentPreference().put("password", connectWizard.getConnectionInfo().getPassword());
        dataMapDefaults.getCurrentPreference().put("jdbcDriver", connectWizard.getConnectionInfo().getJdbcDriver());
    }
}

