/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.sqlserver.SQLServerAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class SQLServerSniffer
implements DbAdapterDetector {
    protected AdhocObjectFactory objectFactory;

    public SQLServerSniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("MICROSOFT SQL SERVER")) {
            return null;
        }
        SQLServerAdapter adapter = this.objectFactory.newInstance(SQLServerAdapter.class, SQLServerAdapter.class.getName());
        adapter.setVersion(md.getDatabaseMajorVersion());
        boolean generatedKeys = false;
        try {
            generatedKeys = md.supportsGetGeneratedKeys();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        adapter.setSupportsGeneratedKeys(generatedKeys);
        return adapter;
    }
}

