/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.AzureBlobRequestSigner;
import org.jclouds.azureblob.blobstore.AzureBlobStore;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;

public class AzureBlobStoreContextModule
extends AbstractModule {
    protected void configure() {
        this.bind(ConsistencyModel.class).toInstance((Object)ConsistencyModel.STRICT);
        this.bind(BlobStore.class).to(AzureBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobRequestSigner.class).to(AzureBlobRequestSigner.class);
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, PublicAccess> containerAcls(final AzureBlobClient client) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, PublicAccess>(){

            public PublicAccess load(String container) {
                return client.getPublicAccessForContainer(container);
            }

            public String toString() {
                return "getPublicAccessForContainer()";
            }
        });
    }
}

