/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Module;
import java.util.Map;
import java.util.Properties;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.persist.DeserializingJcloudsRenamesProvider;
import org.apache.brooklyn.location.jclouds.BlobStoreContextFactory;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.encryption.bouncycastle.config.BouncyCastleCryptoModule;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreContextFactoryImpl
implements BlobStoreContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BlobStoreContextFactoryImpl.class);
    public static final BlobStoreContextFactory INSTANCE = new BlobStoreContextFactoryImpl();

    protected BlobStoreContextFactoryImpl() {
    }

    @Override
    public BlobStoreContext newBlobStoreContext(Location location) {
        String rawProvider = (String)Preconditions.checkNotNull((Object)location.getConfig(LocationConfigKeys.CLOUD_PROVIDER), (Object)"provider must not be null");
        String provider = DeserializingJcloudsRenamesProvider.INSTANCE.applyJcloudsRenames(rawProvider);
        String identity = (String)Preconditions.checkNotNull((Object)location.getConfig(LocationConfigKeys.ACCESS_IDENTITY), (Object)"identity must not be null");
        String credential = (String)Preconditions.checkNotNull((Object)location.getConfig(LocationConfigKeys.ACCESS_CREDENTIAL), (Object)"credential must not be null");
        String endpoint = (String)location.getConfig(CloudLocationConfig.CLOUD_ENDPOINT);
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.strip-expect-header", "true");
        Map extra = Maps.filterKeys((Map)((LocationInternal)location).config().getBag().getAllConfig(), (Predicate)Predicates.containsPattern((String)"^jclouds\\."));
        if (extra.size() > 0) {
            LOG.debug("Configuring custom jclouds property overrides for {}: {}", (Object)provider, (Object)Sanitizer.sanitize((Map)extra));
        }
        overrides.putAll((Map<?, ?>)Maps.filterValues((Map)extra, (Predicate)Predicates.notNull()));
        ContextBuilder contextBuilder = ContextBuilder.newBuilder((String)provider).credentials(identity, credential);
        contextBuilder.modules((Iterable)MutableList.copyOf(this.getCommonModules()));
        if (!Strings.isBlank((CharSequence)endpoint)) {
            contextBuilder.endpoint(endpoint);
        }
        contextBuilder.overrides(overrides);
        BlobStoreContext context = (BlobStoreContext)contextBuilder.buildView(BlobStoreContext.class);
        return context;
    }

    protected ImmutableSet<Module> getCommonModules() {
        return ImmutableSet.of((Object)new SshjSshClientModule(), (Object)new SLF4JLoggingModule(), (Object)new BouncyCastleCryptoModule());
    }
}

