/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.osgi;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.LineReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

@Beta
public class BundleMaker {
    static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private Framework framework;
    private ResourceUtils resources;
    private Class<?> optionalDefaultClassForLoading;

    public BundleMaker(@Nonnull ResourceUtils resources) {
        this.resources = resources;
    }

    public BundleMaker(@Nonnull Framework f, @Nonnull ResourceUtils resources) {
        this.framework = f;
        this.resources = resources;
    }

    public BundleMaker(@Nonnull ManagementContext mgmt) {
        this(((OsgiManager)((ManagementContextInternal)mgmt).getOsgiManager().get()).getFramework(), ResourceUtils.create());
    }

    public void setDefaultClassForLoading(Class<?> optionalDefaultClassForLoading) {
        this.optionalDefaultClassForLoading = optionalDefaultClassForLoading;
    }

    public File createJarFromClasspathDir(String path) {
        Object min;
        File f = Os.newTempFile((String)path, (String)"zip");
        JarOutputStream zout = null;
        try {
            if (Urls.getProtocol((String)path) == null) {
                if (!(path = Os.tidyPath((String)path)).startsWith("/") && this.optionalDefaultClassForLoading != null) {
                    path = "/" + this.optionalDefaultClassForLoading.getPackage().getName().replace('.', '/') + "/" + path;
                }
                path = "classpath:" + path;
            }
            if (this.resources.doesUrlExist(Urls.mergePaths((String[])new String[]{path, MANIFEST_PATH}))) {
                min = this.resources.getResourceFromUrl(Urls.mergePaths((String[])new String[]{path, MANIFEST_PATH}));
                zout = new JarOutputStream((OutputStream)new FileOutputStream(f), new Manifest((InputStream)min));
                this.addUrlItemRecursively(zout, path, path, (Predicate<? super String>)Predicates.not((Predicate)Predicates.equalTo((Object)MANIFEST_PATH)));
            } else {
                zout = new JarOutputStream(new FileOutputStream(f));
                this.addUrlItemRecursively(zout, path, path, (Predicate<? super String>)Predicates.alwaysTrue());
            }
            min = f;
        }
        catch (Exception e) {
            try {
                throw Exceptions.propagateAnnotated((String)("Error creating ZIP from classpath spec " + path), (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(zout);
                throw throwable;
            }
        }
        Streams.closeQuietly((Closeable)zout);
        return min;
    }

    public boolean hasOsgiManifest(File f) {
        Manifest mf = this.getManifest(f);
        if (mf == null) {
            return false;
        }
        String sn = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        return Strings.isNonBlank((CharSequence)sn);
    }

    public Manifest getManifest(File f) {
        Manifest manifest;
        JarFile jf = null;
        try {
            jf = new JarFile(f);
            manifest = jf.getManifest();
        }
        catch (IOException e) {
            try {
                throw Exceptions.propagateAnnotated((String)("Unable to read " + f + " when looking for manifest"), (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(jf);
                throw throwable;
            }
        }
        Streams.closeQuietly((Closeable)jf);
        return manifest;
    }

    public File copyAddingManifest(File f, Map<String, String> attrs) {
        return this.copyAddingManifest(f, this.manifestOf(attrs));
    }

    protected Manifest manifestOf(Map<String, String> attrs) {
        Manifest mf = new Manifest();
        for (Map.Entry<String, String> attr : attrs.entrySet()) {
            mf.getMainAttributes().putValue(attr.getKey(), attr.getValue());
        }
        return mf;
    }

    public File copyAddingManifest(File f, Manifest mf) {
        File f2 = Os.newTempFile((String)f.getName(), (String)"zip");
        JarOutputStream zout = null;
        Closeable zf = null;
        try {
            zout = new JarOutputStream((OutputStream)new FileOutputStream(f2), mf);
            this.writeZipEntriesFromFile(zout, f, (Predicate<? super String>)Predicates.not((Predicate)Predicates.equalTo((Object)MANIFEST_PATH)));
        }
        catch (IOException e) {
            try {
                throw Exceptions.propagateAnnotated((String)("Unable to read " + f + " when looking for manifest"), (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(zf);
                Streams.closeQuietly(zout);
                throw throwable;
            }
        }
        Streams.closeQuietly(zf);
        Streams.closeQuietly((Closeable)zout);
        return f2;
    }

    public File copyAdding(File f, Map<ZipEntry, ? extends InputStream> entries) {
        return this.copyAdding(f, entries, (Predicate<? super String>)Predicates.alwaysTrue(), false);
    }

    public File copyAddingAtEnd(File f, Map<ZipEntry, ? extends InputStream> entries) {
        return this.copyAdding(f, entries, (Predicate<? super String>)Predicates.alwaysTrue(), true);
    }

    public File copyRemoving(File f, final Set<String> itemsToRemove) {
        return this.copyRemoving(f, (Predicate<? super String>)new Predicate<String>(){

            public boolean apply(String input) {
                return !itemsToRemove.contains(input);
            }
        });
    }

    public File copyRemoving(File f, Predicate<? super String> filter) {
        return this.copyAdding(f, (Map<ZipEntry, ? extends InputStream>)MutableMap.of(), filter, true);
    }

    private File copyAdding(File f, Map<ZipEntry, ? extends InputStream> entries, final Predicate<? super String> filter, boolean addAtStart) {
        File file;
        MutableSet entryNames = MutableSet.of();
        for (ZipEntry ze : entries.keySet()) {
            entryNames.add(ze.getName());
        }
        File f2 = Os.newTempFile((String)f.getName(), (String)"zip");
        ZipOutputStream zout = null;
        Closeable zf = null;
        try {
            zout = new ZipOutputStream(new FileOutputStream(f2));
            if (addAtStart) {
                this.writeZipEntries(zout, entries);
            }
            this.writeZipEntriesFromFile(zout, f, (Predicate<? super String>)new Predicate<String>((Set)entryNames){
                final /* synthetic */ Set val$entryNames;
                {
                    this.val$entryNames = set;
                }

                public boolean apply(String input) {
                    return filter.apply((Object)input) && !this.val$entryNames.contains(input);
                }
            });
            if (!addAtStart) {
                this.writeZipEntries(zout, entries);
            }
            file = f2;
        }
        catch (IOException e) {
            try {
                throw Exceptions.propagateAnnotated((String)("Unable to read " + f + " when looking for manifest"), (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(zf);
                Streams.closeQuietly(zout);
                throw throwable;
            }
        }
        Streams.closeQuietly(zf);
        Streams.closeQuietly((Closeable)zout);
        return file;
    }

    private void writeZipEntries(ZipOutputStream zout, Map<ZipEntry, ? extends InputStream> entries) throws IOException {
        for (Map.Entry<ZipEntry, ? extends InputStream> ze : entries.entrySet()) {
            zout.putNextEntry(ze.getKey());
            InputStream zin = ze.getValue();
            Streams.copy((InputStream)zin, (OutputStream)zout);
            Streams.closeQuietly((Closeable)zin);
            zout.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntriesFromFile(ZipOutputStream zout, File existingZip, Predicate<? super String> filter) throws IOException {
        ZipFile zf = new ZipFile(existingZip);
        try {
            Enumeration<? extends ZipEntry> zfe = zf.entries();
            while (zfe.hasMoreElements()) {
                ZipEntry ze = zfe.nextElement();
                ZipEntry newZipEntry = new ZipEntry(ze.getName());
                if (!filter.apply((Object)ze.getName())) continue;
                zout.putNextEntry(newZipEntry);
                InputStream zin = zf.getInputStream(ze);
                Streams.copy((InputStream)zin, (OutputStream)zout);
                Streams.closeQuietly((Closeable)zin);
                zout.closeEntry();
            }
        }
        finally {
            Streams.closeQuietly((Closeable)zf);
        }
    }

    @Deprecated
    public Bundle installBundle(File f, boolean start) {
        try {
            Bundle b = Osgis.install(this.framework, "file://" + f.getAbsolutePath());
            if (start) {
                b.start();
            }
            return b;
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)("Error starting bundle from " + f), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addUrlItemRecursively(ZipOutputStream zout, String root, String item, Predicate<? super String> filter) throws IOException {
        InputStream itemFound = null;
        try {
            itemFound = this.resources.getResourceFromUrl(item);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return false;
        }
        try {
            if (this.isKnownNotToBeADirectoryListing(item) || !this.addUrlDirToZipRecursively(zout, root, item, itemFound, filter)) {
                this.addUrlFileToZip(zout, root, item, filter);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Streams.closeQuietly((Closeable)itemFound);
        }
    }

    private boolean isKnownNotToBeADirectoryListing(String item) {
        try {
            URL url = new URL(item);
            if (url.getProtocol().equals("file")) {
                return !new File(url.getFile()).isDirectory();
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
        }
        return false;
    }

    private boolean addUrlDirToZipRecursively(ZipOutputStream zout, String root, String item, InputStream itemFound, Predicate<? super String> filter) throws IOException {
        String line;
        LineReader lr = new LineReader((Readable)new InputStreamReader(itemFound));
        boolean readSubdirFile = false;
        while (true) {
            if ((line = lr.readLine()) == null) {
                return readSubdirFile;
            }
            boolean isFile = this.addUrlItemRecursively(zout, root, item + "/" + line, filter);
            if (!isFile) break;
            readSubdirFile = true;
        }
        if (!readSubdirFile) {
            return false;
        }
        throw new IllegalStateException("Failed to read entry " + line + " in " + item + " but previous entry implied it was a directory");
    }

    private void addUrlFileToZip(ZipOutputStream zout, String root, String item, Predicate<? super String> filter) throws IOException {
        int startPos = item.indexOf(root);
        if (startPos < 0) {
            throw new IllegalStateException("URL of " + item + " does not appear relative to root " + root);
        }
        String itemE = item.substring(startPos + root.length());
        if (Strings.isEmpty((CharSequence)(itemE = Strings.removeFromStart((String)itemE, (String)"/")))) {
            return;
        }
        if (!filter.apply((Object)itemE)) {
            return;
        }
        InputStream itemFound = null;
        try {
            itemFound = this.resources.getResourceFromUrl(item);
            ZipEntry e = new ZipEntry(itemE);
            zout.putNextEntry(e);
            Streams.copy((InputStream)itemFound, (OutputStream)zout);
            zout.closeEntry();
        }
        catch (Exception e) {
            try {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(itemFound);
                throw throwable;
            }
        }
        Streams.closeQuietly((Closeable)itemFound);
    }

    public File createTempBundle(String nameHint, Manifest mf, Map<ZipEntry, InputStream> files) {
        File f2 = Os.newTempFile((String)nameHint, (String)"zip");
        ZipOutputStream zout = null;
        Closeable zf = null;
        try {
            zout = mf != null ? new JarOutputStream((OutputStream)new FileOutputStream(f2), mf) : new ZipOutputStream(new FileOutputStream(f2));
            this.writeZipEntries(zout, files);
        }
        catch (IOException e) {
            try {
                throw Exceptions.propagateAnnotated((String)("Unable to read/write for " + nameHint), (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(zf);
                Streams.closeQuietly(zout);
                throw throwable;
            }
        }
        Streams.closeQuietly(zf);
        Streams.closeQuietly((Closeable)zout);
        return f2;
    }

    public File createTempBundle(String nameHint, Map<String, String> mf, Map<ZipEntry, InputStream> files) {
        return this.createTempBundle(nameHint, this.manifestOf(mf), files);
    }

    public File createTempZip(String nameHint, Map<ZipEntry, InputStream> files) {
        return this.createTempBundle(nameHint, (Manifest)null, files);
    }
}

