/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.catalog.internal.CatalogClasspathDo;
import org.apache.brooklyn.core.catalog.internal.CatalogClasspathDto;
import org.apache.brooklyn.core.catalog.internal.CatalogDto;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDo;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDtoAbstract;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.AggregateClassLoader;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogDo {
    private static final Logger log = LoggerFactory.getLogger(CatalogDo.class);
    volatile boolean isLoaded = false;
    final CatalogDto dto;
    ManagementContext mgmt = null;
    CatalogDo parent = null;
    List<CatalogDo> childrenCatalogs = new ArrayList<CatalogDo>();
    CatalogClasspathDo classpath;
    private Map<String, CatalogItemDo<?, ?>> cacheById;
    AggregateClassLoader childrenClassLoader = AggregateClassLoader.newInstanceWithNoLoaders();
    ClassLoader recursiveClassLoader;

    protected CatalogDo(CatalogDto dto) {
        this.dto = (CatalogDto)Preconditions.checkNotNull((Object)dto);
    }

    public CatalogDo(ManagementContext mgmt, CatalogDto dto) {
        this(dto);
        this.mgmt = mgmt;
    }

    boolean isLoaded() {
        return this.isLoaded;
    }

    public CatalogDo load() {
        return this.load(null);
    }

    public CatalogDo load(CatalogDo parent) {
        return this.load(this.mgmt, parent);
    }

    public synchronized CatalogDo load(ManagementContext mgmt, CatalogDo parent) {
        return this.load(mgmt, parent, true);
    }

    public synchronized CatalogDo load(ManagementContext mgmt, CatalogDo parent, boolean failOnLoadError) {
        if (this.isLoaded()) {
            if (mgmt != null && !Objects.equal((Object)mgmt, (Object)this.mgmt)) {
                throw new IllegalStateException("Cannot set mgmt " + mgmt + " on " + this + " after catalog is loaded");
            }
            log.debug("Catalog " + this + " is already loaded");
            return this;
        }
        this.loadThisCatalog(mgmt, parent, failOnLoadError);
        this.loadChildrenCatalogs(failOnLoadError);
        this.buildCaches();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadThisCatalog(ManagementContext mgmt, CatalogDo parent, boolean failOnLoadError) {
        if (this.isLoaded()) {
            return;
        }
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Loading catalog {} into {}", this, parent);
        if (this.parent != null && !this.parent.equals(parent)) {
            log.warn("Catalog " + this + " being initialised with different parent " + parent + " when already parented by " + this.parent, new Throwable("source of reparented " + this));
        }
        if (this.mgmt != null && !this.mgmt.equals(mgmt)) {
            log.warn("Catalog " + this + " being initialised with different mgmt " + mgmt + " when already managed by " + this.mgmt, new Throwable("source of reparented " + this));
        }
        this.parent = parent;
        this.mgmt = mgmt;
        this.loadCatalogClasspath();
        this.loadCatalogItems(failOnLoadError);
        this.isLoaded = true;
        CatalogDo catalogDo = this;
        synchronized (catalogDo) {
            this.notifyAll();
        }
    }

    private void loadCatalogClasspath() {
        try {
            this.classpath = new CatalogClasspathDo(this);
            this.classpath.load();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.error("Unable to load catalog " + this + " (ignoring): " + e);
            log.info("Trace for failure to load " + this + ": " + e, (Throwable)e);
        }
    }

    private void loadCatalogItems(boolean failOnLoadError) {
        Iterable<CatalogItemDtoAbstract<?, ?>> entries = this.dto.getUniqueEntries();
        if (entries != null) {
            for (CatalogItemDtoAbstract<?, ?> entry : entries) {
                try {
                    CatalogUtils.installLibraries(this.mgmt, entry.getLibraries());
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (failOnLoadError) {
                        Exceptions.propagateAnnotated((String)("Loading bundles for catalog item " + entry.getCatalogItemId() + " failed"), (Throwable)e);
                        continue;
                    }
                    log.error("Loading bundles for catalog item " + entry + " failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockIfNotLoaded(Duration timeout) throws InterruptedException {
        if (this.isLoaded()) {
            return true;
        }
        CatalogDo catalogDo = this;
        synchronized (catalogDo) {
            if (this.isLoaded()) {
                return true;
            }
            CountdownTimer timer = CountdownTimer.newInstanceStarted((Duration)timeout);
            while (!this.isLoaded()) {
                if (timer.waitOnForExpiry((Object)this)) continue;
                return false;
            }
            return true;
        }
    }

    protected void loadChildrenCatalogs(boolean failOnLoadError) {
        if (this.dto.catalogs != null) {
            for (CatalogDto child : this.dto.catalogs) {
                this.loadCatalog(child, failOnLoadError);
            }
        }
    }

    CatalogDo loadCatalog(CatalogDto child, boolean failOnLoadError) {
        CatalogDo childL = new CatalogDo(child);
        this.childrenCatalogs.add(childL);
        childL.load(this.mgmt, this, failOnLoadError);
        this.childrenClassLoader.addFirst(childL.getRecursiveClassLoader());
        this.clearCache(false);
        return childL;
    }

    protected Map<String, CatalogItemDo<?, ?>> getIdCache() {
        Map<String, CatalogItemDo<?, ?>> cache = this.cacheById;
        if (cache == null) {
            cache = this.buildCaches();
        }
        return cache;
    }

    protected synchronized Map<String, CatalogItemDo<?, ?>> buildCaches() {
        if (this.cacheById != null) {
            return this.cacheById;
        }
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Building cache for {}", this);
        if (!this.isLoaded()) {
            log.debug("Catalog not fully loaded when loading cache of " + this);
        }
        LinkedHashMap cache = new LinkedHashMap();
        if (this.dto.catalogs != null) {
            ArrayList<CatalogDo> catalogsReversed = new ArrayList<CatalogDo>(this.childrenCatalogs);
            Collections.reverse(catalogsReversed);
            for (CatalogDo child : catalogsReversed) {
                cache.putAll(child.getIdCache());
            }
        }
        if (this.dto.getUniqueEntries() != null) {
            MutableList entriesReversed = MutableList.copyOf(this.dto.getUniqueEntries());
            Collections.reverse(entriesReversed);
            for (CatalogItemDtoAbstract entry : entriesReversed) {
                cache.put(entry.getId(), new CatalogItemDo(this, entry));
            }
        }
        this.cacheById = cache;
        return cache;
    }

    protected synchronized void clearCache(boolean deep) {
        this.cacheById = null;
        if (deep) {
            for (CatalogDo child : this.childrenCatalogs) {
                child.clearCache(true);
            }
        }
        this.clearParentCache();
    }

    protected void clearParentCache() {
        if (this.parent != null) {
            this.parent.clearCache(false);
        }
    }

    public synchronized void addEntry(CatalogItemDtoAbstract<?, ?> entry) {
        this.dto.addEntry(entry);
        if (this.cacheById != null) {
            CatalogItemDo cdo = new CatalogItemDo(this, entry);
            this.cacheById.put(entry.getId(), cdo);
        }
        this.clearParentCache();
        if (this.mgmt != null) {
            this.mgmt.getRebindManager().getChangeListener().onManaged(entry);
        }
    }

    public synchronized void deleteEntry(CatalogItemDtoAbstract<?, ?> entry) {
        this.dto.removeEntry(entry);
        if (this.cacheById != null) {
            this.cacheById.remove(entry.getId());
        }
        this.clearParentCache();
        if (this.mgmt != null) {
            this.mgmt.getRebindManager().getChangeListener().onUnmanaged(entry);
        }
    }

    CatalogDo addCatalog(CatalogDto child) {
        if (this.dto.catalogs == null) {
            this.dto.catalogs = new ArrayList<CatalogDto>();
        }
        this.dto.catalogs.add(child);
        if (!this.isLoaded()) {
            return null;
        }
        return this.loadCatalog(child, true);
    }

    public synchronized void addToClasspath(String ... urls) {
        if (this.dto.classpath == null) {
            this.dto.classpath = new CatalogClasspathDto();
        }
        for (String url : urls) {
            if (url == null) continue;
            this.dto.classpath.addEntry(url);
        }
        if (this.isLoaded()) {
            throw new IllegalStateException("dynamic classpath entry value update not supported");
        }
    }

    public synchronized void setClasspathScanForEntities(CatalogClasspathDo.CatalogScanningModes value) {
        if (this.dto.classpath == null) {
            this.dto.classpath = new CatalogClasspathDto();
        }
        this.dto.classpath.scan = value;
        if (this.isLoaded()) {
            throw new IllegalStateException("dynamic classpath scan value update not supported");
        }
    }

    public String toString() {
        String size = this.cacheById == null ? "not yet loaded" : "size " + this.cacheById.size();
        return "Loaded:" + this.dto + "(" + size + ")";
    }

    public ClassLoader getLocalClassLoader() {
        if (this.classpath != null) {
            return this.classpath.getLocalClassLoader();
        }
        return null;
    }

    public ClassLoader getRecursiveClassLoader() {
        if (this.recursiveClassLoader == null) {
            this.loadRecursiveClassLoader();
        }
        return this.recursiveClassLoader;
    }

    protected synchronized void loadRecursiveClassLoader() {
        if (this.recursiveClassLoader != null) {
            return;
        }
        AggregateClassLoader cl = AggregateClassLoader.newInstanceWithNoLoaders();
        cl.addFirst((ClassLoader)this.childrenClassLoader);
        ClassLoader local = this.getLocalClassLoader();
        if (local != null) {
            cl.addFirst(local);
        }
        if (this.parent == null) {
            ClassLoader base;
            ClassLoader classLoader = base = this.mgmt != null ? ((ManagementContextInternal)this.mgmt).getBaseClassLoader() : null;
            if (base != null) {
                cl.addFirst(base);
            } else {
                cl.addFirst(this.getClass().getClassLoader());
                cl.addFirst(Object.class.getClassLoader());
            }
        }
        this.recursiveClassLoader = cl;
    }

    public ClassLoader getRootClassLoader() {
        if (this.parent != null) {
            return this.parent.getRootClassLoader();
        }
        return this.getRecursiveClassLoader();
    }
}

