/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.failover;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.policy.failover.ElectPrimaryConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ElectPrimaryEffector
implements EntityInitializer,
ElectPrimaryConfig {
    private static final Logger log = LoggerFactory.getLogger(ElectPrimaryEffector.class);
    public static final Effector<Object> EFFECTOR = Effectors.effector(Object.class, (String)"electPrimary").description("Scan to detect whether there is or should be a new primary").buildAbstract();
    public static final AttributeSensor<PrimaryTransition> PRIMARY_TRANSITION = Sensors.newSensor(PrimaryTransition.class, (String)"primary.transition", (String)"Indicates primary is transitioning, cleared when completed");
    private final ConfigBag paramsCreationTime;

    public ElectPrimaryEffector(ConfigBag params) {
        this.paramsCreationTime = params;
    }

    public ElectPrimaryEffector(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public void apply(EntityLocal entity) {
        ((EntityInternal)entity).getMutableEntityType().addEffector(ElectPrimaryEffector.makeEffector(this.paramsCreationTime));
    }

    public static Effector<Object> makeEffector(ConfigBag params) {
        return Effectors.effector(EFFECTOR).impl((EffectorTasks.EffectorTaskFactory)new EffectorTasks.EffectorBodyTaskFactory((EffectorBody)new ElectPrimaryEffectorBody(params))).build();
    }

    private static Entity getCurrentActive(Entity entity, ConfigBag params) {
        return (Entity)entity.getAttribute(Sensors.newSensor(Entity.class, (String)((String)params.get(PRIMARY_SENSOR_NAME))));
    }

    private static class SelectionModeStrictFailedException
    extends UserFacingException {
        private static final long serialVersionUID = -6253854814553229953L;

        public SelectionModeStrictFailedException(Entity entity1, Entity entity2, double score) {
            super("Cannot select primary in strict mode: entities " + entity1 + " and " + entity2 + " have same score " + score);
        }
    }

    @VisibleForTesting
    public static class CheckPrimaries
    implements Callable<Entity> {
        final ConfigBag params;
        final Entity entity;

        public CheckPrimaries(Entity entity, ConfigBag params) {
            this.entity = entity;
            this.params = params;
        }

        @Override
        public Entity call() throws Exception {
            Stopwatch elapsedTime = Stopwatch.createStarted();
            boolean extendedForNonViableRunning = false;
            while (true) {
                Duration delay;
                ElectPrimaryConfig.TargetMode target;
                Collection candidates = (target = (ElectPrimaryConfig.TargetMode)((Object)this.params.get(ElectPrimaryConfig.TARGET_MODE))) == ElectPrimaryConfig.TargetMode.CHILDREN ? this.entity.getChildren() : (target == ElectPrimaryConfig.TargetMode.MEMBERS ? ((Group)this.entity).getMembers() : (this.entity instanceof Group ? ((Group)this.entity).getMembers() : this.entity.getChildren()));
                ElectPrimaryConfig.SelectionMode mode = (ElectPrimaryConfig.SelectionMode)((Object)this.params.get(ElectPrimaryConfig.SELECTION_MODE));
                Entity currentActive = ElectPrimaryEffector.getCurrentActive(this.entity, this.params);
                if (mode == ElectPrimaryConfig.SelectionMode.FAILOVER && currentActive != null && Iterables.contains((Iterable)candidates, (Object)currentActive) && this.isViable(currentActive)) {
                    return currentActive;
                }
                Duration delayForBest = Duration.ZERO;
                Duration period = Duration.millis((Number)10);
                if (candidates.iterator().hasNext()) {
                    MutableList weightedEntities = MutableList.of();
                    for (Entity candidate : candidates) {
                        weightedEntities.add(new WeightedEntity(candidate));
                    }
                    Collections.sort(weightedEntities);
                    WeightedEntity anyBestTheoreticalW = (WeightedEntity)weightedEntities.iterator().next();
                    WeightedEntity bestLive = null;
                    for (WeightedEntity w : weightedEntities) {
                        if (w.score < -1.0E-5) break;
                        if (Math.abs(anyBestTheoreticalW.score - w.score) >= 1.0E-10) {
                            if (bestLive != null || delayForBest.isLongerThan(elapsedTime)) break;
                            if (!this.isViable(w.entity)) continue;
                            log.debug("Theoretical best primary at " + this.entity + " (" + anyBestTheoreticalW + ", maybe others) not available, using next best: " + w);
                            return w.entity;
                        }
                        if (this.isViable(w.entity)) {
                            log.debug("Viable best primary at " + this.entity + " detected: " + w);
                            if (bestLive == null) {
                                bestLive = w;
                                continue;
                            }
                            if (mode == ElectPrimaryConfig.SelectionMode.STRICT) {
                                throw new SelectionModeStrictFailedException(w.entity, bestLive.entity, bestLive.score);
                            }
                            if (!w.entity.equals(currentActive)) continue;
                            bestLive = w;
                            continue;
                        }
                        Lifecycle state = (Lifecycle)w.entity.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
                        log.debug("Theoretical best primary at " + this.entity + ": " + w.entity + " " + (state == null ? "<no-state-yet>" : state) + " (not viable); may re-check");
                        if (state == Lifecycle.STARTING) {
                            delayForBest = Duration.max((Duration)delayForBest, (Duration)((Duration)this.entity.config().get(ElectPrimaryConfig.BEST_STARTING_WAIT_TIMEOUT)));
                            continue;
                        }
                        if (state == Lifecycle.RUNNING) {
                            if (extendedForNonViableRunning) continue;
                            delayForBest = Duration.max((Duration)delayForBest, (Duration)Duration.of((Object)elapsedTime).add((Duration)this.entity.config().get(ElectPrimaryConfig.BEST_WAIT_TIMEOUT)));
                            extendedForNonViableRunning = true;
                            continue;
                        }
                        delayForBest = Duration.max((Duration)delayForBest, (Duration)((Duration)this.entity.config().get(ElectPrimaryConfig.BEST_WAIT_TIMEOUT)));
                    }
                    if (bestLive != null) {
                        return bestLive.entity;
                    }
                } else {
                    delayForBest = (Duration)this.entity.config().get(ElectPrimaryConfig.BEST_WAIT_TIMEOUT);
                }
                if (!(delay = delayForBest.subtract(Duration.of((Object)elapsedTime))).isPositive()) break;
                delay = Duration.min((Duration)delay, (Duration)period);
                period = Duration.min((Duration)Duration.ONE_SECOND, (Duration)period.multiply(1.5));
                log.debug("Delaying " + delay + " (" + delayForBest + " allowed, " + Duration.of((Object)elapsedTime) + " elapsed) then rechecking for best primary at " + this.entity);
                Time.sleep((Duration)delay);
            }
            return null;
        }

        protected boolean isViable(Entity candidate) {
            if (!Lifecycle.RUNNING.equals(candidate.getAttribute(Attributes.SERVICE_STATE_ACTUAL))) {
                return false;
            }
            if (!Boolean.TRUE.equals(candidate.getAttribute(Attributes.SERVICE_UP))) {
                return false;
            }
            return !(this.score(candidate) <= -1.0E-9);
        }

        private double score(Entity candidate) {
            Double s = (Double)candidate.getAttribute(Sensors.newDoubleSensor((String)((String)this.params.get(ElectPrimaryConfig.PRIMARY_WEIGHT_NAME))));
            if (s != null) {
                return s;
            }
            s = (Double)candidate.getConfig(ConfigKeys.newDoubleConfigKey((String)((String)this.params.get(ElectPrimaryConfig.PRIMARY_WEIGHT_NAME))));
            if (s != null) {
                return s;
            }
            return 0.0;
        }

        private class WeightedEntity
        implements Comparable<WeightedEntity> {
            public final Entity entity;
            public final double score;

            public WeightedEntity(Entity candidate) {
                this.entity = candidate;
                this.score = CheckPrimaries.this.score(candidate);
            }

            @Override
            public int compareTo(WeightedEntity o) {
                double v = o.score - this.score;
                return v > 1.0E-8 ? 1 : (v < -1.0E-8 ? -1 : 0);
            }

            public String toString() {
                return this.entity + ":" + this.score;
            }
        }
    }

    protected static class ElectPrimaryEffectorBody
    extends EffectorBody<Object> {
        private final ConfigBag paramsCreationTime;

        public ElectPrimaryEffectorBody(ConfigBag paramsCreationTime) {
            this.paramsCreationTime = paramsCreationTime;
        }

        public Object call(ConfigBag paramsInvocationTime) {
            ConfigBag params = ConfigBag.newInstanceCopying((ConfigBag)this.paramsCreationTime).copy(paramsInvocationTime);
            try {
                boolean wasRunning;
                Entity newPrimary = (Entity)DynamicTasks.queue((String)"check primaries", (Callable)new CheckPrimaries((Entity)this.entity(), params)).getUnchecked();
                Entity currentActive = ElectPrimaryEffector.getCurrentActive((Entity)this.entity(), params);
                if (newPrimary == null) {
                    ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this.entity(), (String)"primary", (Object)"No primary could be found");
                    ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this.entity(), (String)"primary", (Object)"No primary could be found");
                    this.entity().sensors().set(Attributes.SERVICE_UP, (Object)false);
                    if (Lifecycle.RUNNING.equals((Object)ServiceStateLogic.getExpectedState((Entity)this.entity()))) {
                        this.entity().sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.ON_FIRE);
                    } else {
                        this.entity().sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.STOPPED);
                    }
                    this.entity().sensors().set(Sensors.newSensor(Entity.class, (String)((String)params.get(ElectPrimaryConfig.PRIMARY_SENSOR_NAME))), null);
                    ((Task)DynamicTasks.queue((TaskAdaptable)Tasks.create((String)("demote " + currentActive), (Callable)new Demote(params)))).getUnchecked();
                    return MutableMap.of((Object)"code", (Object)((Object)ResultCode.NO_PRIMARY_AVAILABLE), (Object)"message", (Object)"No primary available", (Object)"primary", null);
                }
                if (newPrimary.equals(currentActive)) {
                    return MutableMap.of((Object)"code", (Object)((Object)ResultCode.PRIMARY_UNCHANGED), (Object)"message", (Object)"No change required", (Object)"primary", (Object)newPrimary);
                }
                log.info("Detected new primary " + newPrimary + " at " + this.entity() + " (previously had " + currentActive + ")");
                ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this.entity(), (String)"primary", (Object)"Invoking promotion/demotion effectors");
                this.entity().sensors().set(PRIMARY_TRANSITION, (Object)new PrimaryTransition(currentActive, newPrimary));
                boolean bl = wasRunning = this.entity().sensors().get(Attributes.SERVICE_STATE_ACTUAL) == Lifecycle.RUNNING;
                if (wasRunning) {
                    log.debug("Transititioning " + this.entity() + " to starting while promoting/demoting");
                    ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STARTING);
                }
                ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this.entity(), (String)"primary");
                this.entity().sensors().set(Sensors.newSensor(Entity.class, (String)((String)params.get(ElectPrimaryConfig.PRIMARY_SENSOR_NAME))), (Object)newPrimary);
                try {
                    this.promoteAndDemote(params, currentActive, newPrimary);
                    log.debug("Promoted/demoted primary for " + this.entity() + ", now setting service up " + (wasRunning ? "and running" : "(but not setting as 'running' because it wasn't 'running' before)"));
                    ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this.entity(), (String)"primary");
                    if (wasRunning) {
                        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.RUNNING);
                    }
                    this.entity().sensors().set(PRIMARY_TRANSITION, null);
                    this.entity().sensors().remove(PRIMARY_TRANSITION);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.debug("Error promoting/demoting primary for " + this.entity() + " (rethrowing): " + e);
                    ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this.entity(), (String)"primary", (Object)Exceptions.collapseText((Throwable)e));
                    ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this.entity(), (String)"primary");
                    ServiceStateLogic.setExpectedStateRunningWithErrors((Entity)this.entity());
                    throw Exceptions.propagate((Throwable)e);
                }
                return MutableMap.of((Object)"code", (Object)((Object)ResultCode.NEW_PRIMARY_ELECTED), (Object)"message", (Object)"New primary found", (Object)"primary", (Object)newPrimary);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (Entities.isNoLongerManaged((Entity)this.entity())) {
                    return "<no-longer-managed>";
                }
                Lifecycle expected = ServiceStateLogic.getExpectedState((Entity)this.entity());
                if (expected == Lifecycle.RUNNING || expected == Lifecycle.STARTING) {
                    log.warn("Error electing new primary at " + this.entity() + ": " + Exceptions.collapseText((Throwable)e));
                    ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this.entity(), (String)"primary", (Object)("Error electing primary: " + Exceptions.collapseText((Throwable)e)));
                    this.entity().sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.ON_FIRE);
                    throw Exceptions.propagateAnnotated((String)("Error electing primary (when " + expected.toString().toLowerCase() + ")"), (Throwable)e);
                }
                throw Exceptions.propagateAnnotated((String)"Error electing primary (when not starting/running)", (Throwable)e);
            }
        }

        protected void promoteAndDemote(ConfigBag params, Entity oldPrimary, Entity newPrimary) {
            params.configureStringKey("oldPrimary", (Object)oldPrimary);
            params.configureStringKey("newPrimary", (Object)newPrimary);
            MutableList tasks = MutableList.of();
            if (newPrimary != null) {
                tasks.append((Object)Tasks.create((String)("promote " + newPrimary), (Callable)new Promote(params)));
            } else {
                tasks.append((Object)Tasks.warning((String)"No new primary; nothing to promote", null, (boolean)false));
            }
            if (oldPrimary != null) {
                tasks.append((Object)Tasks.create((String)("demote " + oldPrimary), (Callable)new Demote(params)));
            } else {
                tasks.append((Object)Tasks.warning((String)"No old primary; nothing to demote", null, (boolean)false));
            }
            log.debug("Running " + tasks);
            List result = (List)((Task)DynamicTasks.queue((TaskAdaptable)Tasks.parallel((String)"promote/demote", (Iterable)tasks))).getUnchecked();
            log.debug("Ran " + tasks + ", results: " + result);
        }

        protected class Demote
        implements Callable<Object> {
            final ConfigBag params;

            public Demote(ConfigBag params) {
                this.params = params;
            }

            @Override
            public Object call() throws Exception {
                String demoteEffectorName = (String)this.params.get(ElectPrimaryConfig.DEMOTE_EFFECTOR_NAME);
                Effector eff = ElectPrimaryEffectorBody.this.entity().getEffector(demoteEffectorName);
                if (eff != null) {
                    return DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)ElectPrimaryEffectorBody.this.entity(), (Effector)eff, (ConfigBag)this.params)).asTask().getUnchecked();
                }
                EntityInternal oldPrimary = (EntityInternal)this.params.getStringKey("oldPrimary");
                if (oldPrimary == null) {
                    return "Nothing to demote; no old primary";
                }
                if (Entities.isNoLongerManaged((Entity)oldPrimary)) {
                    return "Entity to demote is gone";
                }
                eff = oldPrimary.getEffector(demoteEffectorName);
                if (eff != null) {
                    return DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)oldPrimary, (Effector)eff, (ConfigBag)this.params)).asTask().getUnchecked();
                }
                if (this.params.containsKey(ElectPrimaryConfig.DEMOTE_EFFECTOR_NAME)) {
                    throw new IllegalStateException("Key " + ElectPrimaryConfig.DEMOTE_EFFECTOR_NAME.getName() + " set as " + demoteEffectorName + " but that effector isn't available on this entity or old primary " + oldPrimary);
                }
                return "No demotion effector '" + demoteEffectorName + "'; nothing to do";
            }
        }

        protected class Promote
        implements Callable<Object> {
            final ConfigBag params;

            public Promote(ConfigBag params) {
                this.params = params;
            }

            @Override
            public Object call() throws Exception {
                String promoteEffectorName = (String)this.params.get(ElectPrimaryConfig.PROMOTE_EFFECTOR_NAME);
                Effector eff = ElectPrimaryEffectorBody.this.entity().getEffector(promoteEffectorName);
                if (eff != null) {
                    return DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)ElectPrimaryEffectorBody.this.entity(), (Effector)eff, (ConfigBag)this.params)).asTask().getUnchecked();
                }
                EntityInternal newPrimary = (EntityInternal)this.params.getStringKey("newPrimary");
                if (newPrimary == null) {
                    return "Nothing to promote; no new primary";
                }
                eff = newPrimary.getEffector(promoteEffectorName);
                if (eff != null) {
                    return DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)newPrimary, (Effector)eff, (ConfigBag)this.params)).asTask().getUnchecked();
                }
                if (this.params.containsKey(ElectPrimaryConfig.PROMOTE_EFFECTOR_NAME)) {
                    throw new IllegalStateException("Key " + ElectPrimaryConfig.PROMOTE_EFFECTOR_NAME.getName() + " set as " + promoteEffectorName + " but that effector isn't available on this entity or new primary " + newPrimary);
                }
                return "No promotion effector '" + promoteEffectorName + "'; nothing to do";
            }
        }
    }

    public static class PrimaryTransition {
        public final Entity oldPrimary;
        public final Entity newPrimary;

        public PrimaryTransition(Entity currentActive, Entity newPrimary) {
            this.oldPrimary = currentActive;
            this.newPrimary = newPrimary;
        }
    }

    public static enum ResultCode {
        PRIMARY_UNCHANGED,
        NEW_PRIMARY_ELECTED,
        NO_PRIMARY_AVAILABLE;

    }
}

