/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.s3.blobstore.S3BlobRequestSigner;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.filters.RequestAuthorizeSignature;

public class AWSS3BlobRequestSignerV4
extends S3BlobRequestSigner<AWSS3Client> {
    private final RequestAuthorizeSignature authSigner;

    @Inject
    public AWSS3BlobRequestSignerV4(RestAnnotationProcessor processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Class<AWSS3Client> interfaceClass, RequestAuthorizeSignature authSigner) throws SecurityException, NoSuchMethodException {
        super(processor, blobToObject, blob2HttpGetOptions, interfaceClass, authSigner);
        this.authSigner = authSigner;
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)this.getMethod, (List)ImmutableList.of((Object)container, (Object)name)));
        request = this.authSigner.signForTemporaryAccess((HttpRequest)request, timeInSeconds);
        return BlobStoreUtils.cleanRequest((HttpRequest)request);
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob))));
        request = this.authSigner.signForTemporaryAccess((HttpRequest)request, timeInSeconds);
        return BlobStoreUtils.cleanRequest((HttpRequest)request);
    }
}

